/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsBase;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0013\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J \u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsSmall;", "T", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsBase;", "substitutions", "", "(Ljava/util/Collection;)V", "checkMatch", "", "unquotedRefText", "", "prefix", "suffix", "checkPrefix", "str", "equals", "other", "", "findMaxElementByPaths", "Lcom/intellij/openapi/util/Pair;", "textToMatch", "hashCode", "", "isEmpty", "intellij.javascript.psi.impl"})
final class JSModulePathMappingsSmall<T extends JSModulePathSubstitution>
extends JSModulePathMappingsBase<T> {
    public JSModulePathMappingsSmall(@NotNull Collection<? extends T> substitutions) {
        Intrinsics.checkNotNullParameter(substitutions, (String)"substitutions");
        super(substitutions);
    }

    @Override
    public boolean isEmpty() {
        return this.getSubstitutions().isEmpty();
    }

    @Override
    @Nullable
    public Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch) {
        Intrinsics.checkNotNullParameter((Object)textToMatch, (String)"textToMatch");
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePathSubstitution path2 : this.getSubstitutions()) {
            String suffix;
            String prefix;
            String pattern;
            Intrinsics.checkNotNullExpressionValue((Object)path2.getPattern(), (String)"getPattern(...)");
            int prefixMatchIndex = StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)0, (boolean)false, (int)6, null);
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path2.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                if (!Intrinsics.areEqual((Object)pattern, (Object)textToMatch)) continue;
                return Pair.create((Object)path2, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)pattern.substring(0, prefixMatchIndex), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)pattern.substring(suffixMatchIndex), (String)"substring(...)");
            if (!this.checkMatch(textToMatch, prefix, suffix) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            String string = textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            matchedElement = Pair.create((Object)path2, (Object)string);
        }
        return matchedElement;
    }

    private final boolean checkMatch(String unquotedRefText, String prefix, String suffix) {
        return unquotedRefText.length() >= prefix.length() + suffix.length() && this.checkPrefix(unquotedRefText, prefix) && StringsKt.endsWith$default((String)unquotedRefText, (String)suffix, (boolean)false, (int)2, null);
    }

    private final boolean checkPrefix(String str, String prefix) {
        int prefixLength = prefix.length();
        for (int i = prefixLength - 1; -1 < i; --i) {
            if (str.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof JSModulePathMappingsBase && Intrinsics.areEqual(((JSModulePathMappingsBase)other).getSubstitutions(), this.getSubstitutions());
    }

    public int hashCode() {
        return ((Object)this.getSubstitutions()).hashCode();
    }
}

