/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDataProvider;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDataProviderKt;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptor;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlDeprecationOwnerDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSXAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements JSXAttributeDescriptor,
XmlDeprecationOwnerDescriptor {
    private final String myAttributeName;
    @NotNull
    private final JSXAttributeDataProvider myValuesProvider;

    JSXAttributeDescriptorImpl(String attributeName, @NotNull JSXAttributeDataProvider valuesProvider) {
        if (valuesProvider == null) {
            JSXAttributeDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myAttributeName = attributeName;
        this.myValuesProvider = valuesProvider;
    }

    @Override
    @Nullable
    public JSType getValueType() {
        return this.myValuesProvider.getJSType();
    }

    public boolean isDeprecated() {
        return JSXAttributeDescriptorImpl.isAttributeDescriptorDeprecated(this);
    }

    @NotNull
    public static XmlAttributeDescriptor create(@NotNull String name, @Nullable PsiElement declaration, @Nullable JSType type2, boolean forceOptional) {
        if (name == null) {
            JSXAttributeDescriptorImpl.$$$reportNull$$$0(1);
        }
        return new JSXHtmlAttributeDescriptorImpl(name, JSXAttributeDataProviderKt.createEagerProvider(declaration, type2, forceOptional));
    }

    public boolean isRequired() {
        if (this.myValuesProvider.isWeakResolve()) {
            return false;
        }
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSOptionalOwner && declaration instanceof JSImplicitElement) {
            return !((JSOptionalOwner)declaration).isOptional();
        }
        if (declaration instanceof JSRecordType.PropertySignature) {
            return !((JSRecordType.PropertySignature)declaration).isOptional();
        }
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        String[] values = this.getEnumeratedValues();
        return values != null && values.length > 0;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myValuesProvider.getDeclaration();
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        DialectOptionHolder dialect = this.myValuesProvider.getDialect();
        if (dialect != null && dialect.isTypeScript && this.myValuesProvider.isLanguageServiceAvailable()) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        JSType type2 = this.getValueType();
        if (type2 instanceof JSBooleanType) {
            return new String[]{this.myAttributeName};
        }
        if (type2 != null) {
            ArrayList results = new ArrayList();
            if (type2 instanceof JSGenericTypeImpl) {
                type2 = type2.substitute();
            }
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
                if (t instanceof JSStringLiteralTypeImpl) {
                    results.add(((JSStringLiteralTypeImpl)t).getLiteral());
                }
                return true;
            }), type2, false, true, true);
            if (!results.isEmpty()) {
                return ArrayUtilRt.toStringArray(results);
            }
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static boolean isAttributeDescriptorDeprecated(@NotNull XmlAttributeDescriptor descriptor) {
        JSElementBase declaration;
        if (descriptor == null) {
            JSXAttributeDescriptorImpl.$$$reportNull$$$0(2);
        }
        return (declaration = (JSElementBase)ObjectUtils.tryCast((Object)descriptor.getDeclaration(), JSElementBase.class)) != null && declaration.isDeprecated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXAttributeDescriptorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAttributeDescriptorDeprecated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class JSXHtmlAttributeDescriptorImpl
    extends HtmlAttributeDescriptorImpl
    implements JSXAttributeDescriptor,
    PsiPresentableMetaData,
    XmlDeprecationOwnerDescriptor {
        private final JSXAttributeDataProvider myValuesProvider;

        JSXHtmlAttributeDescriptorImpl(String name, JSXAttributeDataProvider valuesProvider) {
            super((XmlAttributeDescriptor)new JSXAttributeDescriptorImpl(name, valuesProvider), true);
            this.myValuesProvider = valuesProvider;
        }

        JSXHtmlAttributeDescriptorImpl(@NotNull XmlAttributeDescriptor _delegate) {
            if (_delegate == null) {
                JSXHtmlAttributeDescriptorImpl.$$$reportNull$$$0(0);
            }
            super(_delegate, true);
            this.myValuesProvider = JSXAttributeDataProviderKt.createEagerProvider(null, null, false);
        }

        public String getTypeName() {
            JSType type2 = this.myValuesProvider.getJSType();
            if (type2 == null || JSTypeUtils.hasTypes(type2, JSEvaluableType.class)) {
                return null;
            }
            return JSTypeUtils.removeNullableComponents(type2).getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }

        @Nullable
        public Icon getIcon() {
            return JavaScriptLanguageIcons.Logos.Jsx_16;
        }

        @Override
        @Nullable
        public JSType getValueType() {
            return this.myValuesProvider.getJSType();
        }

        public boolean isDeprecated() {
            return JSXAttributeDescriptorImpl.isAttributeDescriptorDeprecated(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_delegate", "com/intellij/lang/javascript/frameworks/jsx/JSXAttributeDescriptorImpl$JSXHtmlAttributeDescriptorImpl", "<init>"));
        }
    }
}

