/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import com.intellij.webcore.formatter.comments.CommentWrapper;
import com.intellij.webcore.formatter.comments.DocCommentLineDataBuilder;
import com.intellij.webcore.formatter.comments.LineCommentLineDataBuilder;
import org.jetbrains.annotations.NotNull;

final class JSCommentPostFormatProcessor
implements PostFormatProcessor {
    JSCommentPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings2) {
        if (source == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(1);
        }
        Language sourceLang = source.getLanguage();
        if (source.isValid() && (sourceLang.isKindOf((Language)JavascriptLanguage.INSTANCE) || sourceLang.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT)) && JSCommentPostFormatProcessor.shouldWrapLongLines(settings2, sourceLang)) {
            PsiElement psiElement = new JSCommentVisitor(settings2, source, source.getProject(), sourceLang).process();
            if (psiElement == null) {
                JSCommentPostFormatProcessor.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings2) {
        if (source == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (rangeToReformat == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (settings2 == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(6);
        }
        Language sourceLang = source.getLanguage();
        if (source.isValid() && (sourceLang.isKindOf((Language)JavascriptLanguage.INSTANCE) || sourceLang.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT)) && JSCommentPostFormatProcessor.shouldWrapLongLines(settings2, sourceLang)) {
            TextRange textRange = new JSCommentVisitor(settings2, (PsiElement)source, source.getProject(), sourceLang).processText(rangeToReformat);
            if (textRange == null) {
                JSCommentPostFormatProcessor.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static boolean shouldWrapLongLines(@NotNull CodeStyleSettings settings2, @NotNull Language language) {
        if (settings2 == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(9);
        }
        if (language == null) {
            JSCommentPostFormatProcessor.$$$reportNull$$$0(10);
        }
        return settings2.getCommonSettings((Language)language).WRAP_COMMENTS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapLongLines";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class JSCommentVisitor
    extends JSRecursiveElementVisitor {
        private TextRange myOriginalRange;
        private final PsiElement mySource;
        private final Document myDocument;
        private int myDelta;
        private final Project myProject;
        private final int myRightMargin;
        private final CommonCodeStyleSettings myJsSettings;
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

        JSCommentVisitor(@NotNull CodeStyleSettings settings2, @NotNull PsiElement source, @NotNull Project project, @NotNull Language language) {
            if (settings2 == null) {
                JSCommentVisitor.$$$reportNull$$$0(0);
            }
            if (source == null) {
                JSCommentVisitor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                JSCommentVisitor.$$$reportNull$$$0(2);
            }
            if (language == null) {
                JSCommentVisitor.$$$reportNull$$$0(3);
            }
            this.mySource = source;
            this.myDocument = source.getContainingFile().getViewProvider().getDocument();
            this.myJsSettings = settings2.getCommonSettings(language);
            this.myIndentOptions = this.myJsSettings.getIndentOptions();
            assert (this.myIndentOptions != null);
            this.myRightMargin = settings2.getRightMargin(language);
            this.myProject = project;
        }

        PsiElement process() {
            if (this.myDocument == null) {
                return this.mySource;
            }
            this.myOriginalRange = this.mySource.getTextRange();
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.mySource;
        }

        TextRange processText(@NotNull TextRange rangeToReformat) {
            if (rangeToReformat == null) {
                JSCommentVisitor.$$$reportNull$$$0(4);
            }
            if (this.myDocument == null) {
                return rangeToReformat;
            }
            this.myOriginalRange = rangeToReformat;
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.myOriginalRange.grown(this.myDelta);
        }

        @Override
        public void visitJSDocComment(@NotNull JSDocComment docComment) {
            if (docComment == null) {
                JSCommentVisitor.$$$reportNull$$$0(5);
            }
            TextRange docRange = docComment.getTextRange();
            int start = docRange.getStartOffset() + this.myDelta;
            int end = docRange.getEndOffset() + this.myDelta;
            String newDoc = CommentWrapper.wrapCommentLines((CommentLineDataBuilder)new DocCommentLineDataBuilder((PsiElement)docComment, false, this.myJsSettings), (int)this.myRightMargin);
            if (newDoc != null) {
                int newLength = newDoc.length();
                this.myDelta += newLength - docComment.getTextLength();
                this.myDocument.replaceString(start, end, (CharSequence)newDoc);
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            String replacement;
            LineCommentLineDataBuilder lineDataBuilder;
            if (comment == null) {
                JSCommentVisitor.$$$reportNull$$$0(6);
            }
            if (comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && this.myOriginalRange.contains(comment.getTextRange()) && !(lineDataBuilder = new LineCommentLineDataBuilder(comment, JSTokenTypes.END_OF_LINE_COMMENT, this.myJsSettings, this.myOriginalRange)).isMergedWithPrevious(comment) && lineDataBuilder.canMerge(comment) && (replacement = CommentWrapper.wrapCommentLines((CommentLineDataBuilder)lineDataBuilder, (int)this.myRightMargin)) != null) {
                TextRange originalRange = lineDataBuilder.getCommentBlockRange();
                int start = originalRange.getStartOffset() + this.myDelta;
                int end = originalRange.getEndOffset() + this.myDelta;
                this.myDocument.replaceString(start, end, (CharSequence)replacement);
                this.myDelta += replacement.length() - originalRange.getLength();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToReformat";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docComment";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor$JSCommentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDocComment";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

