/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.widget;

import com.intellij.CommonBundle;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageServerConnector;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServiceLogDialogWrapper
extends DialogWrapper {
    private final Project myProject;
    private final ProcessHandler myProcessHandler;

    @RequiresEdt
    public FlowJSServiceLogDialogWrapper(@NotNull Project project, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            FlowJSServiceLogDialogWrapper.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            FlowJSServiceLogDialogWrapper.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.myProject = project;
        this.myProcessHandler = processHandler;
        if (processHandler instanceof ResendingOSProcessHandler) {
            ((ResendingOSProcessHandler)processHandler).stopAfterNextListenerAdded();
        }
        this.setTitle(JavaScriptBundle.message("js.flow.process.log", new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ConsoleViewImpl consoleView = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){
            private static final String TIMESTAMP_FORMAT_STRING = "HH:mm:ss.SSS";
            private final SimpleDateFormat TIMESTAMP_FORMAT;
            {
                this.TIMESTAMP_FORMAT = new SimpleDateFormat(TIMESTAMP_FORMAT_STRING);
            }

            public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (contentType == null) {
                    1.$$$reportNull$$$0(1);
                }
                StringBuilder builder2 = new StringBuilder();
                String[] lines = StringUtil.splitByLines((String)s, (boolean)true);
                boolean first = true;
                for (String line : lines) {
                    if (line.startsWith("Content-Length:")) continue;
                    if (first) {
                        builder2.append(this.TIMESTAMP_FORMAT.format(new Date())).append(' ');
                        first = false;
                    } else {
                        builder2.append(StringUtil.repeat((String)" ", (int)(TIMESTAMP_FORMAT_STRING.length() + 1)));
                    }
                    builder2.append(line).append('\n');
                }
                super.print(builder2.toString(), contentType);
            }

            public void attachToProcess(@NotNull ProcessHandler processHandler) {
                if (processHandler == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (processHandler instanceof FlowJSLanguageServerConnector.FlowJSLspProcessHandler) {
                    ((FlowJSLanguageServerConnector.FlowJSLspProcessHandler)processHandler).subscribeToInputStream(s -> this.print((String)s, ConsoleViewContentType.SYSTEM_OUTPUT));
                }
                super.attachToProcess(processHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processHandler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flow/widget/FlowJSServiceLogDialogWrapper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attachToProcess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)this.getDisposable(), (Disposable)consoleView);
        consoleView.attachToProcess(this.myProcessHandler);
        JSConsoleViewPanel panel2 = new JSConsoleViewPanel(this.myProject, null, null, (ConsoleView)consoleView, new AnAction[0]);
        panel2.setPreferredSize(consoleView.getPreferredSize());
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "JS.Flow.Service.Log";
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            FlowJSServiceLogDialogWrapper.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/widget/FlowJSServiceLogDialogWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/widget/FlowJSServiceLogDialogWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

