/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCommandWithArgument;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSStandardOutputProtocol
implements JSLanguageServiceProtocol {
    private static final Logger LOGGER = Logger.getInstance(FlowJSStandardOutputProtocol.class);
    private static final String SERVER_IS_READY = "Server is READY";
    private static final String ANOTHER_SERVER_RUNNING = "Error: another server is already running?";
    public static final String NO_FLOW_RUNNING_ERROR = "Error: There is no Flow server running";
    public static final String CREATING_NEW_SERVER = "Creating a new Flow server";
    @NotNull
    protected final Project myProject;
    @NotNull
    private final FlowJSConfig myConfig;
    @Nls
    private volatile String myInitializeError;
    private volatile boolean myUsingExternalServer;
    private volatile boolean myExternalServerDisconnected;

    public FlowJSStandardOutputProtocol(@NotNull Project project, @NotNull FlowJSConfig config) {
        if (project == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(0);
        }
        if (config == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfig = config;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        FlowJSSettings.FlowJSExecutable executable = this.getFlowExecutable();
        if (executable == null) {
            return null;
        }
        GeneralCommandLine line = executable.createCommandLine(this.myProject);
        line.addParameter("server");
        if (Registry.is((String)"javascript.flow.lazy.mode", (boolean)false)) {
            line.addParameter("--lazy-mode");
            line.addParameter("fs");
        }
        line.addParameter(this.myConfig.getConfigDirectory().getPath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        ResendingOSProcessHandler handler = new ResendingOSProcessHandler(line);
        handler.startNotify();
        return handler;
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler processHandler) throws InterruptedException {
        if (processHandler == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(2);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean succeeded = new AtomicBoolean(false);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text2 = event.getText()) != null && text2.contains(FlowJSStandardOutputProtocol.SERVER_IS_READY)) {
                    LOGGER.debug("IN: awaitReady received");
                    succeeded.set(true);
                    latch.countDown();
                } else if (text2 != null && text2.contains(FlowJSStandardOutputProtocol.ANOTHER_SERVER_RUNNING)) {
                    LOGGER.debug("IN: another server running received");
                    FlowJSStandardOutputProtocol.this.myUsingExternalServer = true;
                    succeeded.set(true);
                    latch.countDown();
                } else if (text2 != null && text2.contains(FlowJSStandardOutputProtocol.CREATING_NEW_SERVER)) {
                    LOGGER.debug("IN: Creating a new Flow server received");
                    succeeded.set(true);
                    latch.countDown();
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                FlowJSStandardOutputProtocol.this.myInitializeError = JavaScriptBundle.message("process.terminated", new Object[0]);
                latch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return latch.await(3L, TimeUnit.MINUTES) && succeeded.get();
    }

    @Override
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        FlowJSSettings.FlowJSExecutable flowExecutable;
        if (command == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(3);
        }
        if (data == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(4);
        }
        if ((flowExecutable = this.getFlowExecutable()) == null) {
            throw new IllegalStateException("No Flow executable configured");
        }
        FlowJSCommandWithArgument commandWithArgument = (FlowJSCommandWithArgument)command;
        OSProcessHandler handler = this.write(flowExecutable, commandWithArgument, resultConsumer);
        if (commandWithArgument.getInputStreamData() != null) {
            handler.getProcessInput().write(commandWithArgument.getInputStreamData().getBytes(StandardCharsets.UTF_8));
            handler.getProcessInput().close();
        }
        handler.startNotify();
        return handler;
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken != null) {
            this.killProcess(cancellationToken);
        }
    }

    protected void killProcess(@NotNull Object handler) {
        if (handler == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(5);
        }
        OSProcessHandler myHandler = (OSProcessHandler)handler;
        myHandler.destroyProcess();
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    public void dispose() {
    }

    @NotNull
    private OSProcessHandler write(@NotNull FlowJSSettings.FlowJSExecutable flowExecutable, final @NotNull FlowJSCommandWithArgument commandWithArgument, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (flowExecutable == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(6);
        }
        if (commandWithArgument == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(7);
        }
        GeneralCommandLine line = flowExecutable.createCommandLine(this.myProject);
        line.setWorkDirectory(commandWithArgument.getWorkingDirectory());
        line.addParameter(commandWithArgument.getCommand());
        commandWithArgument.getArguments().forEach(arg_0 -> ((GeneralCommandLine)line).addParameter(arg_0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        OSProcessHandler handler = new OSProcessHandler(line);
        final StringBuilder resultJson = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    JsonElement element;
                    String text2 = event.getText();
                    resultJson.append(text2);
                    if (resultConsumer != null && (element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString())) != null) {
                        resultConsumer.consume(new JSLanguageServiceAnswer(element));
                    }
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    int end;
                    int start;
                    String text3 = event.getText();
                    for (start = 0; start < text3.length() && Character.isWhitespace(text3.charAt(start)); ++start) {
                    }
                    for (end = text3.length(); end > 0 && Character.isWhitespace(end - 1); --end) {
                    }
                    if (start < end) {
                        LOGGER.warn("Error output from " + commandWithArgument.getCommand() + ": " + text3.substring(start, end));
                    }
                    if (text3.contains(FlowJSStandardOutputProtocol.NO_FLOW_RUNNING_ERROR) && FlowJSStandardOutputProtocol.this.myUsingExternalServer) {
                        FlowJSStandardOutputProtocol.this.myExternalServerDisconnected = true;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(8);
        }
        return oSProcessHandler;
    }

    @Nullable
    public static JsonElement parseJsonSafe(@NotNull String string) {
        if (string == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(9);
        }
        try {
            return new JsonParser().parse(string);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Nullable
    private FlowJSSettings.FlowJSExecutable getFlowExecutable() {
        return FlowJSSettingsManager.getInstance(this.myProject).getRawSettings().getFlowExecutable();
    }

    public boolean isUsingExternalServer() {
        return this.myUsingExternalServer;
    }

    public boolean isExternalServerDisconnected() {
        return this.myExternalServerDisconnected;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowExecutable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandWithArgument";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "killProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseJsonSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

