/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.flow.FlowJSAnnotationBuilder;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.flow.lsp.LspErrorObject;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceProjectErrors;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00102\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSHighlightingCache;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors;", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;Lcom/intellij/openapi/Disposable;)V", "getHighlights", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "file", "Lcom/intellij/psi/PsiFile;", "getPathAndErrors", "Lcom/intellij/openapi/util/Pair;", "", "diagnostics", "languageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "publishDiagnostics", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nFlowJSHighlightingCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowJSHighlightingCache.kt\ncom/intellij/lang/javascript/flow/lsp/FlowJSHighlightingCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1603#2,9:78\n1855#2:87\n1856#2:89\n1612#2:90\n1#3:88\n1#3:91\n*S KotlinDebug\n*F\n+ 1 FlowJSHighlightingCache.kt\ncom/intellij/lang/javascript/flow/lsp/FlowJSHighlightingCache\n*L\n50#1:78,9\n50#1:87\n50#1:89\n50#1:90\n50#1:88\n*E\n"})
public final class FlowJSHighlightingCache
extends JSLanguageServiceProjectErrors<PublishDiagnosticsParams> {
    @NotNull
    private final FlowJSConfig config;

    public FlowJSHighlightingCache(@NotNull Project project, @NotNull FlowJSConfig config, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, JSAnnotationErrorsFilter.KEEP_ALL);
        this.config = config;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        String string = this.config.getConfigDirectory().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.setProjectContext(FlowJSLspServiceKt.canonicalizePath(string), CollectionsKt.emptyList());
    }

    public final void publishDiagnostics(@NotNull PublishDiagnosticsParams diagnostics) {
        Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
        this.pushSemanticErrors(diagnostics, null);
        String string = diagnostics.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        String filePath = FlowJSLspServiceKt.toPath(string);
        ApplicationManager.getApplication().executeOnPooledThread(() -> FlowJSHighlightingCache.publishDiagnostics$lambda$2(this, filePath));
    }

    @NotNull
    public final List<JSAnnotationError> getHighlights(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        List list2 = (List)this.myErrors.get(new Pair((Object)FlowJSLspServiceKt.canonicalizePath(string), (Object)JSLanguageServiceProjectErrors.ServiceError.SEMANTICS));
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<String, List<JSAnnotationError>> getPathAndErrors(@NotNull PublishDiagnosticsParams diagnostics, @Nullable LanguageServiceInfo languageServiceInfo) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
        String string = diagnostics.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        String filePath = FlowJSLspServiceKt.toPath(string);
        List list2 = diagnostics.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDiagnostics(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSLanguageServiceAnnotationResult it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Diagnostic it = (Diagnostic)element$iv$iv;
            boolean bl2 = false;
            String string2 = this.config.getConfigDirectory().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Intrinsics.checkNotNull((Object)it);
            if (new FlowJSAnnotationBuilder(filePath, string2, false, new LspErrorObject(filePath, it)).toAnnotationResult() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        return new Pair((Object)FlowJSLspServiceKt.canonicalizePath(filePath), (Object)errors);
    }

    private static final void publishDiagnostics$lambda$2$lambda$1(FlowJSHighlightingCache this$0, String $filePath) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
        if (this$0.getProject().isDisposed()) {
            return;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($filePath);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            v1 = PsiManager.getInstance((Project)this$0.getProject()).findFile(it);
        } else {
            v1 = file = null;
        }
        if (file != null) {
            DaemonCodeAnalyzer.getInstance((Project)this$0.getProject()).restart(file);
        } else {
            DaemonCodeAnalyzer.getInstance((Project)this$0.getProject()).restart();
        }
    }

    private static final void publishDiagnostics$lambda$2(FlowJSHighlightingCache this$0, String $filePath) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
        ApplicationManager.getApplication().runReadAction(() -> FlowJSHighlightingCache.publishDiagnostics$lambda$2$lambda$1(this$0, $filePath));
    }
}

