/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.widget.FlowJSServiceProcessConnector;
import com.intellij.lang.javascript.flow.widget.FlowJSStatusBarWidget;
import com.intellij.lang.javascript.flow.widget.FlowServiceWidgetItem;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlowJSServerService
extends JSAsyncLanguageServiceBase
implements JSLanguageService {
    protected static final long COMPLETION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    protected static final long TYPEOF_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    protected static final long DEFINITION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    @NotNull
    protected final FlowJSConfig myConfig;

    public FlowJSServerService(@NotNull FlowJSConfig config, @NotNull Project project) {
        if (config == null) {
            FlowJSServerService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(1);
        }
        super(project, new FlowJSServiceProcessConnector(project));
        this.myConfig = config;
    }

    @Override
    @NotNull
    protected String getProcessName() {
        return "Flow";
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (project != null) {
            FlowJSStatusBarWidget.updateWidget(project);
        }
        return null;
    }

    @Nullable
    public abstract PsiElement getDefinitionOfElement(@NotNull Document var1, @NotNull PsiElement var2);

    @Nullable
    public abstract PsiElement findModuleOfElement(@NotNull Document var1, @NotNull PsiElement var2);

    @Nullable
    protected PsiElement getElementByPosition(@NotNull VirtualFile virtualFile, int line, int column) {
        PsiFile psiFile2;
        if (virtualFile == null) {
            FlowJSServerService.$$$reportNull$$$0(2);
        }
        if ((psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) == null) {
            return null;
        }
        if (line == -1) {
            return psiFile2;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile);
        if (provider == null) {
            return null;
        }
        Document document2 = provider.getDocument();
        if (document2 == null) {
            return null;
        }
        int offset = document2.getLineStartOffset(line) + column;
        PsiElement elementAtOffset = psiFile2.findElementAt(offset);
        if (elementAtOffset == null) {
            return null;
        }
        PsiElement meaningfulElement = PsiTreeUtil.findFirstParent((PsiElement)elementAtOffset, (boolean)false, t -> t instanceof JSVarStatement || t instanceof PsiNamedElement);
        if (meaningfulElement instanceof JSVarStatement) {
            JSInitializerOwner declaration = (JSInitializerOwner)ArrayUtil.getFirstElement((Object[])((JSVarStatement)meaningfulElement).getDeclarations());
            return declaration != null ? declaration : meaningfulElement;
        }
        return meaningfulElement != null ? meaningfulElement : elementAtOffset;
    }

    @Nullable
    @NlsSafe
    public String getTypeOfElementUnderProgress(@NotNull JSElement element) {
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(3);
        }
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                return (String)ReadAction.compute(() -> this.getTypeOfElement(element));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, JavaScriptBundle.message("flow.js.get.type", new Object[0]), true, element.getProject());
    }

    @Nullable
    protected abstract String getTypeOfElement(@NotNull JSElement var1);

    public abstract void beforeCompletion(@NotNull CompletionInitializationContext var1);

    @NotNull
    public static List<FlowJSSettings.FlowJSExecutable> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList<FlowJSSettings.FlowJSExecutable> paths = new ArrayList<FlowJSSettings.FlowJSExecutable>();
        ArrayList infos = new ArrayList();
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        NodeModuleSearchUtil.findModulesWithName(infos, "flow-bin", project.getBaseDir(), interpreter2);
        for (CompletionModuleInfo info2 : infos) {
            VirtualFile moduleDir = info2.getVirtualFile();
            if (moduleDir == null) continue;
            File moduleFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleDir);
            paths.add(new FlowJSSettings.FlowJSExecutable(moduleFile));
        }
        if (paths.isEmpty()) {
            String execFileName = FlowJSServerService.getFlowExecutableFilename();
            List files2 = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
            for (File file : files2) {
                paths.add(new FlowJSSettings.FlowJSExecutable(file));
            }
        }
        ArrayList<FlowJSSettings.FlowJSExecutable> arrayList = paths;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    static String getFlowExecutableFilename() {
        return SystemInfo.isWindows ? "flow.exe" : "flow";
    }

    @Nullable
    public static String isFlowServerAvailable(@Nullable FlowJSSettings.FlowJSExecutable flowJSExecutable, @NotNull Project project) {
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(5);
        }
        if (flowJSExecutable == null) {
            return JavaScriptBundle.message("js.flow.enable.flow.service.error.empty", new Object[0]);
        }
        CompletableFuture<String> future = flowJSExecutable.evaluateVersion(project);
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return JavaScriptBundle.message("js.flow.enable.flow.service.error.on.checking", "Process doesn't respond");
        }
        catch (ExecutionException e) {
            return e.getCause().getMessage();
        }
        catch (InterruptedException e) {
            return JavaScriptBundle.message("js.flow.enable.flow.service.error.on.checking", "Checking interrupted");
        }
        return null;
    }

    public static boolean isLspAvailable(@NotNull Project project) throws Exception {
        FlowJSSettings.FlowJSExecutable executable;
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(6);
        }
        if ((executable = FlowJSSettingsManager.getInstance(project).getRawSettings().getFlowExecutable()) == null) {
            throw new IllegalStateException("Flow executable is not set");
        }
        CompletableFuture<String> future = executable.evaluateVersion(project);
        String versionText = future.get(5L, TimeUnit.SECONDS);
        SemVer semVer = SemVer.parseFromText((String)versionText);
        if (semVer == null) {
            throw new Exception("Invalid version " + versionText);
        }
        return semVer.isGreaterOrEqualThan(0, 83, 0);
    }

    @NotNull
    public abstract Map<String, String> getCompletionOfElement(@NotNull PsiFile var1, @NotNull Document var2, @NotNull CompletionParameters var3, @NotNull String var4);

    @NotNull
    public abstract List<JSAnnotationError> getCoverageOfFile(@NotNull PsiFile var1);

    @NotNull
    public FlowJSConfig getConfig() {
        FlowJSConfig flowJSConfig = this.myConfig;
        if (flowJSConfig == null) {
            FlowJSServerService.$$$reportNull$$$0(7);
        }
        return flowJSConfig;
    }

    public boolean isServiceStarted() {
        if (!this.checkCanUseService()) {
            return false;
        }
        JSLanguageServiceExecutor process = this.getProcessIfCreated();
        return process != null && process.getState() == JSLanguageServiceExecutor.State.STARTED;
    }

    @Nullable
    public static String getTypeIfServiceEnabled(@NotNull PsiElement element) {
        String typeFromService;
        PsiFile file;
        FlowJSServerService service2;
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(8);
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSNamedElement) && (service2 = FlowJSServerManager.getService(file = element.getContainingFile())) != null && FlowJSSettingsManager.areOtherServicesEnabled(file) && (typeFromService = service2.getTypeOfElement((JSElement)element)) != null) {
            return XmlUtil.escape((String)typeFromService);
        }
        return null;
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    public boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(10);
        }
        return !LightEdit.owns((Project)this.myProject) && FlowJSServerService.isAcceptableFile(file, it -> DialectDetector.JAVASCRIPT_FILE_TYPES.contains(it.getFileType()));
    }

    @Override
    public boolean isServiceCreated() {
        return this.getProcessIfCreated() != null;
    }

    @Override
    protected boolean needInitToolWindow() {
        FlowJSServerManager serverManager = FlowJSServerManager.getInstance(this.myProject);
        return serverManager != null && serverManager.isFlowAvailable();
    }

    @NotNull
    protected static List<Document> getUnsavedFlowDocuments(@NotNull Project project, @Nullable VirtualFile exceptThis) {
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(11);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        List list2 = ContainerUtil.filter((Object[])FileDocumentManager.getInstance().getUnsavedDocuments(), document2 -> {
            VirtualFile file = documentManager.getFile(document2);
            return file != null && !file.equals(exceptThis) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType()) && !FlowJSServerService.isOpenedInOtherProjectAndNotThis(file, project);
        });
        if (list2 == null) {
            FlowJSServerService.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static boolean isOpenedInOtherProjectAndNotThis(@NotNull VirtualFile file, @NotNull Project currentProject) {
        Project[] openedProjects;
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(13);
        }
        if (currentProject == null) {
            FlowJSServerService.$$$reportNull$$$0(14);
        }
        if ((openedProjects = ProjectManager.getInstance().getOpenProjects()).length <= 1) {
            return false;
        }
        if (ProjectFileIndex.getInstance((Project)currentProject).getModuleForFile(file, false) != null) {
            return false;
        }
        for (Project otherProject : openedProjects) {
            if (otherProject == currentProject || ProjectFileIndex.getInstance((Project)otherProject).getModuleForFile(file, false) == null) continue;
            return true;
        }
        return false;
    }

    public static void saveFiles(Collection<? extends Document> unsavedDocuments) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document2 : unsavedDocuments) {
            fileDocumentManager.saveDocument(document2);
        }
    }

    @RequiresEdt
    public void shutdown() {
        ThreadingAssertions.assertEventDispatchThread();
        this.restart(true);
    }

    public static boolean isAcceptableFile(@Nullable VirtualFile virtualFile, @NotNull Predicate<VirtualFile> fileTypeChecker) {
        if (fileTypeChecker == null) {
            FlowJSServerService.$$$reportNull$$$0(15);
        }
        return virtualFile != null && virtualFile.isInLocalFileSystem() && virtualFile.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER) == null && fileTypeChecker.test(virtualFile);
    }

    @Override
    @Nullable
    public LanguageServiceWidgetItem createWidgetItem(@Nullable VirtualFile currentFile) {
        return new FlowServiceWidgetItem(this, currentFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProject";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPossibleFlowExecutableFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedFlowDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementByPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfElementUnderProgress";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFlowServerAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLspAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfServiceEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedFlowDocuments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedInOtherProjectAndNotThis";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 12 -> new IllegalStateException(string);
        };
    }
}

