/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.ErrorObject;
import com.intellij.lang.javascript.flow.ExtraMessageObject;
import com.intellij.lang.javascript.flow.Location;
import com.intellij.lang.javascript.flow.MessageObject;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u000b2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JF\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0016\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u00112\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/flow/FlowJSAnnotationBuilder;", "", "targetFilePath", "", "baseDirectoryPath", "useOldFormat", "", "errorObject", "Lcom/intellij/lang/javascript/flow/ErrorObject;", "(Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/lang/javascript/flow/ErrorObject;)V", "addChildren", "", "extra", "", "Lcom/intellij/lang/javascript/flow/ExtraMessageObject;", "errorDetails", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addLinkOpenTag", "location", "Lcom/intellij/lang/javascript/flow/Location;", "addMessage", "errorText", "messageObject", "Lcom/intellij/lang/javascript/flow/MessageObject;", "addLink", "isFirstMessage", "severalMessagesInRow", "toAnnotationResult", "Lcom/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult;", "intellij.javascript.impl"})
public final class FlowJSAnnotationBuilder {
    @Nullable
    private final String targetFilePath;
    @NotNull
    private final String baseDirectoryPath;
    private final boolean useOldFormat;
    @NotNull
    private final ErrorObject errorObject;

    public FlowJSAnnotationBuilder(@Nullable String targetFilePath, @NotNull String baseDirectoryPath, boolean useOldFormat, @NotNull ErrorObject errorObject) {
        Intrinsics.checkNotNullParameter((Object)baseDirectoryPath, (String)"baseDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)errorObject, (String)"errorObject");
        this.targetFilePath = targetFilePath;
        this.baseDirectoryPath = baseDirectoryPath;
        this.useOldFormat = useOldFormat;
        this.errorObject = errorObject;
    }

    @Nullable
    public final JSLanguageServiceAnnotationResult toAnnotationResult() {
        StringBuilder errorText = new StringBuilder();
        StringBuilder errorDetails = new StringBuilder();
        Location mainLocation = null;
        List<MessageObject> messageArray = this.errorObject.getMessages();
        boolean isFirstMessage = true;
        for (MessageObject message : messageArray) {
            if (isFirstMessage) {
                errorDetails.append("Flow: ");
            }
            Location location = this.addMessage(errorText, errorDetails, message, false, isFirstMessage, messageArray.size() > 1);
            if (message.isBlame() && mainLocation == null && location != null) {
                mainLocation = location;
            }
            isFirstMessage = false;
        }
        if (this.targetFilePath != null && mainLocation != null && !FileUtil.pathsEqual((String)this.targetFilePath, (String)mainLocation.getFilePath())) {
            return null;
        }
        List<ExtraMessageObject> extra = this.errorObject.getExtra();
        Collection collection = extra;
        if (!(collection == null || collection.isEmpty())) {
            errorDetails.append("<br/>");
            this.addChildren(extra, errorDetails);
        }
        Location location = mainLocation;
        Location location2 = mainLocation;
        Location location3 = mainLocation;
        Location location4 = mainLocation;
        Location location5 = mainLocation;
        return new JSLanguageServiceAnnotationResult(errorText.toString(), errorDetails.toString(), location != null ? location.getFilePath() : null, this.errorObject.getErrorCategory(), location2 != null ? location2.getLine() : 0, location3 != null ? location3.getColumn() : 0, location4 != null ? location4.getLineEnd() : 0, location5 != null ? location5.getColumnEnd() : 0);
    }

    private final Location addMessage(StringBuilder errorText, StringBuilder errorDetails, MessageObject messageObject, boolean addLink, boolean isFirstMessage, boolean severalMessagesInRow) {
        Location location;
        block7: {
            String descr = messageObject.getDescr();
            location = messageObject.getLocation();
            if (!isFirstMessage) {
                errorDetails.append(' ');
                StringBuilder stringBuilder = errorText;
                if (stringBuilder != null) {
                    stringBuilder.append(' ');
                }
            }
            if (this.useOldFormat && location != null) {
                this.addLinkOpenTag(errorDetails, location);
            }
            errorDetails.append(XmlUtil.escape((String)descr));
            StringBuilder stringBuilder = errorText;
            if (stringBuilder != null) {
                stringBuilder.append(descr);
            }
            if (this.useOldFormat && location != null) {
                errorDetails.append("</a>");
            }
            if (!this.useOldFormat && location != null && addLink) {
                errorDetails.append(": ");
                this.addLinkOpenTag(errorDetails, location);
                errorDetails.append(FileUtil.getRelativePath((String)this.baseDirectoryPath, (String)location.getFilePath(), (char)File.separatorChar)).append(":").append(location.getLine()).append("</a>");
            }
            if (!isFirstMessage || !severalMessagesInRow) break block7;
            errorDetails.append('.');
            StringBuilder stringBuilder2 = errorText;
            if (stringBuilder2 != null) {
                stringBuilder2.append('.');
            }
        }
        return location;
    }

    private final void addLinkOpenTag(StringBuilder errorDetails, Location location) {
        errorDetails.append("<a href='#navigation_logical/").append(location.getFilePath()).append(":").append(location.getLine()).append(":").append(location.getColumn()).append("'>");
    }

    private final void addChildren(List<? extends ExtraMessageObject> extra, StringBuilder errorDetails) {
        for (ExtraMessageObject extraMessageObject : extra) {
            List<MessageObject> messageArray = extraMessageObject.getMessages();
            boolean isFirst = true;
            errorDetails.append("<br/>");
            for (MessageObject message : messageArray) {
                this.addMessage(null, errorDetails, message, true, isFirst, messageArray.size() > 1);
                isFirst = false;
            }
            List<ExtraMessageObject> children = extraMessageObject.getChildren();
            if (children == null) continue;
            this.addChildren(children, errorDetails);
        }
    }
}

