/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptClassMemberModifiersStructure;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptExpressionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptFunctionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptStatementParser
extends ES6StatementParser<TypeScriptParser> {
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new TypeScriptClassMemberModifiersStructure();
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder2 -> {
        IElementType token = builder2.getTokenType();
        return TypeScriptStatementParser.isPropertyNameStart(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    };

    protected TypeScriptStatementParser(TypeScriptParser parser2) {
        super(parser2);
    }

    @Override
    public void parseStatement() {
        IElementType firstToken = this.builder.getTokenType();
        IElementType lookahead = this.builder.lookAhead(1);
        if (firstToken == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR && this.builder.lookAhead(1) != JSTokenTypes.DOT) {
            this.parseES6ImportStatement();
            return;
        }
        if (firstToken == JSTokenTypes.EXPORT_KEYWORD && this.tryParseES6ExportStatement()) {
            return;
        }
        if (JSKeywordSets.MODULES.contains(firstToken) && (this.isIdentifierToken(lookahead) || JSTokenTypes.STRING_LITERALS.contains(lookahead)) || firstToken == JSTokenTypes.GLOBAL_KEYWORD && lookahead == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseModuleNoMarker(marker);
            return;
        }
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(lookahead)) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseTypeAlias(marker);
            return;
        }
        if (firstToken == JSTokenTypes.INTERFACE_KEYWORD && this.isIdentifierToken(lookahead)) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseInterfaceNoMarker(marker);
            return;
        }
        super.parseStatement();
    }

    @Override
    protected boolean shouldParseTypeExports(IElementType type2) {
        return type2 == JSTokenTypes.TYPE_KEYWORD;
    }

    @Override
    protected boolean shouldParseTypeImports(IElementType type2) {
        return type2 == JSTokenTypes.TYPE_KEYWORD;
    }

    private void parseTypeAlias(PsiBuilder.Marker marker) {
        TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
    }

    public static void parseTypeAlias(PsiBuilder.Marker marker, PsiBuilder builder2, ES6Parser parser2) {
        LOG.assertTrue(JSTokenTypes.TYPE_KEYWORD == builder2.getTokenType());
        builder2.advanceLexer();
        if (!parser2.isIdentifierToken(builder2.getTokenType())) {
            builder2.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return;
        }
        builder2.advanceLexer();
        ((JSPsiTypeParser)parser2.getTypeParser()).tryParseTypeParameterList();
        ((JSPsiTypeParser)parser2.getTypeParser()).parseTypeAliasType();
        ((StatementParser)parser2.getStatementParser()).forceCheckForSemicolon();
        marker.done(JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseES6ImportStatement() {
        if (this.isImportStatement()) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseImportStatementNoMarker(marker);
            return;
        }
        super.parseES6ImportStatement();
    }

    private boolean isImportStatement() {
        IElementType type2 = this.builder.lookAhead(1);
        int offset = 1;
        if (type2 == JSTokenTypes.TYPE_KEYWORD && JSTokenTypes.EQ != this.builder.lookAhead(offset + 1)) {
            ++offset;
        }
        return this.isIdentifierToken(this.builder.lookAhead(offset)) && this.builder.lookAhead(offset + 1) == JSTokenTypes.EQ;
    }

    @Override
    protected boolean tryParseES6ExportStatement() {
        IElementType lookAhead = this.builder.lookAhead(1);
        if (lookAhead == JSTokenTypes.EQ) {
            this.parseExportAssignment();
            return true;
        }
        if (lookAhead == JSTokenTypes.AS_KEYWORD) {
            PsiBuilder.Marker globalExport = this.builder.mark();
            this.parseGlobalModuleExportNoMarker(globalExport);
            return true;
        }
        return super.tryParseES6ExportStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseModuleNoMarker(PsiBuilder.Marker marker) {
        @Nullable FunctionParser.MethodEmptiness methodsMustBeEmpty = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        try {
            boolean nextLBrace;
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.POSSIBLY);
            PsiBuilder.Marker markerBeforeKeyword = this.builder.mark();
            IElementType type2 = this.builder.getTokenType();
            boolean isGlobalModule = type2 == JSTokenTypes.GLOBAL_KEYWORD;
            LOG.assertTrue(isGlobalModule || JSKeywordSets.MODULES.contains(type2));
            this.builder.advanceLexer();
            SmartList modules2 = new SmartList((Object)marker);
            boolean external = false;
            if (!isGlobalModule) {
                if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
                    ((TypeScriptParser)this.myJavaScriptParser).buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
                    external = true;
                } else if (!this.parseInternalModuleName(marker, markerBeforeKeyword, (SmartList<PsiBuilder.Marker>)modules2)) {
                    markerBeforeKeyword.drop();
                    return;
                }
            }
            markerBeforeKeyword.drop();
            boolean bl = nextLBrace = this.builder.getTokenType() == JSTokenTypes.LBRACE;
            if (!external || nextLBrace) {
                this.parseBlockAndAttachStatementsDirectly();
            }
            if (external && !nextLBrace) {
                ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).forceCheckForSemicolon();
            }
            ((PsiBuilder.Marker)modules2.get(modules2.size() - 1)).done(JSStubElementTypes.TYPESCRIPT_MODULE);
            for (int i = modules2.size() - 2; i >= 0; --i) {
                ((PsiBuilder.Marker)modules2.get(i)).done(TypeScriptStubElementTypes.IMPLICIT_MODULE);
            }
            ((PsiBuilder.Marker)modules2.get(0)).setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
        }
    }

    private boolean parseInternalModuleName(PsiBuilder.Marker marker, PsiBuilder.Marker markerBeforeKeyword, SmartList<PsiBuilder.Marker> modules2) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return false;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() == JSTokenTypes.DOT) {
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
            expr = expr.precede();
            this.builder.advanceLexer();
            modules2.add((Object)markerBeforeKeyword.precede());
            if (this.checkIdentifier()) continue;
        }
        expr.drop();
        return true;
    }

    private void parseImportStatementNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.TYPE_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.EQ) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.equal", new Object[0]));
            marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
            return;
        }
        this.builder.advanceLexer();
        PsiBuilder.Marker referenceMarker = this.builder.mark();
        IElementType referenceStartType = this.builder.getTokenType();
        if (!this.checkIdentifier()) {
            referenceMarker.drop();
            marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
            return;
        }
        if ((referenceStartType == JSTokenTypes.REQUIRE_KEYWORD || JSKeywordSets.MODULES.contains(referenceStartType)) && this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.builder.advanceLexer();
            if (!TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.STRING_LITERAL, "javascript.parser.message.expected.string.literal") || !TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen")) {
                referenceMarker.drop();
                marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
                return;
            }
            referenceMarker.done(TypeScriptStubElementTypes.EXTERNAL_MODULE_REFERENCE);
        } else {
            while (this.builder.getTokenType() == JSTokenTypes.DOT) {
                PsiBuilder.Marker precede = referenceMarker.precede();
                referenceMarker.done(TypeScriptStubElementTypes.ENTITY_NAME);
                referenceMarker = precede;
                this.builder.advanceLexer();
                if (this.checkIdentifier()) continue;
                referenceMarker.drop();
                marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
                return;
            }
            referenceMarker.done(TypeScriptStubElementTypes.ENTITY_NAME);
        }
        ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
    }

    public static boolean isConstEnum(PsiBuilder builder2) {
        return builder2.getTokenType() == JSTokenTypes.CONST_KEYWORD && builder2.lookAhead(1) == JSTokenTypes.ENUM_KEYWORD;
    }

    private void parseGlobalModuleExportNoMarker(PsiBuilder.Marker globalExport) {
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        if (!TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.NAMESPACE_KEYWORD, "javascript.parser.message.expected.namespace")) {
            globalExport.done(TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT);
            return;
        }
        this.checkIdentifier();
        this.checkForSemicolon();
        globalExport.done(TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT);
    }

    private void parseExportAssignment() {
        PsiBuilder.Marker exportAssignment = this.builder.mark();
        assert (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        assert (this.builder.getTokenType() == JSTokenTypes.EQ);
        this.builder.advanceLexer();
        ((TypeScriptExpressionParser)((TypeScriptParser)this.myJavaScriptParser).getExpressionParser()).parseAssignmentExpression(false);
        ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        exportAssignment.done(TypeScriptStubElementTypes.EXPORT_ASSIGNMENT);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS.contains(tokenType)) {
            this.parseModuleNoMarker(marker);
            return true;
        }
        if (this.isGlobalModuleExport()) {
            this.parseGlobalModuleExportNoMarker(marker);
            return true;
        }
        if (tokenType == JSTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatementNoMarker(marker);
            return true;
        }
        if (tokenType == JSTokenTypes.TYPE_KEYWORD) {
            this.parseTypeAlias(marker);
            return true;
        }
        return super.parseDialectSpecificSourceElements(marker);
    }

    public boolean isGlobalModuleExport() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AS_KEYWORD;
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker block) {
        if (block == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(0);
        }
        TypeScriptStatementParser.parseInterface(block, this, (ES6Parser)this.myJavaScriptParser, this.builder);
    }

    public static void parseInterface(@NotNull PsiBuilder.Marker block, @NotNull StatementParser<?> statementParser, @NotNull ES6Parser<?, ?, ?, ? extends TypeScriptPsiTypeParser> parser2, @NotNull PsiBuilder builder2) {
        if (block == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(1);
        }
        if (statementParser == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(2);
        }
        if (parser2 == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(3);
        }
        if (builder2 == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(JSTokenTypes.INTERFACE_KEYWORD == builder2.getTokenType());
        builder2.advanceLexer();
        IElementType startToken = builder2.getTokenType();
        if (!parser2.isIdentifierToken(startToken)) {
            builder2.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (!statementParser.canProceedClassParsing(startToken)) {
                block.done(JSStubElementTypes.TYPESCRIPT_INTERFACE);
                return;
            }
        } else {
            builder2.advanceLexer();
        }
        ((TypeScriptPsiTypeParser)parser2.getTypeParser()).tryParseTypeParameterList();
        if (builder2.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            ((ES6StatementParser)parser2.getStatementParser()).parseReferenceList((IElementType)JSStubElementTypes.EXTENDS_LIST);
        } else if (builder2.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
            ((ES6StatementParser)parser2.getStatementParser()).parseReferenceList((IElementType)JSStubElementTypes.IMPLEMENTS_LIST);
        }
        ((TypeScriptPsiTypeParser)parser2.getTypeParser()).parseObjectType();
        block.done(JSStubElementTypes.TYPESCRIPT_INTERFACE);
        block.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        if (this.parseStaticBlock()) {
            return;
        }
        PsiBuilder.Marker classMember = this.builder.mark();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults = this.parseClassMemberModifiers();
        if (((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).isIndexSignatureProperty()) {
            ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseIndexSignatureNoMarker(classMember, true);
        } else {
            this.parseStandardClassMember(classMember, modifiersParseResults);
        }
    }

    @Override
    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = ((TypeScriptParser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
        if (enumSet == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(5);
        }
        return enumSet;
    }

    @Override
    protected IElementType getClassElementType() {
        return JSStubElementTypes.TYPESCRIPT_CLASS;
    }

    @Override
    protected IElementType getClassExpressionElementType() {
        return JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION;
    }

    @Override
    protected void parseES6ExportDefaultAssignmentBody() {
        if (this.builder.getTokenType() == JSTokenTypes.ABSTRACT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            boolean parsed = ((TypeScriptFunctionParser)((TypeScriptParser)this.myJavaScriptParser).getFunctionParser()).parseAttributesList();
            if (parsed) {
                this.parseClassNoMarker(marker, true, true);
            } else {
                marker.rollbackTo();
                super.parseES6ExportDefaultAssignmentBody();
            }
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseInterfaceNoMarker(marker);
            return;
        }
        super.parseES6ExportDefaultAssignmentBody();
    }

    @Override
    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.variable.name", new Object[0]));
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
        return true;
    }

    @Override
    public IElementType getVariableElementType() {
        return TypeScriptStubElementTypes.TYPESCRIPT_VARIABLE;
    }

    @Override
    public IElementType getFieldElementType() {
        return TypeScriptStubElementTypes.TYPESCRIPT_FIELD;
    }

    @Override
    protected boolean isPossibleStartStatementModifier(IElementType token) {
        if (token == JSTokenTypes.IN_KEYWORD || token == JSTokenTypes.OUT_KEYWORD) {
            return false;
        }
        if (token == JSTokenTypes.ABSTRACT_KEYWORD) {
            IElementType type2 = this.builder.lookAhead(1);
            return type2 == null || type2 == JSTokenTypes.CLASS_KEYWORD || type2 == JSTokenTypes.TYPE_KEYWORD || type2 == JSTokenTypes.ENUM_KEYWORD || type2 == JSTokenTypes.INTERFACE_KEYWORD;
        }
        if (token == JSTokenTypes.OVERRIDE_KEYWORD || token == JSTokenTypes.READONLY_KEYWORD) {
            return false;
        }
        return super.isPossibleStartStatementModifier(token) || TypeScriptStatementParser.isConstEnum(this.builder);
    }

    @Override
    protected void checkMemberFunctionSuffix() {
    }

    @Override
    protected boolean isExportDefaultBinding() {
        return false;
    }

    @Override
    protected void parseMemberVariableName() {
        super.parseMemberVariableName();
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.QUEST || tokenType == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
    }

    @Override
    protected boolean parserMemberFunctionName() {
        boolean result2 = super.parserMemberFunctionName();
        if (result2 && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        return result2;
    }

    @Override
    protected boolean isPossibleMemberFunctionStart(IElementType lookahead) {
        if (lookahead == JSTokenTypes.QUEST) {
            lookahead = this.builder.lookAhead(2);
        }
        return super.isPossibleMemberFunctionStart(lookahead);
    }

    @Override
    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        if (marker == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(6);
        }
        if (this.isTypeOnly()) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportOrExportSpecifier(isImport, marker, stopOnFirstError);
    }

    private boolean isTypeOnly() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType != JSTokenTypes.TYPE_KEYWORD) {
            return false;
        }
        IElementType next = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(next) && next != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        IElementType secondNext = this.builder.lookAhead(2);
        if (!this.isIdentifierToken(secondNext)) {
            return true;
        }
        IElementType thirdNext = this.builder.lookAhead(3);
        if (this.isIdentifierToken(thirdNext)) {
            return secondNext == JSTokenTypes.AS_KEYWORD;
        }
        return next != JSTokenTypes.AS_KEYWORD;
    }

    @Override
    protected boolean isPossibleClassName(IElementType firstElement, boolean mayOmitName) {
        return super.isPossibleClassName(firstElement, mayOmitName) && firstElement != JSTokenTypes.IMPLEMENTS_KEYWORD;
    }

    @Override
    public boolean canProceedClassParsing(IElementType elementType) {
        return super.canProceedClassParsing(elementType) || elementType == JSTokenTypes.IMPLEMENTS_KEYWORD;
    }

    @Override
    protected void parseMemberPropertyWithBrackets() {
        ((TypeScriptExpressionParser)((TypeScriptParser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
        if (this.builder.getTokenType() == JSTokenTypes.QUEST || this.builder.getTokenType() == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassMemberModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseInterfaceNoMarker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseInterface";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseES6ImportOrExportSpecifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

