/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.advancedSettings.JSAdvancedSettingsKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModifiersUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.TypescriptConstructorChecker;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSDocDecoratedType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.inspections.TypeScriptSmartCastInspection;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    public static final Key<TypeScriptAnnotatorCheckerProvider> PROVIDER_KEY = Key.create((String)"Annotator.Checker.Provider");
    private static final TokenSet MODIFIERS_TO_VALIDATE = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.MODIFIERS, JSTokenTypes.TYPE_PARAMETER_MODIFIERS});

    public TypeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSConstructorChecker createConstructorChecker() {
        return new TypescriptConstructorChecker(this.myProblemReporter);
    }

    @Override
    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context2) {
        AnnotationSession session = this.myHolder.getCurrentAnnotationSession();
        TypeScriptAnnotatorCheckerProvider provider = (TypeScriptAnnotatorCheckerProvider)session.getUserData(PROVIDER_KEY);
        if (provider == null) {
            provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context2);
            session.putUserData(PROVIDER_KEY, (Object)provider);
        }
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = provider.getProblemReporter(this.myHolder);
        if (jSAnnotatorProblemReporter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return jSAnnotatorProblemReporter;
    }

    @Override
    public void visitJSClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        super.visitJSClass(jsClass);
        for (JSElement jSElement : jsClass.getMembers()) {
            JSAttributeList list2;
            if (!(jSElement instanceof JSAttributeListOwner) || (list2 = ((JSAttributeListOwner)jSElement).getAttributeList()) == null || !list2.hasPrivateSharp()) continue;
            for (ASTNode child : list2.getNode().getChildren(JSAttributeListImpl.ourModifiersTypeSet)) {
                IElementType elementType = child.getElementType();
                if (elementType != JSTokenTypes.PRIVATE_KEYWORD && elementType != JSTokenTypes.PROTECTED_KEYWORD && elementType != JSTokenTypes.PUBLIC_KEYWORD) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, JavaScriptBundle.message("typescript.private.field.modifiers.mix", new Object[0])).range(child).create();
            }
        }
    }

    @Override
    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        super.visitComment(comment);
        if (TypeScriptPsiUtil.isTopLevelThreeSlashComment(comment)) {
            JSFixFactory.getInstance().typeScriptReferencePathValidator().checkReferences(comment, this.myHolder, !TypeScriptAnnotatingVisitor.skipTypeChecking((PsiElement)comment));
        }
    }

    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        JSType typeFromGuard;
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if (TypeScriptAnnotatingVisitor.isSmartCastInspectionEnabled(node) && (typeFromGuard = JSTypeGuardUtil.getTypeIfAffectedByTypeGuard(node)) != null) {
            AnnotationBuilder builder2 = JSFixFactory.getInstance().isShowSmartCastText() ? this.myHolder.newAnnotation(HighlightSeverity.INFORMATION, JavaScriptBundle.message("typescript.narrowed.to", typeFromGuard.getTypeText(JSType.TypeTextFormat.PRESENTABLE))) : this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION);
            builder2.textAttributes(TypeScriptHighlighter.TS_TYPE_GUARD).create();
        }
        super.visitJSReferenceExpression(node);
    }

    @Override
    public void visitTypeScriptSingleType(@NotNull TypeScriptSingleType singleType) {
        PsiElement parent;
        if (singleType == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if (!JSAdvancedSettingsKt.isTsAdvancedAnnotatorEnabled()) {
            return;
        }
        JSType jsType = singleType.getJSType();
        if (jsType instanceof JSGenericTypeImpl) {
            boolean isJSDocGenerics = false;
            IElementType prev = null;
            ASTNode node = singleType.getNode();
            if (node != null) {
                for (ASTNode child : node.getChildren(null)) {
                    IElementType type2 = child.getElementType();
                    if (type2 == TypeScriptStubElementTypes.TYPE_ARGUMENT_LIST && prev == JSTokenTypes.DOT) {
                        isJSDocGenerics = true;
                    }
                    prev = type2;
                }
                if (isJSDocGenerics) {
                    this.myProblemReporter.registerGenericError((PsiElement)singleType, JavaScriptBundle.message("javascript.validation.message.jsdoc.types.are.used", new Object[0]), new IntentionAction[0]);
                }
            }
        } else if (jsType instanceof JSAnyType) {
            String name = singleType.getQualifiedTypeName();
            if ("*".equals(name) || "?".equals(name)) {
                this.myProblemReporter.registerGenericError((PsiElement)singleType, JavaScriptBundle.message("javascript.validation.message.jsdoc.types.are.used", new Object[0]), new IntentionAction[0]);
            }
        } else if (this.isUniqueSymbol(jsType) && !((parent = singleType.getParent()) instanceof JSFieldVariable) && !(parent instanceof JSRecordType.PropertySignature)) {
            this.myProblemReporter.registerGenericError((PsiElement)singleType, JavaScriptBundle.message("typescript.validation.message.unique.symbol.wrong.usage", new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptSingleType(singleType);
    }

    @Override
    public void visitTypeScriptType(@NotNull TypeScriptType type2) {
        if (type2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        if (type2 instanceof JSDocFunctionType || type2 instanceof JSDocDecoratedType) {
            this.myProblemReporter.registerGenericError((PsiElement)type2, JavaScriptBundle.message("javascript.validation.message.jsdoc.types.are.used", new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptType(type2);
    }

    public static boolean isSmartCastInspectionEnabled(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (!TypeScriptAnnotatingVisitor.isTypeGuardHighlightedForElement(node)) {
            return false;
        }
        Project project = node.getProject();
        InspectionProjectProfileManager manager = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager.getCurrentProfile();
        String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)id);
        if (key2 == null) {
            key2 = new HighlightDisplayKey(id, id);
        }
        return inspectionProfile.isToolEnabled(key2, (PsiElement)node.getContainingFile());
    }

    private static boolean isTypeGuardHighlightedForElement(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        return !(expression.getQualifier() instanceof JSThisExpression);
    }

    @Override
    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        Map<TypeScriptMemberInfo, JSClass> membersToImplement;
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        if ((membersToImplement = TypeScriptUtil.getMemberInfos(jsClass, false)).isEmpty()) {
            return;
        }
        boolean isAbstractClass = TypeScriptPsiUtil.isAbstractElement(jsClass);
        LocalQuickFix implementAllFix = JSFixFactory.getInstance().typeScriptImplementMembersFix(jsClass, false);
        LocalQuickFix implementRequiredOnlyFix = JSFixFactory.getInstance().typeScriptImplementMembersFix(jsClass, true);
        LocalQuickFix implementAbstractFix = JSFixFactory.getInstance().typeScriptImplementMembersAbstractFix(jsClass);
        HashSet<String> processed = new HashSet<String>(membersToImplement.size());
        boolean hasOptional = TypeScriptUtil.getMemberInfos(jsClass, true).size() != membersToImplement.size();
        for (Map.Entry<TypeScriptMemberInfo, JSClass> entry : membersToImplement.entrySet()) {
            Object[] objectArray;
            boolean isIncompatible;
            ASTNode classKeyword;
            JSClass containerClass = entry.getValue();
            TypeScriptMemberInfo info2 = entry.getKey();
            if (info2.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE && this.reportMemberIncompatible(jsClass, info2, containerClass)) continue;
            String message = TypeScriptAnnotatingVisitor.getErrorMessageForNotImplementedError(jsClass, containerClass, info2);
            assert (message != null);
            if (!processed.add(message)) continue;
            PsiElement nameIdentifier = jsClass.getNameIdentifier();
            if (nameIdentifier == null && (classKeyword = jsClass.getNode().findChildByType(JSTokenTypes.CLASS_KEYWORD)) != null) {
                nameIdentifier = classKeyword.getPsi();
            }
            if (nameIdentifier == null) {
                nameIdentifier = jsClass.getFirstChild();
            }
            boolean bl = isIncompatible = info2.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE;
            if (isIncompatible) {
                objectArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                objectArray = localQuickFixArray;
                localQuickFixArray[0] = implementAllFix;
            }
            Object[] fixes = objectArray;
            if (!isIncompatible) {
                if (hasOptional) {
                    fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)implementRequiredOnlyFix);
                }
                if (isAbstractClass) {
                    fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)implementAbstractFix);
                }
            }
            this.myProblemReporter.registerProblem(nameIdentifier, null, message, ProblemHighlightType.GENERIC_ERROR, null, (LocalQuickFix[])fixes, IntentionAction.EMPTY_ARRAY);
        }
    }

    private boolean reportMemberIncompatible(@NotNull JSClass jsClass, TypeScriptMemberInfo info2, JSClass containerClass) {
        PsiElement identifier;
        JSElement element;
        String name;
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        if ((name = (element = info2.getElement()).getName()) == null) {
            return false;
        }
        Collection<? extends JSElement> members = jsClass.findMembersByName(name);
        if (members.size() != 1) {
            return false;
        }
        JSElement item = (JSElement)ContainerUtil.getFirstItem(members);
        if (item instanceof JSNamedElement && (identifier = ((JSNamedElement)item).getNameIdentifier()) != null) {
            String message = TypeScriptAnnotatingVisitor.getErrorMessageForNotImplementedError(jsClass, containerClass, info2);
            this.myProblemReporter.registerProblem(identifier, null, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
            return true;
        }
        return false;
    }

    @Nullable
    @InspectionMessage
    private static String getErrorMessageForNotImplementedError(@NotNull JSClass jsClass, @NotNull JSClass containerClass, @NotNull TypeScriptMemberInfo info2) {
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        if (info2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        String interfaceName = containerClass.getName();
        JSElement memberToImplement = info2.getElement();
        if (info2.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE) {
            String property = memberToImplement instanceof JSFunction ? "javascript.validation.message.class.method.incompatible" : "javascript.validation.message.class.property.incompatible";
            return JavaScriptBundle.message(property, memberToImplement.getName(), jsClass.getName(), interfaceName);
        }
        boolean isFunction = TypeScriptUtil.isTypeScriptMethod((PsiElement)memberToImplement);
        boolean isProperty = TypeScriptUtil.isTypeScriptProperty((PsiElement)memberToImplement);
        if (isFunction || isProperty || memberToImplement instanceof JSLocalImplicitElementImpl) {
            String messageId = TypeScriptAnnotatingVisitor.getMessageIdForNotImplementedError(containerClass, isFunction);
            return JavaScriptBundle.message(messageId, memberToImplement.getName(), interfaceName);
        }
        if (memberToImplement instanceof TypeScriptCallSignature) {
            return JavaScriptBundle.message("javascript.validation.message.interface.call.signature.not.implemented", interfaceName);
        }
        if (memberToImplement instanceof TypeScriptIndexSignature) {
            return JavaScriptBundle.message("javascript.validation.message.interface.index.signature.not.implemented", interfaceName);
        }
        return null;
    }

    @NotNull
    private static String getMessageIdForNotImplementedError(@NotNull JSClass containerClass, boolean isFunction) {
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        if (isFunction) {
            if (containerClass instanceof TypeScriptClass) {
                return "javascript.validation.message.class.method.not.implemented";
            }
            return "javascript.validation.message.interface.method.not.implemented";
        }
        if (containerClass instanceof TypeScriptClass) {
            return "javascript.validation.message.class.property.not.implemented";
        }
        return "javascript.validation.message.interface.property.not.implemented";
    }

    @Override
    protected void checkSetterReturnType(@NotNull JSFunction function2) {
        PsiElement returnTypeElement;
        if (function2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if ((returnTypeElement = function2.getReturnTypeElement()) != null) {
            this.myProblemReporter.registerGenericError(returnTypeElement, JavaScriptBundle.message("javascript.validation.message.class.setter.cannot.have.return.type", new Object[0]), new IntentionAction[0]);
        }
    }

    @Override
    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        this.checkAccessorAccessTypeMatch(setter, getter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
    }

    @Override
    protected void validateGetter(@NotNull JSFunction getter, @Nullable JSFunction setter, JSType type2) {
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        if (setter != null) {
            this.checkAccessorAccessTypeMatch(getter, setter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
        }
    }

    @Override
    public void visitTypeScriptIndexSignature(@NotNull TypeScriptIndexSignature indexSignature) {
        if (indexSignature == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        PsiElement nameElement = indexSignature.getParameterNameElement();
        JSTypeDeclaration parameterType = indexSignature.getParameterType();
        if (nameElement != null) {
            if (parameterType == null) {
                this.myProblemReporter.registerGenericError(nameElement, JavaScriptBundle.message("javascript.validation.message.index.no.type", new Object[0]), new IntentionAction[0]);
            } else {
                JSType type2 = parameterType.getJSType();
                if (!TypeScriptAnnotatingVisitor.isValidIndexerType(type2)) {
                    this.myProblemReporter.registerGenericError((PsiElement)parameterType, JavaScriptBundle.message("javascript.validation.message.index.wrong.type", new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static boolean isValidIndexerType(JSType type2) {
        if (TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type2, JSNamedTypeFactory.createStringPrimitiveType(type2.getSource()))) {
            return true;
        }
        if (TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type2, JSNamedTypeFactory.createNumberPrimitiveType(type2.getSource()))) {
            return true;
        }
        return TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type2, JSNamedTypeFactory.createSymbolPrimitiveType(type2.getSource()));
    }

    private static boolean isAssignableInAnyDirection(JSType type2, JSType otherType) {
        return type2.isDirectlyAssignableType(otherType, null) || otherType.isDirectlyAssignableType(type2, null);
    }

    @Override
    public void visitTypeScriptPropertySignature(@NotNull TypeScriptPropertySignature propertySignature) {
        if (propertySignature == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        this.checkDuplicates(propertySignature);
        if (this.isUniqueSymbol(propertySignature.getJSType()) && !propertySignature.isConst()) {
            this.myProblemReporter.registerGenericError(propertySignature.getNode(), JavaScriptBundle.message("typescript.validation.message.unique.symbol.mutable.property.signature", new Object[0]), JSFixFactory.getInstance().addReadonlyModifierFix(propertySignature));
        }
    }

    @Override
    public void visitTypeScriptFunctionSignature(@NotNull TypeScriptFunctionSignature functionSignature) {
        if (functionSignature == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        this.checkDuplicates(functionSignature);
    }

    @Override
    protected void checkOverriddenMethods(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        JSRecordType aClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(aClass, false, false);
        JSRecordType aClassConstructorType = TypeScriptTypeParser.buildTypeFromClass(aClass, true, false);
        MultiMap checkedMembersInstance = MultiMap.createSet();
        MultiMap checkedMembersConstructor = MultiMap.createSet();
        for (JSClass parentClass : TypeScriptUtil.getNonStrictParents(aClass, aClass instanceof TypeScriptInterface)) {
            if (parentClass == aClass) continue;
            this.checkOverride(aClass, aClassInstanceType, parentClass, false, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersInstance);
            this.checkOverride(aClass, aClassConstructorType, parentClass, true, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersConstructor);
        }
    }

    private void checkOverride(@NotNull JSClass aClass, @NotNull JSRecordType aClassType, @NotNull JSClass parentClass, boolean isStatic, @NotNull MultiMap<JSRecordType.PropertySignature, JSClass> checkedMembers) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if (aClassType == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (parentClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        if (checkedMembers == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        JSRecordType parentClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(parentClass, isStatic, false);
        ProcessingContext contextWithCache = JSTypeComparingContextService.createProcessingContextWithCache(aClass);
        for (JSRecordType.PropertySignature parentClassPropertySignature : parentClassInstanceType.getProperties()) {
            JSType type2;
            String name = parentClassPropertySignature.getMemberName();
            JSRecordType.PropertySignature aClassPropertySignature = aClassType.findPropertySignature(name);
            if (aClassPropertySignature == null) continue;
            Collection classes = checkedMembers.get((Object)aClassPropertySignature);
            if (!classes.isEmpty()) {
                boolean wasCheckedForHierarchy = false;
                for (JSClass checkedClass : classes) {
                    if (!JSInheritanceUtil.isParentClass(checkedClass, parentClass)) continue;
                    wasCheckedForHierarchy = true;
                    break;
                }
                if (wasCheckedForHierarchy) {
                    continue;
                }
            } else {
                checkedMembers.putValue((Object)aClassPropertySignature, (Object)parentClass);
            }
            if ((type2 = parentClassPropertySignature.getJSType()) == null || (type2 = JSTypeUtils.hasForeignGenericParameter(type2) ? TypeScriptUtil.applyGenericsToType(type2, aClass, parentClass) : type2).isDirectlyAssignableType(aClassPropertySignature.getJSType(), contextWithCache)) continue;
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(aClass)) {
                PsiElement nameIdentifier;
                if (!name.equals(classMember.getName())) continue;
                boolean isStaticMember = false;
                if (classMember instanceof JSAttributeListOwner) {
                    JSAttributeList attributeList = ((JSAttributeListOwner)((Object)classMember)).getAttributeList();
                    boolean bl = isStaticMember = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                if (isStaticMember != isStatic || (nameIdentifier = classMember.getNameIdentifier()) == null) continue;
                this.myProblemReporter.registerGenericError(nameIdentifier, JavaScriptBundle.message("javascript.validation.message.incompatible.override", parentClass.getName()), new IntentionAction[0]);
            }
        }
    }

    @Override
    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        if (node instanceof JSCallExpression) {
            node = ((JSCallExpression)node).getMethodExpression();
        }
        return node instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)node) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : ProblemHighlightType.GENERIC_ERROR;
    }

    @Override
    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        return true;
    }

    @Override
    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        return true;
    }

    @Override
    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference;
        if (importStatement == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(29);
        }
        if ((externalModuleReference = importStatement.getExternalModuleReference()) != null) {
            String referenceNodeText;
            ASTNode referenceNode = externalModuleReference.findReferenceNode();
            String string = referenceNodeText = referenceNode != null ? StringUtil.unquoteString((String)referenceNode.getText()) : null;
            if (referenceNodeText != null && TypeScriptUtil.isTypeScriptFile(referenceNodeText)) {
                this.myProblemReporter.registerGenericError(referenceNode, JavaScriptBundle.message("typescript.validation.module.reference.with.extension", new Object[0]), new IntentionAction[0]);
            }
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        JSClass parentClass;
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        if ((parentClass = TypeScriptPsiUtil.getParentClass(node)) != null) {
            this.validateClassMember(node, parentClass);
        }
        this.validateSignatureFunction(node, parentClass);
        super.visitJSFunctionDeclaration(node);
    }

    @Nullable
    private static ASTNode getStarFromGenerator(@NotNull JSFunction function2) {
        ASTNode mult;
        if (function2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        if (!function2.isGenerator()) {
            return null;
        }
        JSAttributeList list2 = function2.getAttributeList();
        if (list2 != null && (mult = list2.getNode().findChildByType(JSTokenTypes.MULT)) != null) {
            return mult;
        }
        return function2.getNode().findChildByType(JSTokenTypes.MULT);
    }

    private void validateSignatureFunction(JSFunction node, JSClass parentClass) {
        TypeScriptFunction function2;
        block14: {
            block13: {
                if (!(node instanceof TypeScriptFunction)) break block13;
                function2 = (TypeScriptFunction)node;
                if (!(node instanceof JSFunctionExpression)) break block14;
            }
            return;
        }
        boolean noBody = function2.getBlock() == null;
        boolean isOverload = function2.isOverloadDeclaration();
        boolean isAbstract = TypeScriptPsiUtil.isAbstractElement(function2);
        boolean isOptional = function2.isOptional();
        boolean isAmbient = TypeScriptPsiUtil.isAmbientDeclaration(function2);
        if (!(!noBody || isOverload || isOptional || isAbstract || isAmbient)) {
            SmartList intentions = new SmartList();
            TypeScriptAnnotatingVisitor.addMakeMethodAbstractIntention(parentClass, function2, (Collection<IntentionAction>)intentions);
            this.myProblemReporter.registerGenericError(TypeScriptAnnotatingVisitor.getPlaceForNamedElementProblem(function2), JavaScriptBundle.message("typescript.validation.message.function.implementation.missing", new Object[0]), intentions.toArray(IntentionAction.EMPTY_ARRAY));
            return;
        }
        if (function2.isGenerator()) {
            if (isOverload) {
                ASTNode multNode = TypeScriptAnnotatingVisitor.getStarFromGenerator(function2);
                if (multNode != null) {
                    this.myProblemReporter.registerGenericError(multNode, JavaScriptBundle.message("typescript.validation.generators.overload", new Object[0]), new IntentionAction[0]);
                }
                return;
            }
            if (isAmbient) {
                ASTNode multNode = TypeScriptAnnotatingVisitor.getStarFromGenerator(function2);
                if (multNode != null) {
                    this.myProblemReporter.registerGenericError(multNode, JavaScriptBundle.message("typescript.validation.generators.ambient", new Object[0]), new IntentionAction[0]);
                }
                return;
            }
        }
        if (isAmbient) {
            return;
        }
        if (isAbstract && parentClass != null) {
            PsiElement element;
            JSAttributeList list2 = function2.getAttributeList();
            PsiElement psiElement = element = list2 != null ? list2.findModifierElement(JSAttributeList.ModifierType.ABSTRACT) : null;
            if (element != null) {
                TypeScriptFunction lastOverload = TypeScriptPsiUtil.getLastOverload(function2);
                List<TypeScriptFunction> overloadDeclarations = lastOverload.getOverloadDeclarations();
                ArrayList<TypeScriptFunction> declarations = new ArrayList<TypeScriptFunction>(overloadDeclarations.size() + 1);
                declarations.addAll(overloadDeclarations);
                declarations.add(lastOverload);
                if (!ContainerUtil.all(declarations, TypeScriptPsiUtil::isAbstractElement)) {
                    this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message("typescript.validation.message.abstract.overload", new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static void addMakeMethodAbstractIntention(JSClass parentClass, TypeScriptFunction function2, Collection<IntentionAction> intentions) {
        JSAttributeList methodAttributeList;
        JSAttributeList list2;
        if (parentClass instanceof TypeScriptClass && parentClass.getAttributeList() != null && (list2 = parentClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.ABSTRACT) && (methodAttributeList = function2.getAttributeList()) != null && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            intentions.add((IntentionAction)JSFixFactory.getInstance().insertModifier(function2, JSAttributeList.ModifierType.ABSTRACT));
        }
    }

    private void validateClassMember(JSFunction member, JSClass parentClass) {
        PsiElement element;
        JSAttributeList list2;
        PsiElement identifier;
        if (TypeScriptPsiUtil.isAmbientDeclaration(member) && member.getBlock() != null && (identifier = member.getNameIdentifier()) != null) {
            this.myProblemReporter.registerGenericError(identifier, JavaScriptBundle.message("javascript.ambient.declaration.should.have.no.body", new Object[0]), new IntentionAction[0]);
        }
        if ((list2 = member.getAttributeList()) != null && (element = list2.findModifierElement(JSAttributeList.ModifierType.ABSTRACT)) != null) {
            if (list2.getExplicitAccessType() == JSAttributeList.AccessType.PRIVATE) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message("typescript.validation.message.abstract.cannot.be.used", "private"), new IntentionAction[0]);
            } else if (list2.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message("typescript.validation.message.abstract.cannot.be.used", "static"), new IntentionAction[0]);
            }
            if (member.isConstructor()) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message("typescript.validation.message.constructor.cannot.be.abstract", new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else if (member.getBlock() != null) {
                this.myProblemReporter.registerGenericError(member.getNameIdentifier(), JavaScriptBundle.message("typescript.validation.message.abstract.cannot.have.body", new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else {
                JSAttributeList attrList = parentClass.getAttributeList();
                if (attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message("typescript.validation.message.abstract.class.should.be", new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().insertModifier(parentClass, JSAttributeList.ModifierType.ABSTRACT)});
                }
            }
        }
    }

    private static IntentionAction createRemoveAbstractKeywordFix(PsiElement element) {
        return JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.abstract.keyword", element);
    }

    @Override
    public void visitJSAttributeList(@NotNull JSAttributeList attributeList) {
        if (attributeList == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(32);
        }
        PsiElement container = attributeList.getParent();
        PsiElement place = TypeScriptPsiUtil.getParentOverDefaultAssignable(container);
        boolean isTopLevel = TypeScriptPsiUtil.isTopLevelContainer(place);
        ASTNode[] children = attributeList.getNode().getChildren(MODIFIERS_TO_VALIDATE);
        if (children.length == 0) {
            return;
        }
        boolean alreadyHasAccessModifier = false;
        HashSet<IElementType> modifiers = new HashSet<IElementType>();
        for (ASTNode child : children) {
            IElementType elementType = child.getElementType();
            String message = TypeScriptModifiersUtil.validateModifiers(container, isTopLevel, alreadyHasAccessModifier, modifiers, child, elementType);
            if (message != null) {
                this.myProblemReporter.registerGenericError(child, message, new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child.getPsi())});
            }
            if (!TypeScriptModifiersUtil.isAccessibilityModifier(elementType)) continue;
            alreadyHasAccessModifier = true;
        }
        super.visitJSAttributeList(attributeList);
    }

    @Override
    protected void validateRestParameterType(JSParameterListElement parameter) {
        JSType type2;
        PsiElement typeElement = parameter.getTypeElement();
        if (typeElement != null && parameter instanceof JSParameter && !TypeScriptAnnotatingVisitor.isValidRestType(type2 = JSTypeWithIncompleteSubstitution.substituteCompletely(((TypeScriptType)typeElement).getJSType()))) {
            String newTypeText = new JSArrayTypeImpl(type2, type2.getSource()).getTypeText(JSType.TypeTextFormat.CODE);
            LocalQuickFixAndIntentionActionOnPsiElement changeTypeFix = JSFixFactory.getInstance().changeTypeFix((JSParameter)parameter, newTypeText, "typescript.validation.message.unexpected.type.for.rest.parameter.fix");
            this.myProblemReporter.registerGenericError(typeElement, JavaScriptBundle.message("typescript.validation.message.unexpected.type.for.rest.parameter", new Object[0]), new IntentionAction[]{changeTypeFix});
        }
    }

    private static boolean isValidRestType(@NotNull JSType type2) {
        JSType alias;
        if (type2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(33);
        }
        if (type2 instanceof JSTypeImpl && (alias = ((JSTypeImpl)type2).resolveType().getAliasedType()) != null) {
            type2 = alias;
        }
        if (JSTypeUtils.isIndexableType(type2) || type2 instanceof JSGenericParameterImpl || type2 instanceof JSTupleType) {
            return true;
        }
        if (type2 instanceof JSIntersectionType) {
            return ContainerUtil.and(((JSIntersectionType)type2).getTypes(), TypeScriptAnnotatingVisitor::isValidRestType);
        }
        return type2 instanceof JSAnyType;
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable var) {
        String message;
        if (var == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(34);
        }
        JSClass grandParent = JSUtils.getMemberContainingClass((PsiElement)var);
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var) && !(grandParent instanceof TypeScriptEnum) && (message = TypeScriptAnnotatingVisitor.getMessageForAmbientDeclaration(var)) != null) {
            this.myProblemReporter.registerGenericError((PsiElement)var.getInitializer(), message, new IntentionAction[0]);
        }
        if (this.isUniqueSymbol(var.getJSType())) {
            if (var instanceof JSField) {
                if (!var.isConst() || !var.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    this.myProblemReporter.registerGenericError((PsiElement)var, JavaScriptBundle.message("typescript.validation.message.unique.symbol.mutable.non.static.field.declaration", new Object[0]), JSFixFactory.getInstance().addStaticAndReadonlyModifier(var));
                }
            } else if (!var.isConst()) {
                this.myProblemReporter.registerGenericError((PsiElement)var, JavaScriptBundle.message("typescript.validation.message.unique.symbol.mutable.variable", new Object[0]), JSFixFactory.getInstance().convertVarOrLetToConst(var.getStatement()));
            }
        }
        super.visitJSVariable(var);
    }

    private boolean isUniqueSymbol(@Nullable JSType type2) {
        return type2 instanceof JSUniqueSymbolTypeImpl;
    }

    @Nullable
    @InspectionMessage
    private static String getMessageForAmbientDeclaration(@NotNull JSVariable var) {
        JSExpression initializer;
        if (var == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(35);
        }
        if ((initializer = var.getInitializer()) == null) {
            return null;
        }
        PsiElement type2 = var.getTypeElement();
        if (type2 != null || !var.isConst()) {
            return JavaScriptBundle.message("javascript.ambient.declaration.should.have.no.initializer", new Object[0]);
        }
        JSType jsType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(var.getJSType(), (PsiElement)var);
        if (jsType instanceof JSPrimitiveLiteralType) {
            return null;
        }
        if (jsType instanceof JSResolvableType && ((JSResolvableType)jsType).resolveType().isEnumLiteral()) {
            return null;
        }
        return JavaScriptBundle.message("javascript.ambient.declaration.const.should.be.primitive", new Object[0]);
    }

    @Override
    public void visitTypeScriptExportAssignment(@NotNull TypeScriptExportAssignment exportAssignment) {
        PsiElement parent;
        if (exportAssignment == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(36);
        }
        if ((parent = exportAssignment.getParent()) instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            this.myProblemReporter.registerGenericError(exportAssignment.getNode(), JavaScriptBundle.message("typescript.export.assignment.cannot.be.used.in.internal.modules", new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptExportAssignment(exportAssignment);
    }

    @Override
    public void visitTypeScriptTypePredicate(@NotNull TypeScriptTypePredicate predicate) {
        PsiElement parent;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(37);
        }
        if (!this.checkTypePredicateShouldBeReturnType(predicate, parent = predicate.getParent())) {
            JSType guardType;
            if ("this".equals(predicate.getParameterName())) {
                return;
            }
            JSParameter parameter = predicate.getParameterMatchName();
            if (parameter == null) {
                Object anchor = predicate.getNameIdentifier();
                if (anchor == null) {
                    anchor = predicate;
                }
                this.myProblemReporter.registerGenericError(anchor.getNode(), JavaScriptBundle.message("typescript.type.predicate.not.match.name", predicate.getParameterName()), new IntentionAction[0]);
                return;
            }
            if (parameter.isRest()) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JavaScriptBundle.message("typescript.type.predicate.rest", new Object[0]), new IntentionAction[0]);
                return;
            }
            PsiElement nameParent = parameter.getParent();
            if (nameParent instanceof JSDestructuringContainer || nameParent instanceof JSDestructuringProperty || nameParent instanceof JSDestructuringArrayRestElement) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JavaScriptBundle.message("typescript.type.predicate.destructuring", new Object[0]), new IntentionAction[0]);
                return;
            }
            JSType parameterType = parameter.getJSType();
            if (parameterType != null && (guardType = predicate.getGuardType()) != null && !parameterType.isDirectlyAssignableType(guardType, JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)predicate))) {
                this.myProblemReporter.registerGenericError((PsiElement)predicate, JavaScriptBundle.message("typescript.type.predicate.incompatible.types", parameterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), new IntentionAction[0]);
            }
        }
        super.visitTypeScriptTypePredicate(predicate);
    }

    private boolean checkTypePredicateShouldBeReturnType(@NotNull TypeScriptTypePredicate predicate, @NotNull PsiElement parent) {
        boolean isParentCorrectFunction;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(38);
        }
        if (parent == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(39);
        }
        boolean bl = isParentCorrectFunction = parent instanceof TypeScriptFunction && !((TypeScriptFunction)parent).isConstructor() && ((TypeScriptFunction)parent).getReturnTypeElement() == predicate;
        if (isParentCorrectFunction) {
            return false;
        }
        if (predicate.isThisType()) {
            if (parent instanceof JSField && ((JSField)parent).getTypeElement() == predicate) {
                return false;
            }
            this.myProblemReporter.registerGenericError(predicate.getNode(), JavaScriptBundle.message("typescript.type.this.predicate.not.return", new Object[0]), new IntentionAction[0]);
        } else {
            this.myProblemReporter.registerGenericError(predicate.getNode(), JavaScriptBundle.message("typescript.type.predicate.not.return", new Object[0]), new IntentionAction[0]);
        }
        return true;
    }

    @Override
    public void visitJSParameterList(@NotNull JSParameterList node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(40);
        }
        boolean hasOptional = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            if (hasOptional && !parameter.isOptional() && !parameter.isRest()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message("javascript.validation.message.parameter.non.optional.after.optional", new Object[0]), new IntentionAction[0]);
            }
            if (parameter.isRest() && parameter.isOptional()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message("javascript.validation.message.parameter.rest.optional", new Object[0]), new IntentionAction[0]);
            }
            hasOptional = hasOptional || parameter.isOptional();
        }
        super.visitJSParameterList(node);
    }

    @Override
    @NotNull
    protected @NotNull LocalQuickFix @NotNull [] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, @Nullable String message) {
        if (ref == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(41);
        }
        if (ref instanceof ES6ImportExportSpecifier && message != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((ES6ImportExportSpecifier)ref).multiResolve(false)) {
                if (!(result2 instanceof JSResolveResult) || ((JSResolveResult)result2).getResolveProblemKind() != JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG) continue;
                LocalQuickFix[] localQuickFixArray = JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)ref, result2.getElement()).toArray(LocalQuickFix.EMPTY_ARRAY);
                if (localQuickFixArray == null) {
                    TypeScriptAnnotatingVisitor.$$$reportNull$$$0(42);
                }
                return localQuickFixArray;
            }
        }
        LocalQuickFix[] localQuickFixArray = super.getQuickFixesForReferenceProblem(ref, message);
        if (localQuickFixArray == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(43);
        }
        return localQuickFixArray;
    }

    @Override
    public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(44);
        }
        super.visitES6ExportDefaultAssignment(node);
        JSElement scope2 = ES6PsiUtil.getExportScope((PsiElement)node);
        if (scope2 instanceof TypeScriptModule && ((TypeScriptModule)scope2).isInternal()) {
            PsiElement context2 = (PsiElement)ObjectUtils.coalesce((Object)node.getExpression(), (Object)node);
            this.myProblemReporter.registerGenericError(context2, JavaScriptBundle.message("javascript.validation.message.duplicate.default.export.in.module", new Object[0]), new IntentionAction[0]);
        }
    }

    private static boolean skipTypeChecking(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(45);
        }
        return TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context2).skipErrors(context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: 
            case 8: 
            case 28: 
            case 30: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 7: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSignature";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClassType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMembers";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportAssignment";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemReporter";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForReferenceProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 42: 
            case 43: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitJSClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptSingleType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSmartCastInspectionEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTypeGuardHighlightedForElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportMemberIncompatible";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageForNotImplementedError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMessageIdForNotImplementedError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterReturnType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptIndexSignature";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptPropertySignature";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptFunctionSignature";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkOverriddenMethods";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkOverride";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptImportStatement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getStarFromGenerator";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeList";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isValidRestType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForAmbientDeclaration";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptExportAssignment";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypePredicate";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkTypePredicateShouldBeReturnType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitJSParameterList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDefaultAssignment";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "skipTypeChecking";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 42, 43 -> new IllegalStateException(string);
        };
    }
}

