/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSClassHighlightingHelper;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/documentation/JSClassHighlightingHelper;", "", "()V", "getExtendsImplementsPlaceholder", "Lcom/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$TextPlaceholder;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "packageName", "", "includeObjectInExtendsList", "", "getReferenceType", "reference", "Lcom/intellij/lang/javascript/psi/ecmal4/JSReferenceListMember;", "context", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSClassHighlightingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSClassHighlightingHelper.kt\ncom/intellij/lang/javascript/documentation/JSClassHighlightingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class JSClassHighlightingHelper {
    @NotNull
    public static final JSClassHighlightingHelper INSTANCE = new JSClassHighlightingHelper();

    private JSClassHighlightingHelper() {
    }

    @JvmStatic
    @NotNull
    public static final JSHtmlHighlightingUtil.TextPlaceholder getExtendsImplementsPlaceholder(@NotNull JSClass jsClass, @NotNull String packageName, boolean includeObjectInExtendsList) {
        String implementsList;
        String extendsList;
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        AtomicInteger replacementCounter = new AtomicInteger();
        Map replacements = new LinkedHashMap();
        StringBuilder builder2 = new StringBuilder();
        String string = JSClassHighlightingHelper.getExtendsImplementsPlaceholder$createTypeList(replacementCounter, replacements, jsClass.getExtendsList());
        if (string == null) {
            string = includeObjectInExtendsList && !Intrinsics.areEqual((Object)"Object", (Object)jsClass.getName()) ? "Object" : null;
        }
        if ((extendsList = string) != null) {
            builder2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSClassHighlightingHelper.getExtendsImplementsPlaceholder$createTypeList(replacementCounter, replacements, jsClass.getImplementsList())) != null) {
            builder2.append("\nimplements ").append(implementsList);
        }
        return new JSHtmlHighlightingUtil.TextPlaceholder(builder2, replacements, packageName, jsClass){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ Map<String, JSReferenceListMember> $replacements;
            final /* synthetic */ String $packageName;
            final /* synthetic */ JSClass $jsClass;
            {
                this.$builder = $builder;
                this.$replacements = $replacements;
                this.$packageName = $packageName;
                this.$jsClass = $jsClass;
            }

            @NotNull
            public CharSequence getHolderText() {
                String string = this.$builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            @NotNull
            public CharSequence restoreText(@NotNull CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                String result2 = ((Object)text2).toString();
                for (Map.Entry<String, JSReferenceListMember> entry : this.$replacements.entrySet()) {
                    String placeholder = entry.getKey();
                    JSReferenceListMember reference = entry.getValue();
                    String typeLink = JSClassHighlightingHelper.access$getReferenceType(JSClassHighlightingHelper.INSTANCE, reference, this.$packageName, this.$jsClass);
                    result2 = StringsKt.replaceFirst((String)result2, (String)placeholder, (String)typeLink, (boolean)false);
                }
                return result2;
            }
        };
    }

    private final String getReferenceType(JSReferenceListMember reference, String packageName, PsiElement context2) {
        Collection<JSClass> collection = reference.getClasses();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getClasses(...)");
        JSClass jsClass = (JSClass)CollectionsKt.singleOrNull((Iterable)collection);
        if (jsClass != null) {
            String string = JSHtmlHighlightingUtil.getSimpleTypeWithLinkText(jsClass.getJSType(), false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleTypeWithLinkText(...)");
            return string;
        }
        String string = reference.getReferenceText();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requireNotNull(...)");
        String referenceText = string;
        String string3 = JSImportHandlingUtil.resolveTypeName(referenceText, context2);
        if (string3 == null) {
            return referenceText;
        }
        String typeName = string3;
        return Intrinsics.areEqual((Object)StringUtil.getPackageName((String)typeName), (Object)packageName) ? StringsKt.substringAfterLast$default((String)typeName, (char)'.', null, (int)2, null) : typeName;
    }

    private static final String getExtendsImplementsPlaceholder$createTypeList(AtomicInteger replacementCounter, Map<String, JSReferenceListMember> replacements, JSReferenceList referenceList) {
        CharSequence charSequence;
        if (referenceList == null) {
            return null;
        }
        JSReferenceListMember[] jSReferenceListMemberArray = referenceList.getMembers();
        Intrinsics.checkNotNullExpressionValue((Object)jSReferenceListMemberArray, (String)"getMembers(...)");
        CharSequence charSequence2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])jSReferenceListMemberArray), (Function1)getExtendsImplementsPlaceholder.createTypeList.1.INSTANCE), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<JSReferenceListMember, CharSequence>(replacementCounter, replacements){
            final /* synthetic */ AtomicInteger $replacementCounter;
            final /* synthetic */ Map<String, JSReferenceListMember> $replacements;
            {
                this.$replacementCounter = $replacementCounter;
                this.$replacements = $replacements;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(JSReferenceListMember reference) {
                String replacement = "$$Type$$Unique" + this.$replacementCounter.incrementAndGet();
                Intrinsics.checkNotNull((Object)reference);
                this.$replacements.put(replacement, reference);
                return replacement;
            }
        }), (int)30, null);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public static final /* synthetic */ String access$getReferenceType(JSClassHighlightingHelper $this, JSReferenceListMember reference, String packageName, PsiElement context2) {
        return $this.getReferenceType(reference, packageName, context2);
    }
}

