/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtReloadTasksAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtServiceComboBoxAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtShowPopupAction
extends AnAction
implements DumbAware {
    private static final Key<JsbtApplicationService> LAST_SHOWN_SERVICE = Key.create((String)"LAST_SHOWN_SERVICE");
    private static final Key<WeakReference<JBPopup>> CURRENT_POPUP = Key.create((String)"CURRENT_POPUP");

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean visible = false;
        for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
            JsbtService service2 = applicationService.getProjectService(project);
            JsbtFileManager fileManager = service2.getFileManager();
            if (!fileManager.hasBuildfiles()) continue;
            visible = true;
            break;
        }
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            return;
        }
        JsbtShowPopupAction.showPopup(project);
    }

    public static void showPopup(@NotNull Project project) {
        JBPopup popup;
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(3);
        }
        if ((popup = JsbtShowPopupAction.getCurrentPopup(project)) != null && popup.isVisible()) {
            return;
        }
        JsbtApplicationService lastShownService = JsbtShowPopupAction.getLastShownService(project);
        if (lastShownService == null || !lastShownService.getProjectService(project).getFileManager().hasBuildfiles()) {
            for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
                JsbtService service2 = applicationService.getProjectService(project);
                if (!service2.getFileManager().hasBuildfiles()) continue;
                lastShownService = applicationService;
                break;
            }
        }
        if (lastShownService != null) {
            JsbtShowPopupAction.setLastShownService(project, lastShownService);
        } else {
            lastShownService = (JsbtApplicationService)ContainerUtil.getFirstItem(JsbtApplicationService.getAllServices());
        }
        if (lastShownService != null) {
            popup = JsbtShowPopupAction.showPopup(project, lastShownService);
            popup.setRequestFocus(true);
            JsbtShowPopupAction.setCurrentPopup(project, popup);
        }
    }

    @Nullable
    private static JsbtApplicationService getLastShownService(@NotNull Project project) {
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(4);
        }
        return (JsbtApplicationService)LAST_SHOWN_SERVICE.get((UserDataHolder)project);
    }

    private static void setLastShownService(@NotNull Project project, @Nullable JsbtApplicationService service2) {
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(5);
        }
        LAST_SHOWN_SERVICE.set((UserDataHolder)project, (Object)service2);
    }

    @Nullable
    private static JBPopup getCurrentPopup(@NotNull Project project) {
        WeakReference popupRef;
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(6);
        }
        if ((popupRef = (WeakReference)CURRENT_POPUP.get((UserDataHolder)project)) != null) {
            return (JBPopup)popupRef.get();
        }
        return null;
    }

    private static void setCurrentPopup(@NotNull Project project, @NotNull JBPopup popup) {
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(7);
        }
        if (popup == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(8);
        }
        CURRENT_POPUP.set((UserDataHolder)project, new WeakReference<JBPopup>(popup));
    }

    public static boolean hidePopup(@NotNull Project project) {
        JBPopup popup;
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(9);
        }
        if ((popup = JsbtShowPopupAction.getCurrentPopup(project)) != null && popup.isVisible()) {
            popup.cancel();
            return true;
        }
        return false;
    }

    @NotNull
    private static JBPopup showPopup(final @NotNull Project project, @NotNull JsbtApplicationService service2) {
        AnAction[] actions;
        if (project == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(10);
        }
        if (service2 == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(11);
        }
        JsbtTaskTreeView treeView = service2.getProjectService(project).createTaskTreeView("tools.popup" + service2.getName());
        treeView.init();
        Tree tree = treeView.getComponent();
        for (AnAction action : actions = new AnAction[]{new JsbtAddBuildfileAction(service2), new JsbtRemoveBuildfileAction(service2, treeView), new JsbtReloadTasksAction(treeView)}) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            action.registerCustomShortcutSet(shortcutSet, (JComponent)tree);
        }
        final Ref popupRef = Ref.create();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        JsbtServiceComboBoxAction serviceComboBoxAction = new JsbtServiceComboBoxAction(service2){

            @Override
            protected void onValueChanged(final @NotNull JsbtApplicationService service2, @NotNull AnActionEvent e) {
                if (service2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.onValueChanged(service2, e);
                JBPopup popup = (JBPopup)popupRef.get();
                if (popup != null && !popup.isDisposed()) {
                    popup.addListener(new JBPopupListener(){

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            JsbtShowPopupAction.setLastShownService(project, service2);
                            JBPopup popup = JsbtShowPopupAction.showPopup(project, service2);
                            JsbtShowPopupAction.setCurrentPopup(project, popup);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/actions/JsbtShowPopupAction$1$1", "onClosed"));
                        }
                    });
                    popup.closeOk(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "service";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtShowPopupAction$1";
                objectArray[2] = "onValueChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        serviceComboBoxAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 640)), (JComponent)tree);
        serviceComboBoxAction.setSmallVariant(true);
        actionGroup.add((AnAction)serviceComboBoxAction);
        actionGroup.addSeparator();
        actionGroup.addAll(actions);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JavaScriptBuildTool", (ActionGroup)actionGroup, true);
        actionToolbar.setMinimumButtonSize((Dimension)new JBDimension(22, 22));
        JComponent toolbarComponent = actionToolbar.getComponent();
        JsbtShowPopupAction.setNotOpaqueRecursively(toolbarComponent);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree, (int)20, (int)30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Dimension treePrefSize = tree.getPreferredSize();
        scrollPane.getViewport().setPreferredSize(new Dimension(Math.max(JBUIScale.scale((int)250), Math.min(treePrefSize.width, JBUIScale.scale((int)400))), Math.max(JBUIScale.scale((int)250), Math.min(treePrefSize.height, JBUIScale.scale((int)500)))));
        ModalityState current = ModalityState.current();
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)tree).setMayBeParent(true).setRequestFocus(true).setFocusable(true).setFocusOwners(new Component[]{tree}).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(false).setMovable(true).setResizable(true).setSettingButtons((Component)toolbarComponent).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).setCancelCallback(() -> current.equals(ModalityState.current())).setDimensionServiceKey(project, "jetbrains.javascript.buildTools.run-task-popup", true).setMinSize(new Dimension(JBUIScale.scale((int)200), JBUIScale.scale((int)200))).setCancelButton(new IconButton(CommonBundle.message((String)"action.text.close", (Object[])new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        JBPopup popup = builder2.createPopup();
        popupRef.set((Object)popup);
        Disposer.register((Disposable)popup, (Disposable)treeView);
        treeView.addActionCallback(() -> popup.closeOk(null));
        popup.showCenteredInCurrentWindow(project);
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(12);
        }
        return jBPopup;
    }

    private static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            JsbtShowPopupAction.$$$reportNull$$$0(13);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
            for (Component c2 : ((JComponent)component).getComponents()) {
                JsbtShowPopupAction.setNotOpaqueRecursively(c2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtShowPopupAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtShowPopupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastShownService";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLastShownService";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentPopup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hidePopup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12 -> new IllegalStateException(string);
        };
    }
}

