/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtPersistentPath;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayout;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsbtTreeLayoutManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JsbtTreeLayoutManager
implements PersistentStateComponent<Element> {
    private static final String LAYOUTS = "layouts";
    private static final String LAYOUT = "layout";
    private static final String PLACE = "place";
    private static final String SCROLL_VIEW_POSITION = "scroll-view-position";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String SELECTED_PATHS = "selected-paths";
    private static final String PATH = "path";
    private static final String ID = "id";
    private final Map<String, JsbtTreeLayout> myMap = new LinkedHashMap<String, JsbtTreeLayout>();

    @Nullable
    public JsbtTreeLayout getLayout(@NotNull String layoutPlace) {
        if (layoutPlace == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(0);
        }
        return this.myMap.get(layoutPlace);
    }

    public void add(@NotNull JsbtTreeLayout layout) {
        if (layout == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(1);
        }
        this.myMap.put(layout.getPlace(), layout);
    }

    @Nullable
    public Element getState() {
        if (this.myMap.isEmpty()) {
            return null;
        }
        Element element = new Element(LAYOUTS);
        for (JsbtTreeLayout layout : this.myMap.values()) {
            element.addContent(JsbtTreeLayoutManager.toXml(layout));
        }
        return element;
    }

    @NotNull
    private static Element toXml(@NotNull JsbtTreeLayout layout) {
        List<JsbtPersistentPath> selectedPaths;
        if (layout == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(2);
        }
        Element element = new Element(LAYOUT);
        element.setAttribute(PLACE, layout.getPlace());
        Point position = layout.getScrollPaneViewPosition();
        if (position != null) {
            Element scrollPaneViewPositionElement = new Element(SCROLL_VIEW_POSITION);
            scrollPaneViewPositionElement.setAttribute(X, String.valueOf(position.x));
            scrollPaneViewPositionElement.setAttribute(Y, String.valueOf(position.y));
            element.addContent(scrollPaneViewPositionElement);
        }
        if (!(selectedPaths = layout.getSelectedPaths()).isEmpty()) {
            Element selectedPathsElement = new Element(SELECTED_PATHS);
            for (JsbtPersistentPath path2 : selectedPaths) {
                Element selectedPathElement = new Element(PATH);
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)selectedPathElement, (String)ID, path2.getIds());
                selectedPathsElement.addContent(selectedPathElement);
            }
            element.addContent(selectedPathsElement);
        }
        Element element2 = element;
        if (element2 == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(3);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(4);
        }
        this.myMap.clear();
        List layoutElements = state.getChildren(LAYOUT);
        for (Element child : layoutElements) {
            JsbtTreeLayout layout = JsbtTreeLayoutManager.fromXml(child);
            if (layout == null) continue;
            this.add(layout);
        }
    }

    @Nullable
    private static JsbtTreeLayout fromXml(@NotNull Element element) {
        String place;
        if (element == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(place = element.getAttributeValue(PLACE)))) {
            return null;
        }
        Point position = JsbtTreeLayoutManager.toPoint(element.getChild(SCROLL_VIEW_POSITION));
        List<JsbtPersistentPath> selectedPaths = JsbtTreeLayoutManager.parseSelectedPaths(element.getChild(SELECTED_PATHS));
        return new JsbtTreeLayout(place, position, selectedPaths);
    }

    @Nullable
    private static Point toPoint(@Nullable Element scrollPaneViewPositionElement) {
        if (scrollPaneViewPositionElement != null) {
            int x = StringUtil.parseInt((String)scrollPaneViewPositionElement.getAttributeValue(X), (int)-1);
            int y = StringUtil.parseInt((String)scrollPaneViewPositionElement.getAttributeValue(Y), (int)-1);
            if (x >= 0 && y >= 0) {
                return new Point(x, y);
            }
        }
        return null;
    }

    @NotNull
    private static List<JsbtPersistentPath> parseSelectedPaths(@Nullable Element pathsElement) {
        if (pathsElement == null) {
            List<JsbtPersistentPath> list2 = Collections.emptyList();
            if (list2 == null) {
                JsbtTreeLayoutManager.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List pathElements = pathsElement.getChildren(PATH);
        ArrayList<JsbtPersistentPath> paths = new ArrayList<JsbtPersistentPath>();
        for (Element pathElement : pathElements) {
            List ids = JDOMExternalizerUtil.getChildrenValueAttributes((Element)pathElement, (String)ID);
            paths.add(new JsbtPersistentPath(ids));
        }
        ArrayList<JsbtPersistentPath> arrayList = paths;
        if (arrayList == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static JsbtTreeLayoutManager getInstance(@NotNull Project project) {
        if (project == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(8);
        }
        JsbtTreeLayoutManager jsbtTreeLayoutManager = (JsbtTreeLayoutManager)project.getService(JsbtTreeLayoutManager.class);
        if (jsbtTreeLayoutManager == null) {
            JsbtTreeLayoutManager.$$$reportNull$$$0(9);
        }
        return jsbtTreeLayoutManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutPlace";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = LAYOUT;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toXml";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSelectedPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLayout";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

