/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.refactoring.FilePathWithCompletionFieldKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldUtil;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField;", "Lcom/intellij/ui/EditorComboBox;", "project", "Lcom/intellij/openapi/project/Project;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "text", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;Ljava/lang/String;)V", "createEditorTextField", "Lcom/intellij/ui/ComboboxEditorTextField;", "document", "Lcom/intellij/openapi/editor/Document;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isViewer", "", "preselectLastPathComponent", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "EditorBasedDocumentOwner", "FilePathCompletionListProvider", "intellij.javascript.impl"})
public final class FilePathWithCompletionField
extends EditorComboBox {
    public FilePathWithCompletionField(@NotNull Project project, @NotNull FileChooserDescriptor fileChooserDescriptor, @NlsSafe @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(FilePathWithCompletionFieldKt.access$createDocument(fileChooserDescriptor).createDocument(text2, (Language)PlainTextLanguage.INSTANCE, project), project, (FileType)PlainTextFileType.INSTANCE);
        this.addItem(text2);
        this.setSelectedItem(text2);
    }

    private final void preselectLastPathComponent(EditorEx editor) {
        String text2 = FileUtil.toCanonicalPath((String)this.getText());
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        Intrinsics.checkNotNull((Object)text2);
        int separator = StringsKt.lastIndexOf$default((CharSequence)text2, (char)'/', (int)0, (boolean)false, (int)6, null);
        int length = text2.length();
        if (separator > 0 && separator + 1 < length) {
            editor.getSelectionModel().setSelection(separator + 1, length);
        }
    }

    @NotNull
    protected ComboboxEditorTextField createEditorTextField(@NotNull Document document2, @NotNull Project project, @NotNull FileType fileType, boolean isViewer) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return new ComboboxEditorTextField(document2, project, fileType, isViewer, this){
            final /* synthetic */ FilePathWithCompletionField this$0;
            {
                this.this$0 = $receiver;
                super($document, $project, $fileType, $isViewer);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor = editorEx;
                FilePathWithCompletionField.access$preselectLastPathComponent(this.this$0, editor);
                return editor;
            }
        };
    }

    public static final /* synthetic */ void access$preselectLastPathComponent(FilePathWithCompletionField $this, EditorEx editor) {
        $this.preselectLastPathComponent(editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField$EditorBasedDocumentOwner;", "Lcom/intellij/openapi/fileChooser/ex/FileTextFieldUtil$DocumentOwner;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "finder", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;)V", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myFinder", "getCaretPosition", "", "getLength", "getText", "", "offset", "length", "insertString", "", "str", "remove", "offs", "len", "removeSelection", "setCaretPosition", "position", "setText", "text", "setTextToFile", "file", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "intellij.javascript.impl"})
    public static final class EditorBasedDocumentOwner
    implements FileTextFieldUtil.DocumentOwner {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final FileLookup.Finder myFinder;

        public EditorBasedDocumentOwner(@NotNull Editor myEditor, @NotNull FileLookup.Finder finder) {
            Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
            Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
            this.myEditor = myEditor;
            Document document2 = this.myEditor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            this.myDocument = document2;
            this.myFinder = finder;
        }

        @NotNull
        public String getText(int offset, int length) {
            if (offset >= this.myDocument.getTextLength()) {
                return "";
            }
            String string = this.myDocument.getText(new TextRange(offset, RangesKt.coerceAtMost((int)(offset + length), (int)this.myDocument.getTextLength())));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        public void remove(int offs, int len) {
            this.myDocument.deleteString(offs, offs + len);
        }

        public void insertString(int offset, @NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.myDocument.insertString(offset, (CharSequence)str);
        }

        public int getLength() {
            return this.myDocument.getTextLength();
        }

        public void removeSelection() {
            this.myEditor.getSelectionModel().removeSelection();
        }

        public void setCaretPosition(int position) {
            this.myEditor.getCaretModel().moveToOffset(position);
        }

        public int getCaretPosition() {
            return this.myEditor.getCaretModel().getOffset();
        }

        public void setText(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.myDocument.setText((CharSequence)text2);
        }

        public void setTextToFile(@NotNull FileLookup.LookupFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileTextFieldUtil.setTextToFile((FileLookup.LookupFile)file, (FileLookup.Finder)this.myFinder, (FileTextFieldUtil.DocumentOwner)this);
            this.myEditor.getCaretModel().moveToOffset(this.myDocument.getTextLength());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField$FilePathCompletionListProvider;", "Lcom/intellij/util/textCompletion/TextCompletionProvider;", "myLookupFilter", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;", "(Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;)V", "myFinder", "Lcom/intellij/openapi/fileChooser/ex/LocalFsFinder;", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "applyPrefixMatcher", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "result", "prefix", "", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getAdvertisement", "getPrefix", "text", "offset", "", "intellij.javascript.impl"})
    public static final class FilePathCompletionListProvider
    implements TextCompletionProvider {
        @NotNull
        private final FileLookup.LookupFilter myLookupFilter;
        @NotNull
        private final LocalFsFinder myFinder;

        public FilePathCompletionListProvider(@NotNull FileLookup.LookupFilter myLookupFilter) {
            Intrinsics.checkNotNullParameter((Object)myLookupFilter, (String)"myLookupFilter");
            this.myLookupFilter = myLookupFilter;
            this.myFinder = new LocalFsFinder();
        }

        @Nullable
        public String getAdvertisement() {
            return null;
        }

        @NotNull
        public CharFilter.Result acceptChar(char c2) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }

        @NotNull
        public String getPrefix(@NotNull String text2, int offset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)FileUtil.toSystemIndependentName((String)text2).subSequence(0, offset), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastIndexOf >= 0 && lastIndexOf < text2.length() - 1) {
                String string = text2.substring(lastIndexOf + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return "";
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            CompletionResultSet activeResult = result2;
            if (!Intrinsics.areEqual((Object)activeResult.getPrefixMatcher().getPrefix(), (Object)prefix)) {
                CompletionResultSet completionResultSet = activeResult.withPrefixMatcher(prefix);
                Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
                activeResult = completionResultSet;
            }
            CompletionResultSet completionResultSet = activeResult.caseInsensitive();
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"caseInsensitive(...)");
            return completionResultSet;
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            int offset = parameters.getOffset();
            String string = parameters.getEditor().getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 0;
            String string3 = string2.substring(n, offset);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String input = string3;
            FileTextFieldUtil.CompletionResult tempResult = FileTextFieldUtil.processCompletion((String)input, (FileLookup.Finder)((FileLookup.Finder)this.myFinder), (FileLookup.LookupFilter)this.myLookupFilter, (Map)new HashMap(), null);
            for (FileLookup.LookupFile file : tempResult.variants) {
                result2.addElement((LookupElement)LookupElementBuilder.create((Object)file, (String)FileTextFieldUtil.getLookupString((FileLookup.LookupFile)file, (FileLookup.Finder)((FileLookup.Finder)this.myFinder), (FileTextFieldUtil.CompletionResult)tempResult)).withIcon(file.getIcon()).withInsertHandler((arg_0, arg_1) -> FilePathCompletionListProvider.fillCompletionVariants$lambda$0(this, parameters, arg_0, arg_1)));
            }
            result2.stopHere();
        }

        private static final void fillCompletionVariants$lambda$0(FilePathCompletionListProvider this$0, CompletionParameters $parameters, InsertionContext context2, LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Editor editor = context2.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            EditorBasedDocumentOwner owner = new EditorBasedDocumentOwner(editor2, (FileLookup.Finder)this$0.myFinder);
            Object object = item.getObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.fileChooser.ex.FileLookup.LookupFile");
            FileLookup.LookupFile lookupFile = (FileLookup.LookupFile)object;
            FileTextFieldUtil.processChosenFromCompletion((FileLookup.LookupFile)lookupFile, (FileTextFieldUtil.DocumentOwner)owner, (FileLookup.Finder)((FileLookup.Finder)this$0.myFinder), (context2.getCompletionChar() == '\t' ? 1 : 0) != 0);
            if (lookupFile.isDirectory()) {
                AutoPopupController.getInstance((Project)$parameters.getOriginalFile().getProject()).autoPopupMemberLookup(editor2, null);
            }
        }
    }
}

