/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.webSymbols.references;

import com.intellij.javascript.webSymbols.JSWebSymbolUtils;
import com.intellij.javascript.webSymbols.references.JsWebSymbolResolveUtilKt;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceExpressionResolver;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/webSymbols/references/JSWebSymbolPsiReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "ReferenceExpressionPsiReferenceProvider", "WebSymbolPsiReference", "intellij.javascript.web"})
public final class JSWebSymbolPsiReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.registerReferenceProvider((ElementPattern)JSPatterns.jsReferenceExpression(), (PsiReferenceProvider)new ReferenceExpressionPsiReferenceProvider());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/webSymbols/references/JSWebSymbolPsiReferenceContributor$ReferenceExpressionPsiReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.javascript.web"})
    @SourceDebugExtension(value={"SMAP\nJSWebSymbolPsiReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSWebSymbolPsiReferenceContributor.kt\ncom/intellij/javascript/webSymbols/references/JSWebSymbolPsiReferenceContributor$ReferenceExpressionPsiReferenceProvider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,59:1\n26#2:60\n*S KotlinDebug\n*F\n+ 1 JSWebSymbolPsiReferenceContributor.kt\ncom/intellij/javascript/webSymbols/references/JSWebSymbolPsiReferenceContributor$ReferenceExpressionPsiReferenceProvider\n*L\n41#1:60\n*E\n"})
    private static final class ReferenceExpressionPsiReferenceProvider
    extends PsiReferenceProvider {
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
            PsiReference[] psiReferenceArray;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(element instanceof JSReferenceExpression)) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }
            Pair<WebSymbol, WebSymbolsQueryExecutor> pair = JsWebSymbolResolveUtilKt.matchJSSymbol((JSReferenceExpression)element);
            if (pair == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }
            Pair<WebSymbol, WebSymbolsQueryExecutor> pair2 = pair;
            WebSymbol symbol = (WebSymbol)pair2.component1();
            WebSymbolsQueryExecutor queryExecutor2 = (WebSymbolsQueryExecutor)pair2.component2();
            if (symbol != null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[]{new WebSymbolPsiReference(symbol, (JSReferenceExpression)element)};
                psiReferenceArray = psiReferenceArray2;
            } else if (WebSymbolsQueryExecutor.hasExclusiveScopeFor$default((WebSymbolsQueryExecutor)queryExecutor2, (WebSymbolQualifiedKind)WebSymbol.Companion.getJS_SYMBOLS(), null, (int)2, null)) {
                PsiReference[] psiReferenceArray3 = new PsiReference[]{new WebSymbolPsiReference(null, (JSReferenceExpression)element)};
                psiReferenceArray = psiReferenceArray3;
            } else {
                boolean $i$f$emptyArray = false;
                psiReferenceArray = new PsiReference[]{};
            }
            return psiReferenceArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/webSymbols/references/JSWebSymbolPsiReferenceContributor$WebSymbolPsiReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver$PsiReferenceFromWebSymbolContributor;", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "expr", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "(Lcom/intellij/webSymbols/WebSymbol;Lcom/intellij/lang/javascript/psi/JSReferenceExpression;)V", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "intellij.javascript.web"})
    public static final class WebSymbolPsiReference
    extends PsiPolyVariantReferenceBase<PsiElement>
    implements TypeScriptReferenceExpressionResolver.PsiReferenceFromWebSymbolContributor {
        @Nullable
        private final WebSymbol symbol;

        public WebSymbolPsiReference(@Nullable WebSymbol symbol, @NotNull JSReferenceExpression expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            super((PsiElement)expr, expr.getRangeInElement(), false);
            this.symbol = symbol;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray;
            if (this.symbol != null) {
                ResolveResult[] resolveResultArray2 = new ResolveResult[1];
                PsiElement psiElement = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                resolveResultArray2[0] = new JSResolveResult((PsiElement)JSWebSymbolUtils.toJSImplicitElement(this.symbol, psiElement));
                resolveResultArray = resolveResultArray2;
            } else {
                ResolveResult[] resolveResultArray3 = new ResolveResult[]{new JSResolveResult(null, null, JSResolveResult.ProblemKind.UNRESOLVED_SYMBOL)};
                resolveResultArray = resolveResultArray3;
            }
            return resolveResultArray;
        }
    }
}

