/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.css;

import com.intellij.javascript.web.css.CssClassInJSLiteralOrIdentifierReferenceProvider;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/web/css/CssClassInJSLiteralOrIdentifierReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.javascript.web"})
@SourceDebugExtension(value={"SMAP\nCssClassInJSLiteralOrIdentifierReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssClassInJSLiteralOrIdentifierReferenceProvider.kt\ncom/intellij/javascript/web/css/CssClassInJSLiteralOrIdentifierReferenceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n1#2:152\n37#3,2:153\n*S KotlinDebug\n*F\n+ 1 CssClassInJSLiteralOrIdentifierReferenceProvider.kt\ncom/intellij/javascript/web/css/CssClassInJSLiteralOrIdentifierReferenceProvider\n*L\n59#1:153,2\n*E\n"})
public final class CssClassInJSLiteralOrIdentifierReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String text2 = null;
        int offset = 0;
        if (element instanceof JSLiteralExpression) {
            text2 = ((JSLiteralExpression)element).getStringValue();
            offset = 1;
        } else {
            IElementType iElementType;
            PsiElement nameSource = null;
            nameSource = element;
            if (element instanceof JSProperty) {
                PsiElement psiElement;
                PsiElement psiElement2 = ((JSProperty)element).getNameIdentifier();
                if (psiElement2 != null) {
                    PsiElement psiElement3;
                    PsiElement it = psiElement3 = psiElement2;
                    boolean bl = false;
                    nameSource = it;
                    psiElement = psiElement3;
                } else {
                    psiElement = null;
                }
                if (psiElement != null) {
                    offset = nameSource.getStartOffsetInParent();
                }
            }
            if (Intrinsics.areEqual((Object)(iElementType = nameSource.getNode().getElementType()), (Object)JSTokenTypes.STRING_LITERAL)) {
                text2 = StringUtil.unquoteString((String)nameSource.getText());
                ++offset;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.IDENTIFIER) ? true : Intrinsics.areEqual((Object)iElementType, (Object)JSElementTypes.REFERENCE_EXPRESSION)) {
                text2 = nameSource.getText();
            }
        }
        if (text2 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        int finalOffset = offset;
        CssResolveUtil.consumeClassNames((String)text2, (PsiElement)element, (arg_0, arg_1) -> CssClassInJSLiteralOrIdentifierReferenceProvider.getReferencesByElement$lambda$1((Function2)new Function2<String, TextRange, Unit>(element, finalOffset, (SmartList<PsiReference>)result2){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ int $finalOffset;
            final /* synthetic */ SmartList<PsiReference> $result;
            {
                this.$element = $element;
                this.$finalOffset = $finalOffset;
                this.$result = $result;
                super(2);
            }

            public final void invoke(String string, TextRange range) {
                CssElementDescriptorProvider cssElementDescriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)this.$element);
                Intrinsics.checkNotNull((Object)cssElementDescriptorProvider);
                CssElementDescriptorProvider descriptorProvider = cssElementDescriptorProvider;
                TextRange textRange = range.shiftRight(this.$finalOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextRange finalRange = textRange;
                this.$result.add((Object)descriptorProvider.getStyleReference(this.$element, finalRange.getStartOffset(), finalRange.getEndOffset(), true));
            }
        }, arg_0, arg_1));
        Collection $this$toTypedArray$iv = (Collection)result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private static final void getReferencesByElement$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    public static final void register(@NotNull PsiReferenceRegistrar registrar, @NotNull Language language, @NotNull Class<? extends JSEmbeddedContent> embeddedContentClass, @NotNull Function<XmlAttribute, Boolean> attributeFilter) {
        Companion.register(registrar, language, embeddedContentClass, attributeFilter);
    }

    @JvmStatic
    @NotNull
    public static final String getClassesFromEmbeddedContent(@Nullable JSEmbeddedContent binding) {
        return Companion.getClassesFromEmbeddedContent(binding);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0002J\"\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0002J9\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\"\u0010\u000e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b0\u000f\"\n\u0012\u0006\b\u0001\u0012\u00020\u00060\bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0007J<\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001bH\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/web/css/CssClassInJSLiteralOrIdentifierReferenceProvider$Companion;", "", "()V", "acceptJSLiteral", "", "literal", "Lcom/intellij/psi/PsiElement;", "embeddedContentClass", "Ljava/lang/Class;", "Lcom/intellij/lang/javascript/psi/JSEmbeddedContent;", "acceptJSProperty", "property", "checkHierarchy", "element", "classes", "", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Z", "getClassesFromEmbeddedContent", "", "binding", "register", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "language", "Lcom/intellij/lang/Language;", "attributeFilter", "Ljava/util/function/Function;", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.javascript.web"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void register(@NotNull PsiReferenceRegistrar registrar, @NotNull Language language, @NotNull Class<? extends JSEmbeddedContent> embeddedContentClass, @NotNull Function<XmlAttribute, Boolean> attributeFilter) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(embeddedContentClass, (String)"embeddedContentClass");
            Intrinsics.checkNotNullParameter(attributeFilter, (String)"attributeFilter");
            registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withLanguage(language)).and((ElementPattern)new FilterPattern(new ElementFilter(embeddedContentClass, attributeFilter){
                final /* synthetic */ Class<? extends JSEmbeddedContent> $embeddedContentClass;
                final /* synthetic */ Function<XmlAttribute, Boolean> $attributeFilter;
                {
                    this.$embeddedContentClass = $embeddedContentClass;
                    this.$attributeFilter = $attributeFilter;
                }

                public boolean isAcceptable(@NotNull Object element, @Nullable PsiElement context2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlAttribute.class);
                    if (xmlAttribute != null) {
                        XmlAttribute xmlAttribute2 = xmlAttribute;
                        Function<XmlAttribute, Boolean> function2 = this.$attributeFilter;
                        XmlAttribute it = xmlAttribute2;
                        boolean bl2 = false;
                        bl = Intrinsics.areEqual((Object)function2.apply(it), (Object)true);
                    } else {
                        bl = false;
                    }
                    return bl && com.intellij.javascript.web.css.CssClassInJSLiteralOrIdentifierReferenceProvider$Companion.access$acceptJSLiteral(CssClassInJSLiteralOrIdentifierReferenceProvider.Companion, context2, this.$embeddedContentClass);
                }

                public boolean isClassAcceptable(@NotNull Class<?> hintClass) {
                    Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
                    return true;
                }
            })), (PsiReferenceProvider)new CssClassInJSLiteralOrIdentifierReferenceProvider());
            registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSProperty.class).withLanguage(language)).and((ElementPattern)new FilterPattern(new ElementFilter(embeddedContentClass, attributeFilter){
                final /* synthetic */ Class<? extends JSEmbeddedContent> $embeddedContentClass;
                final /* synthetic */ Function<XmlAttribute, Boolean> $attributeFilter;
                {
                    this.$embeddedContentClass = $embeddedContentClass;
                    this.$attributeFilter = $attributeFilter;
                }

                public boolean isAcceptable(@NotNull Object element, @Nullable PsiElement context2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlAttribute.class);
                    if (xmlAttribute != null) {
                        XmlAttribute xmlAttribute2 = xmlAttribute;
                        Function<XmlAttribute, Boolean> function2 = this.$attributeFilter;
                        XmlAttribute it = xmlAttribute2;
                        boolean bl2 = false;
                        bl = Intrinsics.areEqual((Object)function2.apply(it), (Object)true);
                    } else {
                        bl = false;
                    }
                    return bl && com.intellij.javascript.web.css.CssClassInJSLiteralOrIdentifierReferenceProvider$Companion.access$acceptJSProperty(CssClassInJSLiteralOrIdentifierReferenceProvider.Companion, context2, this.$embeddedContentClass);
                }

                public boolean isClassAcceptable(@NotNull Class<?> hintClass) {
                    Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
                    return true;
                }
            })), (PsiReferenceProvider)new CssClassInJSLiteralOrIdentifierReferenceProvider());
        }

        @JvmStatic
        @NotNull
        public final String getClassesFromEmbeddedContent(@Nullable JSEmbeddedContent binding) {
            PsiElement psiElement;
            Sequence sequence;
            Sequence sequence2;
            Object[] objectArray;
            StringBuilder result2 = new StringBuilder();
            if (binding != null && (objectArray = binding.getChildren()) != null && (sequence2 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence = SequencesKt.filter((Sequence)sequence2, (Function1)getClassesFromEmbeddedContent.1.INSTANCE)) != null && (psiElement = (PsiElement)SequencesKt.firstOrNull((Sequence)sequence)) != null) {
                psiElement.accept((PsiElementVisitor)new JSElementVisitor(result2){
                    final /* synthetic */ StringBuilder $result;
                    {
                        this.$result = $result;
                    }

                    public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        JSExpression[] jSExpressionArray = node.getExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getExpressions(...)");
                        for (JSExpression expression : jSExpressionArray) {
                            expression.accept(this);
                        }
                    }

                    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.isQuotedLiteral()) {
                            this.$result.append(node.getStringValue());
                            this.$result.append(' ');
                        }
                    }

                    public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        JSProperty[] jSPropertyArray = node.getProperties();
                        Intrinsics.checkNotNullExpressionValue((Object)jSPropertyArray, (String)"getProperties(...)");
                        for (JSProperty property : jSPropertyArray) {
                            property.accept(this);
                        }
                    }

                    public void visitJSProperty(@NotNull JSProperty node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.$result.append(node.getName());
                        this.$result.append(' ');
                    }
                });
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final boolean acceptJSLiteral(PsiElement literal, Class<? extends JSEmbeddedContent> embeddedContentClass) {
            Class[] classArray;
            return literal instanceof JSLiteralExpression && ((JSLiteralExpression)literal).isQuotedLiteral() && (embeddedContentClass.isInstance(((JSLiteralExpression)literal).getParent()) || this.checkHierarchy(literal, classArray = new Class[]{JSArrayLiteralExpression.class, embeddedContentClass}));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean acceptJSProperty(PsiElement property, Class<? extends JSEmbeddedContent> embeddedContentClass) {
            if (!(property instanceof JSProperty)) return false;
            Class[] classArray = new Class[]{JSObjectLiteralExpression.class, embeddedContentClass};
            if (!this.checkHierarchy(property, classArray)) return false;
            return true;
        }

        private final boolean checkHierarchy(PsiElement element, Class<? extends PsiElement> ... classes) {
            PsiElement parent = element;
            for (Class<? extends PsiElement> cls : classes) {
                PsiElement psiElement = parent;
                Object object = parent = psiElement != null ? psiElement.getParent() : null;
                if (parent != null && cls.isInstance(parent)) continue;
                return false;
            }
            return true;
        }

        public static final /* synthetic */ boolean access$acceptJSLiteral(Companion $this, PsiElement literal, Class embeddedContentClass) {
            return $this.acceptJSLiteral(literal, embeddedContentClass);
        }

        public static final /* synthetic */ boolean access$acceptJSProperty(Companion $this, PsiElement property, Class embeddedContentClass) {
            return $this.acceptJSProperty(property, embeddedContentClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

