/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNodePackageRefResolver
implements NodePackageRefResolver {
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final Supplier<? extends NodeJsInterpreter> myInterpreterSupplier;
    private final Map<String, NodePackage> myCache;
    private volatile NodeJsInterpreter myLastInterpreter;
    private volatile long myLastExternalChangesCount;

    public DefaultNodePackageRefResolver(@Nullable Project project, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (descriptor == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(0);
        }
        this.myCache = new HashMap<String, NodePackage>();
        this.myProject = project;
        this.myDescriptor = descriptor;
        this.myInterpreterSupplier = interpreterSupplier;
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref) {
        NodePackage pkg;
        if (ref == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(1);
        }
        if ((pkg = ref.getConstantPackage()) != null) {
            return pkg;
        }
        return this.resolve(ref, this.myInterpreterSupplier != null ? this.myInterpreterSupplier.get() : null);
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref, @Nullable NodeJsInterpreter interpreter2) {
        NodePackage pkg;
        if (ref == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(2);
        }
        if (this.myProject != null) {
            ref = this.myDescriptor.dereferenceIfProjectRef(this.myProject, ref);
        }
        if ((pkg = ref.getConstantPackage()) != null) {
            return pkg;
        }
        if (interpreter2 == null) {
            return null;
        }
        long externalChangesCount = SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        if (!interpreter2.equals(this.myLastInterpreter) || this.myLastExternalChangesCount != externalChangesCount) {
            this.myCache.clear();
        }
        this.myLastInterpreter = interpreter2;
        this.myLastExternalChangesCount = externalChangesCount;
        String name = ref.getReferenceName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        pkg = this.myCache.get(name);
        if (pkg == null) {
            pkg = this.doResolveRef(interpreter2, name);
            this.myCache.put(name, pkg);
        }
        return pkg;
    }

    @Nullable
    protected NodePackage doResolveRef(@NotNull NodeJsInterpreter interpreter2, @NotNull String referenceName) {
        if (interpreter2 == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(3);
        }
        if (referenceName == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public boolean isValidPackage(@NotNull NodePackageRef ref, @Nullable NodePackage pkg, @Nullable NodeJsInterpreter interpreter2) {
        if (ref == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(5);
        }
        return pkg != null && (this.myProject != null ? pkg.isValid(this.myProject, interpreter2) : pkg.isValid());
    }

    @Nullable
    public static File findPackageDir(@NotNull File exeFile) {
        File root;
        if (exeFile == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(6);
        }
        if (SystemInfo.isWindows) {
            File dir = exeFile.getParentFile();
            if (dir != null && "bin".equalsIgnoreCase(dir.getName())) {
                dir = dir.getParentFile();
            }
            return DefaultNodePackageRefResolver.isPackageDir(dir) ? dir : null;
        }
        File binDir = exeFile.getParentFile();
        File file = root = binDir != null ? binDir.getParentFile() : null;
        if (DefaultNodePackageRefResolver.isPackageDir(root)) {
            return root;
        }
        Path path2 = Paths.get(exeFile.toURI());
        try {
            Path realPath = path2.toRealPath(new LinkOption[0]);
            if (!path2.toString().equals(realPath.toString())) {
                File libexecDir;
                binDir = new File(realPath.toString()).getParentFile();
                File file2 = root = binDir != null ? binDir.getParentFile() : null;
                if (DefaultNodePackageRefResolver.isPackageDir(root)) {
                    return root;
                }
                if (root != null && DefaultNodePackageRefResolver.isPackageDir(libexecDir = new File(root, "libexec"))) {
                    return libexecDir;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isPackageDir(@Nullable File dir) {
        return dir != null && new File(dir, "package.json").isFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/util/DefaultNodePackageRefResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doResolveRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPackage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

