/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.SemVer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/nodejs/library/core/NodeTypingsDownloadSession;", "", "()V", "NODE_TYPINGS_PACKAGE", "", "downloadSync", "Lcom/intellij/util/text/SemVer;", "nodeVersion", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "findNodeTypingsPackageDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lcom/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$NodeLibraryVersion;", "findTypingsVersion", "getNodeTypingsPackageDirPath", "Ljava/nio/file/Path;", "isReconfigurationNeeded", "", "start", "Ljava/util/concurrent/CompletableFuture;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeTypingsDownloadSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTypingsDownloadSession.kt\ncom/intellij/javascript/nodejs/library/core/NodeTypingsDownloadSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class NodeTypingsDownloadSession {
    @NotNull
    public static final NodeTypingsDownloadSession INSTANCE = new NodeTypingsDownloadSession();
    @NotNull
    private static final String NODE_TYPINGS_PACKAGE = "@types/node";

    private NodeTypingsDownloadSession() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<SemVer> start(@NotNull SemVer nodeVersion, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)nodeVersion, (String)"nodeVersion");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CompletableFuture<SemVer> completableFuture = CompletableFuture.supplyAsync(() -> NodeTypingsDownloadSession.start$lambda$0(nodeVersion, indicator, project), AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private final SemVer downloadSync(SemVer nodeVersion, ProgressIndicator indicator, Project project) {
        ProgressWrapper installProgress = (ProgressWrapper)new SensitiveProgressWrapper(indicator);
        try {
            SemVer typingsVersion = this.findTypingsVersion(nodeVersion);
            Future<VirtualFile> future = TypeScriptExternalDefinitionsRegistry.Companion.getInstance().installPackage(new TypeScriptPackageName(NODE_TYPINGS_PACKAGE, typingsVersion, false, 4, null), project, (ProgressIndicator)installProgress);
            future.get(2L, TimeUnit.MINUTES);
            return typingsVersion;
        }
        catch (TimeoutException e) {
            installProgress.cancel();
            Object[] objectArray = new Object[]{NODE_TYPINGS_PACKAGE};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{NODE_TYPINGS_PACKAGE};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
    }

    private final SemVer findTypingsVersion(SemVer nodeVersion) {
        SemVer typingsVersion;
        SemVer semVer = typingsVersion = TypeScriptExternalDefinitionsRegistry.Companion.getInstance().findMatchedTypingsVersion(nodeVersion, NODE_TYPINGS_PACKAGE);
        if (semVer == null) {
            throw new RuntimeException("No @types/node versions available");
        }
        return semVer;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findNodeTypingsPackageDir(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        VirtualFile typingsVirtualDir;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path path2 = INSTANCE.getNodeTypingsPackageDirPath(version2);
        if (path2 == null) {
            return null;
        }
        Path typingsPath = path2;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile(typingsPath);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile it = virtualFile = (typingsVirtualDir = virtualFile2);
        boolean bl = false;
        return typingsVirtualDir.isDirectory() && typingsVirtualDir.isValid() ? virtualFile : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isReconfigurationNeeded(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path typingsPath = this.getNodeTypingsPackageDirPath(version2);
        if (typingsPath == null) return true;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(typingsPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private final Path getNodeTypingsPackageDirPath(NodeCoreLibraryConfigurator.NodeLibraryVersion version2) throws InvalidPathException {
        SemVer semVer = version2.getNodeTypingsVersion();
        if (semVer == null) {
            return null;
        }
        SemVer typingsVersion = semVer;
        TypeScriptPackageName typingsPackage = new TypeScriptPackageName(NODE_TYPINGS_PACKAGE, typingsVersion, false, 4, null);
        String string = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath$default(TypeScriptExternalDefinitionsRegistry.Companion, typingsPackage, null, 2, null);
        if (string == null) {
            return null;
        }
        String exactPackagePath = string;
        return Path.of(exactPackagePath, new String[0]);
    }

    private static final SemVer start$lambda$0(SemVer $nodeVersion, ProgressIndicator $indicator, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$nodeVersion, (String)"$nodeVersion");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return INSTANCE.downloadSync($nodeVersion, $indicator, $project);
    }
}

