/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.fus;

import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadUtil;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.fus.LocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.fus.NvmrcStatus;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.npm.WorkingDirectoryDependentNpmPackageVersionManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.util.text.SemVer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0000\u001a&\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u0002*\u0004\u0018\u00010\u0010H\u0000\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0010H\u0000\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\nH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"PACKAGE_MANAGERS", "", "", "getPACKAGE_MANAGERS", "()Ljava/util/List;", "getNvmrcStatus", "Lcom/intellij/javascript/nodejs/interpreter/fus/NvmrcStatus;", "nvmrcFileInfo", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$NodeVersionFileInfo;", "interpreterVersion", "Lcom/intellij/util/text/SemVer;", "getPackageManagerName", "packageManagerRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "getPackageManagerVersion", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "packageManagerPkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "project", "Lcom/intellij/openapi/project/Project;", "guessPackageManagerName", "pkg", "getTypeId", "getVersionSync", "toVersion", "Lcom/intellij/openapi/util/Version;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeInterpreterAndPackageManagerStateUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeInterpreterAndPackageManagerStateUsagesCollector.kt\ncom/intellij/javascript/nodejs/interpreter/fus/NodeInterpreterAndPackageManagerStateUsagesCollectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
public final class NodeInterpreterAndPackageManagerStateUsagesCollectorKt {
    @NotNull
    private static final List<String> PACKAGE_MANAGERS;

    @Nullable
    public static final String getPackageManagerName(@NotNull NodePackageRef packageManagerRef) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageManagerRef, (String)"packageManagerRef");
        if (packageManagerRef.isConstant()) {
            NodePackage nodePackage = packageManagerRef.getConstantPackage();
            Intrinsics.checkNotNull((Object)nodePackage);
            string = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.guessPackageManagerName(nodePackage);
        } else {
            String string2 = packageManagerRef.getReferenceName();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    private static final SemVer getPackageManagerVersion(NodeJsInterpreter interpreter2, NodePackage packageManagerPkg, Project project) {
        SemVer semVer;
        if (packageManagerPkg == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SemVer("1.0.0", 1, 0, 0);
        }
        CompletableFuture<SemVer> versionFuture = new CompletableFuture<SemVer>();
        if (packageManagerPkg instanceof NpmNodePackage && interpreter2 != null) {
            WorkingDirectoryDependentNpmPackageVersionManager.getInstance(project).fetchVersion(interpreter2, packageManagerPkg, arg_0 -> NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion$lambda$0(versionFuture, arg_0));
        } else {
            packageManagerPkg.getVersionPromise(project).onSuccess(arg_0 -> NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion$lambda$1((Function1)new Function1<SemVer, Unit>(versionFuture){
                final /* synthetic */ CompletableFuture<SemVer> $versionFuture;
                {
                    this.$versionFuture = $versionFuture;
                    super(1);
                }

                public final void invoke(SemVer it) {
                    this.$versionFuture.complete(it);
                }
            }, arg_0));
        }
        try {
            semVer = versionFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            semVer = null;
        }
        return semVer;
    }

    private static final String guessPackageManagerName(NodePackage pkg) {
        String string;
        if (NpmUtil.isYarnAlikePackage(pkg)) {
            string = "yarn";
        } else if (NpmUtil.isPnpmPackage(pkg)) {
            string = "pnpm";
        } else {
            String string2 = pkg.getSystemIndependentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSystemIndependentPath(...)");
            string = StringsKt.contains((CharSequence)string2, (CharSequence)"npm", (boolean)true) ? "npm" : null;
        }
        return string;
    }

    @NotNull
    public static final List<String> getPACKAGE_MANAGERS() {
        return PACKAGE_MANAGERS;
    }

    @NotNull
    public static final String getTypeId(@Nullable NodeJsInterpreter $this$getTypeId) {
        if ($this$getTypeId == null) {
            return "unresolved";
        }
        try {
            TargetEnvironmentType<?> targetEnvironmentType = $this$getTypeId.getTargetEnvironmentType();
            if (targetEnvironmentType != null) {
                TargetEnvironmentType<?> it = targetEnvironmentType;
                boolean bl = false;
                return it.getId();
            }
        }
        catch (IllegalStateException e) {
            return "unresolved";
        }
        if ($this$getTypeId instanceof NodeJsDownloadableInterpreter) {
            return LocalInterpreterType.DOWNLOADED.id();
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = $this$getTypeId instanceof NodeJsLocalInterpreter ? (NodeJsLocalInterpreter)$this$getTypeId : null;
        if (nodeJsLocalInterpreter == null) {
            return "other";
        }
        NodeJsLocalInterpreter localInterpreter = nodeJsLocalInterpreter;
        String string = localInterpreter.getInterpreterSystemIndependentPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterSystemIndependentPath(...)");
        String interpreterPath = string;
        LocalInterpreterType localType = NodeDownloadUtil.INSTANCE.isDownloaded(localInterpreter) ? LocalInterpreterType.DOWNLOADED : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.nvm/", (boolean)false, (int)2, null) ? LocalInterpreterType.NVM : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.volta/", (boolean)false, (int)2, null) ? LocalInterpreterType.VOLTA : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.asdf/", (boolean)false, (int)2, null) ? LocalInterpreterType.ASDF : (StringsKt.startsWith$default((String)interpreterPath, (String)"/usr/bin/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)interpreterPath, (String)"/usr/local/bin/", (boolean)false, (int)2, null) ? LocalInterpreterType.SYSTEM : LocalInterpreterType.OTHER))));
        return localType.id();
    }

    @Nullable
    public static final SemVer getVersionSync(@NotNull NodeJsInterpreter $this$getVersionSync) {
        SemVer semVer;
        Intrinsics.checkNotNullParameter((Object)$this$getVersionSync, (String)"<this>");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SemVer("21.0.0", 21, 0, 0);
        }
        try {
            semVer = (SemVer)$this$getVersionSync.provideCachedVersionOrFetch().blockingGet(500);
        }
        catch (Exception e) {
            semVer = null;
        }
        return semVer;
    }

    @Nullable
    public static final Version toVersion(@Nullable SemVer $this$toVersion) {
        Version version2;
        SemVer semVer = $this$toVersion;
        if (semVer != null) {
            SemVer it = semVer;
            boolean bl = false;
            version2 = new Version(it.getMajor(), it.getMinor(), it.getPatch());
        } else {
            version2 = null;
        }
        return version2;
    }

    private static final NvmrcStatus getNvmrcStatus(NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo, SemVer interpreterVersion) {
        NodeJsLocalInterpreter nvmrcInterpreter;
        NodeJsLocalInterpreter nodeJsLocalInterpreter = nvmrcInterpreter = NodeJsLocalInterpreterManager.resolveNvmRcInterpreter(nvmrcFileInfo.getFileContent(), 0);
        SemVer nvmrcInterpreterVersion = nodeJsLocalInterpreter != null ? NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getVersionSync(nodeJsLocalInterpreter) : null;
        return new NvmrcStatus(interpreterVersion != null && Intrinsics.areEqual((Object)interpreterVersion, (Object)nvmrcInterpreterVersion), nvmrcInterpreter != null);
    }

    private static final void getPackageManagerVersion$lambda$0(CompletableFuture $versionFuture, SemVer it) {
        Intrinsics.checkNotNullParameter((Object)$versionFuture, (String)"$versionFuture");
        $versionFuture.complete(it);
    }

    private static final void getPackageManagerVersion$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ NvmrcStatus access$getNvmrcStatus(NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo, SemVer interpreterVersion) {
        return NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getNvmrcStatus(nvmrcFileInfo, interpreterVersion);
    }

    public static final /* synthetic */ SemVer access$getPackageManagerVersion(NodeJsInterpreter interpreter2, NodePackage packageManagerPkg, Project project) {
        return NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion(interpreter2, packageManagerPkg, project);
    }

    static {
        Object[] objectArray = new String[]{"npm", "yarn", "pnpm"};
        PACKAGE_MANAGERS = CollectionsKt.listOf((Object[])objectArray);
    }
}

