/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeStackTraceFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeStacktraceFinder();
    private final NodeCoreLibraryManager myCoreLibraryManager;
    private NodeTargetRun myTargetRun;

    public NodeStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(0);
        }
        this(project, (String)null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(1);
        }
        this(project, baseDir != null ? baseDir.getAbsolutePath() : null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable File baseDir, @Nullable NodeTargetRun targetRun) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(2);
        }
        this(project, baseDir != null ? baseDir.getAbsolutePath() : null, targetRun);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(3);
        }
        this(project, NodeStackTraceFilter.findDir((String)baseDir));
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable String baseDir, @Nullable NodeTargetRun targetRun) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(4);
        }
        this(project, NodeStackTraceFilter.findDir((String)baseDir));
        this.myTargetRun = targetRun;
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable VirtualFile baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(5);
        }
        super(project, baseDir);
        this.myCoreLibraryManager = NodeCoreLibraryManager.getInstance(project);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(6);
        }
        List list2 = FINDER.find(line);
        if (list2 == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        if (filePath == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(8);
        }
        if (this.myTargetRun != null && !(this.myTargetRun.getInterpreter() instanceof NodeJsLocalInterpreter) && filePath.startsWith("/")) {
            try {
                filePath = Objects.requireNonNull((String)this.myTargetRun.convertTargetPathToLocal(filePath).blockingGet(0));
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        filePath = StringUtil.trimStart((String)filePath, (String)"file://");
        VirtualFile file = super.findFile(filePath = NodeConsoleAdditionalFilter.convertWslPath(filePath));
        if (file == null) {
            file = this.myCoreLibraryManager.findCoreModuleFileByName(FileUtilRt.getNameWithoutExtension((String)filePath));
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeStackTraceFilter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeStackTraceFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static class NodeStacktraceFinder
    implements FileHyperlinkRawDataFinder {
        private static final String BABEL_SYNTAX_ERROR = "SyntaxError:";
        private static final PatternBasedFileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+(.+?):(\\d+)(:\\d+)?\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+.*\\((.+?):(\\d+)(:\\d+)?\\)\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeStacktraceFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            List result2;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(0);
            }
            if (!(result2 = PATTERN_FINDER.find(line)).isEmpty()) {
                List list2 = result2;
                if (list2 == null) {
                    NodeStacktraceFinder.$$$reportNull$$$0(1);
                }
                return list2;
            }
            FileHyperlinkRawData data = NodeStacktraceFinder.parseAsBabelError(line);
            List list3 = ContainerUtil.createMaybeSingletonList((Object)data);
            if (list3 == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(2);
            }
            return list3;
        }

        @Nullable
        private static FileHyperlinkRawData parseAsBabelError(@NotNull String line) {
            int pathStartInd;
            int syntaxErrorInd;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(3);
            }
            if ((syntaxErrorInd = line.indexOf(BABEL_SYNTAX_ERROR)) == -1) {
                return null;
            }
            if (syntaxErrorInd > 0 && !Character.isWhitespace(line.charAt(syntaxErrorInd - 1))) {
                return null;
            }
            for (pathStartInd = syntaxErrorInd + BABEL_SYNTAX_ERROR.length(); pathStartInd < line.length() && Character.isWhitespace(line.charAt(pathStartInd)); ++pathStartInd) {
            }
            int pathEndInd = line.indexOf(": ", pathStartInd + 1);
            if (pathEndInd == -1) {
                return null;
            }
            while (pathEndInd > 0 && Character.isWhitespace(line.charAt(pathEndInd - 1))) {
                --pathEndInd;
            }
            int columnEndInd = line.lastIndexOf(41);
            if (columnEndInd == -1) {
                return null;
            }
            int columnStartInd = NodeStacktraceFinder.findNumberStartInd(line, columnEndInd);
            if (columnStartInd == -1) {
                return null;
            }
            int lineEndInd = columnStartInd - 1;
            if (line.charAt(lineEndInd) != ':') {
                return null;
            }
            int lineStartInd = NodeStacktraceFinder.findNumberStartInd(line, lineEndInd);
            if (lineStartInd == -1) {
                return null;
            }
            int lineNumber = NodeStacktraceFinder.parseNumber(line, lineStartInd, lineEndInd);
            int columnNumber = NodeStacktraceFinder.parseNumber(line, columnStartInd, columnEndInd);
            if (lineNumber <= 0 || columnNumber <= 0) {
                return null;
            }
            return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), lineNumber - 1, columnNumber - 1, pathStartInd, columnEndInd + 1);
        }

        private static int findNumberStartInd(@NotNull String line, int digitEndInd) {
            int digitStartInd;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(4);
            }
            if ((digitStartInd = digitEndInd - 1) < 0 || !Character.isDigit(line.charAt(digitStartInd))) {
                return -1;
            }
            while (digitStartInd > 0 && Character.isDigit(line.charAt(digitStartInd - 1))) {
                --digitStartInd;
            }
            return digitStartInd;
        }

        private static int parseNumber(@NotNull String line, int startInd, int endInd) {
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(5);
            }
            if (startInd < 0 || startInd >= endInd || endInd > line.length()) {
                return -1;
            }
            return StringUtil.parseInt((String)line.substring(startInd, endInd), (int)-1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "parseAsBabelError";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findNumberStartInd";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseNumber";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

