/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.javascript.microservices.JSUrlPathReferenceProviderKt;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlSegmentReferenceTarget;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/microservices/JSUrlPathReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "urlPathReferenceInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/intellij/lang/javascript/psi/JSExpression;", "(Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;)V", "acceptsTarget", "", "target", "Lcom/intellij/psi/PsiElement;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.javascript.langInjection"})
public final class JSUrlPathReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathReferenceInjector<JSExpression> urlPathReferenceInjector;
    @NotNull
    private static final Key<JSExpression> FULL_URL_EXPRESSION;
    @NotNull
    private static final Key<UrlPathContext> BASE_CONTEXT_PROVIDER;

    public JSUrlPathReferenceProvider(@NotNull UrlPathReferenceInjector<JSExpression> urlPathReferenceInjector) {
        Intrinsics.checkNotNullParameter(urlPathReferenceInjector, (String)"urlPathReferenceInjector");
        this.urlPathReferenceInjector = urlPathReferenceInjector;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JSExpression jSExpression = (JSExpression)context2.get(FULL_URL_EXPRESSION);
        if (jSExpression == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        JSExpression jsExpressionForFullUrl = jSExpression;
        Object[] fullReferences = this.urlPathReferenceInjector.buildFullUrlReference((Object)jsExpressionForFullUrl, element);
        if (UrlPathReferenceInjector.Companion.hasConsistentFullUrl((PsiReference[])fullReferences) || this.urlPathReferenceInjector.hasCompleteScheme((Object)jsExpressionForFullUrl)) {
            return fullReferences;
        }
        List schemes = ((UrlPathContext)this.urlPathReferenceInjector.getDefaultRootContextProvider().invoke((Object)jsExpressionForFullUrl)).getSchemes();
        UrlPathContext urlPathContext = (UrlPathContext)context2.get(BASE_CONTEXT_PROVIDER);
        if (urlPathContext == null) {
            Pair<List<String>, String> pair = JSUrlPathReferenceProviderKt.detectSchemeAndMethod(jsExpressionForFullUrl);
            urlPathContext = UrlPathContext.Companion.supportingSchemes(schemes, pair != null ? (String)pair.getSecond() : null);
        }
        UrlPathContext urlPathContextProvider = urlPathContext;
        Object[] contextReferences = this.urlPathReferenceInjector.buildReferences((Object)jsExpressionForFullUrl).withRootContextProvider(urlPathContextProvider).forPsiElement(element);
        return (PsiReference[])ArraysKt.plus((Object[])fullReferences, (Object[])contextReferences);
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target instanceof UrlSegmentReferenceTarget;
    }

    static {
        Key key2 = Key.create((String)"FULL_URL_EXPRESSION");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        FULL_URL_EXPRESSION = key2;
        Key key3 = Key.create((String)"BASE_CONTEXT_PROVIDER");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        BASE_CONTEXT_PROVIDER = key3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/microservices/JSUrlPathReferenceProvider$Companion;", "", "()V", "BASE_CONTEXT_PROVIDER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/microservices/url/references/UrlPathContext;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBASE_CONTEXT_PROVIDER", "()Lcom/intellij/openapi/util/Key;", "FULL_URL_EXPRESSION", "Lcom/intellij/lang/javascript/psi/JSExpression;", "getFULL_URL_EXPRESSION", "intellij.javascript.langInjection"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JSExpression> getFULL_URL_EXPRESSION() {
            return FULL_URL_EXPRESSION;
        }

        @NotNull
        public final Key<UrlPathContext> getBASE_CONTEXT_PROVIDER() {
            return BASE_CONTEXT_PROVIDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

