/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.javascript.microservices.JSUrlParameterIndexingHandlerKt;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/microservices/JSUrlParameterIndexingHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "()V", "getMarkers", "", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.langInjection"})
public final class JSUrlParameterIndexingHandler
extends FrameworkIndexingHandler {
    @Override
    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        if (elementToIndex instanceof JSDocComment) {
            String string = ((JSDocComment)elementToIndex).getExplicitName();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String functionName = string;
            List<Pair<JSQualifiedName, String>> list2 = ((JSDocComment)elementToIndex).getParametersWithOptions();
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            List<Pair<JSQualifiedName, String>> parameters = list2;
            int index = 0;
            for (Pair<JSQualifiedName, String> pair : parameters) {
                JSQualifiedName qName = (JSQualifiedName)pair.first;
                if (qName.getParent() != null) continue;
                if (Intrinsics.areEqual((Object)qName.getName(), (Object)"url")) {
                    return CollectionsKt.listOf((Object)JSUrlParameterIndexingHandlerKt.access$getKey(functionName, index));
                }
                ++index;
            }
        }
        if (!(elementToIndex instanceof JSParameter) || !Intrinsics.areEqual((Object)((JSParameter)elementToIndex).getName(), (Object)"url")) {
            return CollectionsKt.emptyList();
        }
        JSFunction jSFunction = ((JSParameter)elementToIndex).getDeclaringFunction();
        if (jSFunction == null) {
            return CollectionsKt.emptyList();
        }
        JSFunction function2 = jSFunction;
        String string = function2.getName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String functionName = string;
        JSParameterListElement[] jSParameterListElementArray = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSParameterListElementArray, (String)"getParameters(...)");
        int parameterIndex = ArraysKt.indexOf((Object[])jSParameterListElementArray, (Object)elementToIndex);
        if (parameterIndex < 0) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)JSUrlParameterIndexingHandlerKt.access$getKey(functionName, parameterIndex));
    }
}

