/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.playwright.js;

import com.intellij.aqua.runners.js.core.ExtendedJsTestRunConfigurationProducer;
import com.intellij.aqua.runners.js.core.JsTestRunSettings;
import com.intellij.aqua.runners.playwright.js.PlaywrightConfigurationFileUtilsKt;
import com.intellij.aqua.runners.playwright.js.PlaywrightConfigurationType;
import com.intellij.aqua.runners.playwright.js.PlaywrightConstantsKt;
import com.intellij.aqua.runners.playwright.js.PlaywrightRunConfiguration;
import com.intellij.aqua.runners.playwright.js.PlaywrightRunSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.util.PlaywrightDetectionUtils;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0015\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0014J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/aqua/runners/playwright/js/PlaywrightRunConfigurationProducer;", "Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer;", "Lcom/intellij/aqua/runners/playwright/js/PlaywrightRunSettings;", "Lcom/intellij/aqua/runners/playwright/js/PlaywrightRunConfiguration;", "()V", "nonE2EJasmineStructureConfigurationsIds", "", "", "playwrightDirNamesHeuristic", "buildContextSettings", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "element", "templateRunSettings", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromCompatibleContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isPlaywrightCompatibleContext", "isPlaywrightCompatibleContext$intellij_aqua_runners_playwright_js", "isPlaywrightImportDetectedFor", "isPlaywrightMostProbableFor", "isPreferredConfiguration", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "shouldReplace", "intellij.aqua.runners.playwright.js"})
@SourceDebugExtension(value={"SMAP\nPlaywrightRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaywrightRunConfigurationProducer.kt\ncom/intellij/aqua/runners/playwright/js/PlaywrightRunConfigurationProducer\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n26#2:141\n1747#3,3:142\n*S KotlinDebug\n*F\n+ 1 PlaywrightRunConfigurationProducer.kt\ncom/intellij/aqua/runners/playwright/js/PlaywrightRunConfigurationProducer\n*L\n46#1:141\n104#1:142,3\n*E\n"})
public final class PlaywrightRunConfigurationProducer
extends ExtendedJsTestRunConfigurationProducer<PlaywrightRunSettings, PlaywrightRunConfiguration> {
    @NotNull
    private final List<String> nonE2EJasmineStructureConfigurationsIds;
    @NotNull
    private final List<String> playwrightDirNamesHeuristic;

    public PlaywrightRunConfigurationProducer() {
        super(CollectionsKt.listOf((Object)"@playwright/test"), CollectionsKt.emptyList(), PlaywrightConstantsKt.getPLAYWRIGHT_CONFIG_FILE_NAMES());
        Object[] objectArray = new String[]{"JavaScriptTestRunnerVitest", "JavaScriptTestRunnerJest", "mocha-javascript-test-runner"};
        this.nonE2EJasmineStructureConfigurationsIds = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"e2e", "e2e_tests", "e2e-tests", "playwright", "Playwright", "playwright_tests", "playwright-tests"};
        this.playwrightDirNamesHeuristic = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        boolean $i$f$runConfigurationType = false;
        return (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(PlaywrightConfigurationType.class);
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull PlaywrightRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        if (!this.isTestRunnerAvailableFor(element, context2)) {
            return false;
        }
        if (!PlaywrightConfigurationFileUtilsKt.isUnderCorrectPlaywrightConfig(context2)) {
            return false;
        }
        Pair<PlaywrightRunSettings, PsiElement> pair = this.buildContextSettings(element, configuration.getSettings());
        if (pair == null) {
            return false;
        }
        Pair<PlaywrightRunSettings, PsiElement> pair2 = pair;
        PlaywrightRunSettings settings2 = (PlaywrightRunSettings)pair2.component1();
        PsiElement enclosingElement = (PsiElement)pair2.component2();
        configuration.setSettings(settings2);
        sourceElement.set((Object)enclosingElement);
        configuration.setGeneratedName();
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull PlaywrightRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context2).getConfiguration();
        PlaywrightRunConfiguration playwrightRunConfiguration = runConfiguration instanceof PlaywrightRunConfiguration ? (PlaywrightRunConfiguration)runConfiguration : null;
        if (playwrightRunConfiguration == null) {
            return false;
        }
        PlaywrightRunConfiguration templateConfiguration = playwrightRunConfiguration;
        Pair<PlaywrightRunSettings, PsiElement> pair = this.buildContextSettings(element, templateConfiguration.getSettings());
        if (pair == null) {
            return false;
        }
        PlaywrightRunSettings thisRunSettings = (PlaywrightRunSettings)pair.component1();
        PlaywrightRunSettings thatRunSettings = configuration.getSettings();
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)thisRunSettings.getWorkingDir()), (Object)FileUtil.toSystemIndependentName((String)thatRunSettings.getWorkingDir())) && Intrinsics.areEqual((Object)thisRunSettings.getScope(), (Object)thatRunSettings.getScope());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPreferredConfiguration(@Nullable ConfigurationFromContext self, @Nullable ConfigurationFromContext other) {
        if (self != null && other != null) {
            PsiElement psiElement = self.getSourceElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSourceElement(...)");
            if (!this.isPlaywrightMostProbableFor(psiElement) && this.nonE2EJasmineStructureConfigurationsIds.contains(other.getConfiguration().getType().getId())) {
                return false;
            }
        }
        boolean bl = super.isPreferredConfiguration(self, other);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = self.getConfiguration();
        if (!(runConfiguration instanceof PlaywrightRunConfiguration)) return false;
        PlaywrightRunConfiguration playwrightRunConfiguration = (PlaywrightRunConfiguration)runConfiguration;
        if (playwrightRunConfiguration == null) {
            return false;
        }
        PlaywrightRunConfiguration selfConfiguration = playwrightRunConfiguration;
        if (selfConfiguration.getSettings().getScope().getKind() == JsTestRunScopeKind.ALL) return false;
        PsiElement psiElement = self.getSourceElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSourceElement(...)");
        if (!this.isPlaywrightMostProbableFor(psiElement)) return false;
        return true;
    }

    private final boolean isPlaywrightMostProbableFor(PsiElement element) {
        boolean bl;
        block5: {
            if (this.isPlaywrightImportDetectedFor(element)) {
                return true;
            }
            PsiFile psiFile2 = element.getContainingFile();
            PsiElement psiElement = psiFile2 == null ? element : (PsiElement)psiFile2;
            Object object = psiElement instanceof PsiFileSystemItem ? (PsiFileSystemItem)psiElement : null;
            if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
                return false;
            }
            Object fileOrDirPath = object;
            Iterable $this$any$iv = this.playwrightDirNamesHeuristic;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String dirName = (String)element$iv;
                    boolean bl2 = false;
                    if (!JSLibraryUtil.containsDirInPath((String)fileOrDirPath, dirName)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isPlaywrightImportDetectedFor(PsiElement element) {
        JSFile jsFile;
        PsiFile psiFile2 = element.getContainingFile();
        JSFile jSFile = jsFile = psiFile2 instanceof JSFile ? (JSFile)psiFile2 : null;
        if (jsFile != null) {
            return PlaywrightDetectionUtils.hasPlaywrightPackageImport(jsFile);
        }
        PsiDirectory psiDirectory = element instanceof PsiDirectory ? (PsiDirectory)element : null;
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        return JsTestFileByTestNameIndex.hasPlaywrightTestsUnderDirectory(((PsiDirectory)element).getProject(), psiDirectory2.getVirtualFile());
    }

    public final boolean isPlaywrightCompatibleContext$intellij_aqua_runners_playwright_js(@NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        return this.buildContextSettings(element, new PlaywrightRunSettings.Builder().build()) != null;
    }

    private final Pair<PlaywrightRunSettings, PsiElement> buildContextSettings(PsiElement element, PlaywrightRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        ExtendedJsTestRunConfigurationProducer.Context<JsTestRunSettings> context2 = new ExtendedJsTestRunConfigurationProducer.Context<JsTestRunSettings>(element, element.getContainingFile(), virtualFile, templateRunSettings);
        Pair<JsTestRunSettings, PsiElement> pair = this.tryBuildDirectorySettings(context2);
        if (pair != null) {
            Pair<JsTestRunSettings, PsiElement> it = pair;
            boolean bl = false;
            return it;
        }
        Pair<JsTestRunSettings, PsiElement> pair2 = this.tryBuildSuiteOrTestSettings(context2);
        if (pair2 != null) {
            Pair<JsTestRunSettings, PsiElement> it = pair2;
            boolean bl = false;
            return it;
        }
        return this.tryBuildTestFileSettings(context2);
    }
}

