/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.client.launcher;

import com.google.protobuf.ByteString;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.client.launcher.DaemonHandshakeTransport;
import com.intellij.execution.process.mediator.client.launcher.DaemonHandshakeTransportKt;
import com.intellij.execution.process.mediator.client.launcher.DaemonProcessLauncherKt;
import com.intellij.execution.process.mediator.client.launcher.ProcessMediatorConnection;
import com.intellij.execution.process.mediator.client.launcher.ProcessMediatorConnectionKt;
import com.intellij.execution.process.mediator.common.DaemonClientCredentials;
import com.intellij.execution.process.mediator.common.DaemonLaunchOptions;
import com.intellij.execution.process.mediator.common.rpc.Handshake;
import com.intellij.execution.process.mediator.daemon.DaemonProcessRuntimeClasspath;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.processHandshake.ProcessHandshakeLauncher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0004J\b\u0010\r\u001a\u00020\u0003H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0003H\u0014J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/process/mediator/client/launcher/DaemonProcessLauncher;", "Lcom/intellij/util/io/processHandshake/ProcessHandshakeLauncher;", "Lcom/intellij/execution/process/mediator/common/rpc/Handshake;", "Lcom/intellij/execution/process/mediator/client/launcher/DaemonHandshakeTransport;", "Lcom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnection;", "clientBuilder", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;", "(Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;)V", "createBaseLaunchOptions", "Lcom/intellij/execution/process/mediator/common/DaemonLaunchOptions;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "transport", "createHandshakeTransport", "createProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "handshakeSucceeded", "handshake", "processHandler", "intellij.execution.process.mediator.client"})
@SourceDebugExtension(value={"SMAP\nDaemonProcessLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonProcessLauncher.kt\ncom/intellij/execution/process/mediator/client/launcher/DaemonProcessLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public class DaemonProcessLauncher
extends ProcessHandshakeLauncher<Handshake, DaemonHandshakeTransport, ProcessMediatorConnection> {
    @NotNull
    private final ProcessMediatorClient.Builder clientBuilder;

    public DaemonProcessLauncher(@NotNull ProcessMediatorClient.Builder clientBuilder) {
        Intrinsics.checkNotNullParameter((Object)clientBuilder, (String)"clientBuilder");
        this.clientBuilder = clientBuilder;
    }

    @NotNull
    protected ProcessMediatorConnection handshakeSucceeded(@NotNull Handshake handshake, @NotNull DaemonHandshakeTransport transport, @NotNull BaseOSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Optional<ProcessHandle> optional = ProcessHandle.of(handshake.getPid());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle = (ProcessHandle)UtilKt.orNull(optional);
        if (processHandle == null) {
            ProcessHandle processHandle2;
            ProcessHandle it = processHandle2 = processHandler.getProcess().toHandle();
            boolean bl = false;
            processHandle = !transport.getDaemonLaunchOptions().getTrampoline() ? processHandle2 : null;
        }
        ProcessHandle daemonProcessHandle = processHandle;
        ByteString byteString = handshake.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"getToken(...)");
        DaemonClientCredentials credentials = new DaemonClientCredentials(byteString);
        return ProcessMediatorConnectionKt.createDaemonConnection(ProcessMediatorConnection.Companion, daemonProcessHandle, handshake.getPort(), credentials, this.clientBuilder);
    }

    @NotNull
    protected DaemonHandshakeTransport createHandshakeTransport() {
        return DaemonHandshakeTransportKt.createProcessStdoutTransport(DaemonHandshakeTransport.Companion, this.createBaseLaunchOptions());
    }

    @NotNull
    protected DaemonLaunchOptions createBaseLaunchOptions() {
        Long l = ProcessHandle.current().pid();
        long l2 = ((Number)l).longValue();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = SystemInfo.isUnix;
        Long l3 = bl4 ? l : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 59;
        DaemonLaunchOptions.TokenEncryptionOption tokenEncryptionOption = null;
        DaemonLaunchOptions.HandshakeOption handshakeOption = null;
        Integer n2 = null;
        Long l4 = l3;
        boolean bl5 = bl;
        boolean bl6 = bl2;
        return new DaemonLaunchOptions(bl6, bl5, l4, n2, handshakeOption, tokenEncryptionOption, n, defaultConstructorMarker);
    }

    @NotNull
    protected final GeneralCommandLine createCommandLine(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        DaemonLaunchOptions daemonLaunchOptions = transport.getDaemonLaunchOptions();
        Map map2 = DaemonProcessRuntimeClasspath.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getProperties(...)");
        List list = DaemonProcessRuntimeClasspath.getClasspathClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClasspathClasses(...)");
        String[] stringArray = new String[]{DaemonProcessRuntimeClasspath.getMainClass().getName()};
        GeneralCommandLine generalCommandLine = DaemonProcessLauncherKt.access$createJavaVmCommandLine(map2, list).withParameters(stringArray).withParameters(daemonLaunchOptions.asCmdlineArgs());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        return generalCommandLine;
    }

    @NotNull
    protected BaseOSProcessHandler createProcessHandler(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        GeneralCommandLine commandLine = this.createCommandLine(transport);
        return this.createProcessHandler(transport, commandLine);
    }
}

