/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CoverageToolFinder;", "", "toolName", "", "preferVersion", "Lcom/intellij/openapi/util/Version;", "userPath", "toolSetDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "(Ljava/lang/String;Lcom/intellij/openapi/util/Version;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "isPrecalculated", "", "parameters", "", "toolPath", "doFindTool", "findTool", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getToolsToSearch", "", "intellij.clion.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageToolFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageToolFinder.kt\ncom/jetbrains/cidr/cpp/execution/coverage/CoverageToolFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class CoverageToolFinder {
    @NotNull
    private final String toolName;
    @Nullable
    private final Version preferVersion;
    @Nullable
    private final String userPath;
    @Nullable
    private final String toolSetDirectory;
    @NotNull
    private final CidrToolEnvironment environment;
    private boolean isPrecalculated;
    @Nullable
    private String toolPath;
    @NotNull
    private List<String> parameters;

    public CoverageToolFinder(@NotNull String toolName, @Nullable Version preferVersion, @Nullable String userPath, @Nullable String toolSetDirectory, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.toolName = toolName;
        this.preferVersion = preferVersion;
        this.userPath = userPath;
        this.toolSetDirectory = toolSetDirectory;
        this.environment = environment;
        this.parameters = new ArrayList();
    }

    @Nullable
    public final GeneralCommandLine getCommandLine() {
        if (!this.findTool()) {
            return null;
        }
        String[] stringArray = new String[]{this.toolPath};
        return new GeneralCommandLine(stringArray).withParameters(this.parameters);
    }

    private final boolean findTool() {
        CharSequence charSequence;
        if (!this.isPrecalculated) {
            this.isPrecalculated = true;
            this.toolPath = this.doFindTool();
            CidrCoverageLogKt.getCidrCoverageLog().info(this.toolName + " to use: " + this.toolPath);
        }
        if (!((charSequence = (CharSequence)this.toolPath) == null || charSequence.length() == 0)) {
            String string = this.toolPath;
            Intrinsics.checkNotNull((Object)string);
            if (Intrinsics.areEqual((Object)new File(string).getName(), (Object)"xcrun")) {
                this.parameters.add(this.toolName);
            }
            return true;
        }
        return false;
    }

    private final String doFindTool() {
        File xcrun;
        CharSequence charSequence = this.userPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return this.userPath;
        }
        List<String> toolsToSearch = this.getToolsToSearch();
        List toolSetFiles = new ArrayList();
        if (this.toolSetDirectory != null) {
            FileUtil.processFilesRecursively((File)new File(this.toolSetDirectory), arg_0 -> CoverageToolFinder.doFindTool$lambda$0((Function1)new Function1<File, Boolean>(this, (List<File>)toolSetFiles){
                final /* synthetic */ CoverageToolFinder this$0;
                final /* synthetic */ List<File> $toolSetFiles;
                {
                    this.this$0 = $receiver;
                    this.$toolSetFiles = $toolSetFiles;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(File file) {
                    if (file.isFile()) {
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.startsWith$default((String)string, (String)CoverageToolFinder.access$getToolName$p(this.this$0), (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNull((Object)file);
                            this.$toolSetFiles.add(file);
                        }
                    }
                    return true;
                }
            }, arg_0));
        }
        for (String toolToSearch : toolsToSearch) {
            Object v0;
            block9: {
                Iterable iterable = toolSetFiles;
                for (Object t : iterable) {
                    File it = (File)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)FilesKt.getNameWithoutExtension((File)it), (Object)toolToSearch)) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            File toolInToolSetDir = v0;
            if (toolInToolSetDir != null) {
                return toolInToolSetDir.getPath();
            }
            File toolInPath = PathEnvironmentVariableUtil.findInPath((String)toolToSearch);
            if (toolInPath == null) continue;
            return toolInPath.getPath();
        }
        if (SystemInfo.isMac && (xcrun = PathEnvironmentVariableUtil.findInPath((String)"xcrun")) != null) {
            return xcrun.getPath();
        }
        if (this.environment instanceof CPPEnvironment && (((CPPEnvironment)this.environment).getToolSet().isWSL() || ((CPPEnvironment)this.environment).getHostMachine().isRemote())) {
            String string;
            if (this.toolSetDirectory != null) {
                var3_3 = new String[]{this.toolSetDirectory, this.toolName};
                string = FileUtil.join((String[])var3_3);
            } else {
                var3_3 = new String[]{"/usr/bin", this.toolName};
                string = FileUtil.join((String[])var3_3);
            }
            return string;
        }
        return null;
    }

    private final List<String> getToolsToSearch() {
        List toolsToSearch = new ArrayList();
        if (this.preferVersion != null) {
            Object[] objectArray;
            if (SystemInfo.isMac) {
                objectArray = new String[]{this.toolName + "-mp-" + this.preferVersion.major + "." + this.preferVersion.minor + "." + this.preferVersion.bugfix, this.toolName + "-mp-" + this.preferVersion.major + "." + this.preferVersion.minor, this.toolName + "-mp-" + this.preferVersion.major, this.toolName + "-mp"};
                CollectionsKt.addAll((Collection)toolsToSearch, (Object[])objectArray);
            }
            objectArray = new String[]{this.toolName + "-" + this.preferVersion.major + "." + this.preferVersion.minor + "." + this.preferVersion.bugfix, this.toolName + "-" + this.preferVersion.major + "." + this.preferVersion.minor, this.toolName + "-" + this.preferVersion.major, this.toolName};
            CollectionsKt.addAll((Collection)toolsToSearch, (Object[])objectArray);
            return toolsToSearch;
        }
        return CollectionsKt.listOf((Object)this.toolName);
    }

    private static final boolean doFindTool$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getToolName$p(CoverageToolFinder $this) {
        return $this.toolName;
    }
}

