/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageRunner;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeLLVMCoverageDataFileProvider;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageDataFileProvider;", "()V", "deleteCoverageData", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getLocalCoverageDataPath", "", "getRunDirectory", "isAvailable", "", "coverageRunnerId", "isCoverageDataExist", "intellij.clion.coverage"})
public final class CMakeLLVMCoverageDataFileProvider
extends CidrCoverageDataFileProvider {
    public boolean isAvailable(@NotNull RunConfiguration configuration, @NotNull String coverageRunnerId) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)coverageRunnerId, (String)"coverageRunnerId");
        return configuration instanceof CMakeAppRunConfiguration && (Intrinsics.areEqual((Object)coverageRunnerId, (Object)"llvm-cov") || Intrinsics.areEqual((Object)coverageRunnerId, (Object)CMakeCoverageRunner.Companion.getID()));
    }

    @Nullable
    public String getLocalCoverageDataPath(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = this.getRunDirectory(configuration);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{it, "coverage-" + configuration.getName() + ".json"};
            return FileUtil.join((String[])stringArray);
        }
        return null;
    }

    public boolean isCoverageDataExist(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String string = this.getLocalCoverageDataPath(configuration);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return Files.exists(environment.getHostMachine().getPath(it, new String[0]), new LinkOption[0]);
        }
        return false;
    }

    public void deleteCoverageData(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            HostMachine host = environment.getHostMachine();
            String string = this.getRunDirectory(configuration);
            if (string != null) {
                String localDir = string;
                boolean bl = false;
                Path path = host.getPath(localDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                Path dirPath = path;
                Intrinsics.checkNotNull((Object)host);
                String[] stringArray = new String[]{".profdata", ".profraw"};
                CidrCoverageUtil.Companion.deleteFilesWithExtensionsInBatchMode(host, dirPath, false, stringArray);
            }
            String string2 = this.getLocalCoverageDataPath(configuration);
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            Files.deleteIfExists(host.getPath(it, new String[0]));
        }
    }

    private final String getRunDirectory(RunConfiguration configuration) {
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = CMakeAppRunConfiguration.getSelectedBuildAndRunConfigurations((Project)configuration.getProject());
        Object runConfiguration = buildAndRunConfigurations != null ? buildAndRunConfigurations.getRunConfiguration() : null;
        Object object = runConfiguration;
        return object != null && (object = object.getConfigurationGenerationDir()) != null ? ((File)object).getAbsolutePath() : null;
    }
}

