/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CLionCoverageSettings;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageToolVersionMatcher;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CoverageToolFinder;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageToolProvider;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeGCovCoverageToolProvider;", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageToolProvider;", "()V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "inputFile", "", "workingDirectory", "createToolFinder", "Lcom/jetbrains/cidr/cpp/execution/coverage/CoverageToolFinder;", "getToolName", "isAvailable", "", "intellij.clion.coverage"})
public final class CMakeGCovCoverageToolProvider
implements GCovCoverageToolProvider {
    public boolean isAvailable(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof CMakeAppRunConfiguration;
    }

    @NotNull
    public String getToolName(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        OCCompilerKind[] oCCompilerKindArray = new OCCompilerKind[]{GCCCompilerKind.INSTANCE};
        if (CidrExecutionUtil.compilerUsed((OCRunConfiguration)((OCRunConfiguration)((CMakeAppRunConfiguration)configuration)), (OCCompilerKind[])oCCompilerKindArray)) {
            return "gcov";
        }
        return "llvm-cov";
    }

    @Nullable
    public GeneralCommandLine createCommandLine(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return this.createToolFinder(configuration, environment).getCommandLine();
    }

    @Nullable
    public GeneralCommandLine createCommandLine(@NotNull String inputFile, @NotNull String workingDirectory, @NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        GeneralCommandLine generalCommandLine = this.createToolFinder(configuration, environment).getCommandLine();
        if (generalCommandLine == null) {
            return null;
        }
        GeneralCommandLine commandLine = generalCommandLine;
        commandLine.setWorkDirectory(workingDirectory);
        Object[] objectArray = new OCCompilerKind[]{ClangCompilerKind.INSTANCE, AppleClangCompilerKind.INSTANCE, ClangClCompilerKind.INSTANCE};
        if (CidrExecutionUtil.compilerUsed((OCRunConfiguration)((OCRunConfiguration)((CMakeAppRunConfiguration)configuration)), (OCCompilerKind[])objectArray)) {
            commandLine.addParameter("gcov");
        }
        objectArray = new String[]{inputFile, "--long-file-names"};
        commandLine.withParameters((String[])objectArray);
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            objectArray = new String[]{"-a", "-b", "-c"};
            commandLine.withParameters((String[])objectArray);
        }
        return commandLine;
    }

    private final CoverageToolFinder createToolFinder(RunConfiguration configuration, CidrToolEnvironment environment) {
        CLionCoverageSettings settings = CLionCoverageSettings.Companion.getInstance();
        Intrinsics.checkNotNull((Object)configuration, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration");
        OCCompilerKind[] oCCompilerKindArray = new OCCompilerKind[]{GCCCompilerKind.INSTANCE};
        String userPath = CidrExecutionUtil.compilerUsed((OCRunConfiguration)((OCRunConfiguration)((CMakeAppRunConfiguration)configuration)), (OCCompilerKind[])oCCompilerKindArray) ? settings.getGcovExecutablePath() : settings.getLlvmCovExecutablePath();
        String toolName = this.getToolName(configuration);
        Version compilerVersion = new CMakeCoverageToolVersionMatcher().getCompilerVersion(configuration, environment);
        Object object = CMakeCoverageUtil.Companion.getMostRelevantCompilerSettings(configuration);
        String compilerDirectory = object != null && (object = object.getCompilerExecutable()) != null ? ((File)object).getParent() : null;
        return new CoverageToolFinder(toolName, compilerVersion, userPath, compilerDirectory, environment);
    }
}

