/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.rdserver.handlers.typing;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupTypedHandler;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.rdserver.handlers.typing.RiderClientTypedHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/rdserver/handlers/typing/RiderClientLookupTypedHandler;", "Lcom/jetbrains/rider/rdserver/handlers/typing/RiderClientTypedHandler;", "()V", "beforeCharTyped", "", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "editor", "file", "Lcom/intellij/psi/PsiFile;", "execute", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rider.cwm.core"})
public final class RiderClientLookupTypedHandler
implements RiderClientTypedHandler {
    @Override
    public boolean execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled() || ClientId.Companion.isCurrentlyUnderLocalId()) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        CompletionPhase oldPhase = CompletionServiceImpl.Companion.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments && oldPhase.indicator != null) {
            oldPhase.indicator.scheduleRestart();
        }
        Editor editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant((char)charTyped, (Editor)editor, (PsiFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"injectedEditorIfCharTypedIsSignificant(...)");
        Editor injectedEditor = editor2;
        if (injectedEditor != editor) {
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(injectedEditor.getDocument());
            if (psiFile2 == null) {
                return false;
            }
            file = psiFile2;
        }
        if (editor.isInsertMode()) {
            return this.beforeCharTyped(charTyped, project2, editor, injectedEditor, file);
        }
        return false;
    }

    private final boolean beforeCharTyped(char charTyped, Project project, Editor originalEditor, Editor editor, PsiFile file) {
        LookupImpl lookupImpl = (LookupImpl)LookupManager.getActiveLookup((Editor)originalEditor);
        if (lookupImpl == null) {
            return false;
        }
        LookupImpl lookup = lookupImpl;
        if (charTyped == ' ' && ChooseItemAction.hasTemplatePrefix((LookupImpl)lookup, (char)' ')) {
            return false;
        }
        CharFilter.Result result = LookupTypedHandler.getLookupAction((char)charTyped, (LookupImpl)lookup);
        if (lookup.isLookupDisposed()) {
            return false;
        }
        if (result == CharFilter.Result.ADD_TO_PREFIX) {
            CompletionProgressIndicator completion;
            lookup.appendPrefix(charTyped);
            if (lookup.isStartCompletionWhenNothingMatches() && lookup.getItems().isEmpty()) {
                completion = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
                if (completion != null) {
                    completion.scheduleRestart();
                } else {
                    Project project2 = editor.getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    AutoPopupController.getInstance((Project)project2).scheduleAutoPopup(editor);
                }
            }
            CompletionProgressIndicator completionProgressIndicator = completion = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
            if (completionProgressIndicator != null) {
                completionProgressIndicator.prefixUpdated();
            }
            return true;
        }
        if (result == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && lookup.isFocused()) {
            return true;
        }
        lookup.hide();
        TypedHandler.autoPopupCompletion((Editor)editor, (char)charTyped, (Project)project, (PsiFile)file);
        return true;
    }
}

