/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSuite;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageModel;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "containsStatementsInRange", "currentSegment", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "lineIdx", "", "nextSegment", "document", "Lcom/intellij/openapi/editor/Document;", "doParseModel", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "inputPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getDataFileExtension", "", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "coverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "parseModel", "Companion", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nLLVMCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLVMCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,164:1\n13309#2,2:165\n12474#2,2:167\n*S KotlinDebug\n*F\n+ 1 LLVMCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner\n*L\n84#1:165,2\n100#1:167,2\n*E\n"})
public final class LLVMCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "llvm-cov";

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getPresentableName() {
        String string = CidrCoverageBundle.message("llvm.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CidrCoverageEngine;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(coverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = new CidrToolEnvironment();
        }
        CidrToolEnvironment environment = cidrToolEnvironment;
        Path path = environment.getHostMachine().getPath(sessionDataFile.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        CoverageSuite coverageSuite2 = coverageSuite;
        LLVMCoverageModel model = this.parseModel(path, (Project)(coverageSuite2 != null ? coverageSuite2.getProject() : null));
        if (model == null) {
            return null;
        }
        CidrProjectData projectData = new CidrProjectData();
        HashMap summaries = new HashMap();
        for (LLVMCoverageModel.CoverageMapping mapping : model.getMappings()) {
            for (LLVMCoverageModel.FileMapping fileMapping : mapping.getFileMappings()) {
                boolean bl;
                CidrBranchCoverageFileData branchCoverageData;
                block16: {
                    int n;
                    int lineIdx;
                    String canonicalFilePath = FileUtil.toCanonicalPath((String)environment.toLocalPath(fileMapping.getName()));
                    ClassData fileData = projectData.getOrCreateClassData(canonicalFilePath);
                    LLVMCoverageModel.Segment segment = (LLVMCoverageModel.Segment)CollectionsKt.lastOrNull(fileMapping.getSegments());
                    int maxLine = segment != null ? segment.getBeginLine() : -1;
                    LineData[] lines = new LineData[maxLine + 1];
                    LLVMCoverageModel.Segment currentSegment = null;
                    Ref.ObjectRef document = new Ref.ObjectRef();
                    ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(canonicalFilePath, (Ref.ObjectRef<Document>)document){
                        final /* synthetic */ String $canonicalFilePath;
                        final /* synthetic */ Ref.ObjectRef<Document> $document;
                        {
                            this.$canonicalFilePath = $canonicalFilePath;
                            this.$document = $document;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            Document document;
                            VirtualFile virtualFile = VfsUtil.findFile((Path)Path.of(this.$canonicalFilePath, new String[0]), (boolean)false);
                            Ref.ObjectRef<Document> objectRef = this.$document;
                            VirtualFile virtualFile2 = virtualFile;
                            if (virtualFile2 != null) {
                                void it;
                                VirtualFile virtualFile3 = virtualFile2;
                                Ref.ObjectRef<Document> objectRef2 = objectRef;
                                boolean bl = false;
                                document = FileDocumentManager.getInstance().getDocument((VirtualFile)it);
                                objectRef = objectRef2;
                            } else {
                                document = null;
                            }
                            objectRef.element = document;
                        }
                    }));
                    for (LLVMCoverageModel.Segment nextSegment : fileMapping.getSegments()) {
                        block17: {
                            if (currentSegment == null || (lineIdx = currentSegment.getBeginLine()) > (n = nextSegment.getBeginLine())) break block17;
                            while (true) {
                                block19: {
                                    LineData lineData;
                                    boolean exists;
                                    block18: {
                                        exists = lines[lineIdx] != null;
                                        LineData lineData2 = lines[lineIdx];
                                        if (lineData2 == null) {
                                            lineData2 = lineData = new LineData(lineIdx, null);
                                        }
                                        if (document.element == null) break block18;
                                        Object object = document.element;
                                        Intrinsics.checkNotNull((Object)object);
                                        if (!this.containsStatementsInRange(currentSegment, lineIdx, nextSegment, (Document)object)) break block19;
                                    }
                                    int hits = (int)Math.min(currentSegment.getCount(), Integer.MAX_VALUE);
                                    if (exists) {
                                        Object object = lineData.getSwitchData(0);
                                        if (object == null) {
                                            Object object2 = new int[]{currentSegment.getBeginColumn() - 1};
                                            Object it = object2 = (Object)lineData.addSwitch(0, object2);
                                            boolean bl2 = false;
                                            it.getHits()[0] = lineData.getHits();
                                            it.setDefaultHits(lineData.getHits());
                                            object = object2;
                                        }
                                        SwitchData switchData = object;
                                        int[] nArray = switchData.getKeys();
                                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getKeys(...)");
                                        int[] nArray2 = ArraysKt.plus((int[])nArray, (int)currentSegment.getBeginColumn());
                                        int[] nArray3 = switchData.getHits();
                                        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"getHits(...)");
                                        switchData.setKeysAndHits(nArray2, ArraysKt.plus((int[])nArray3, (int)hits));
                                    }
                                    lineData.setHits(Math.max(lineData.getHits(), hits));
                                    lines[lineIdx] = lineData;
                                }
                                if (lineIdx == n) break;
                                ++lineIdx;
                            }
                        }
                        currentSegment = nextSegment.getHasCount() ? nextSegment : null;
                    }
                    LineData[] $this$forEach$iv = lines;
                    boolean $i$f$forEach = false;
                    n = $this$forEach$iv.length;
                    for (lineIdx = 0; lineIdx < n; ++lineIdx) {
                        LineData element$iv;
                        LineData it = element$iv = $this$forEach$iv[lineIdx];
                        boolean bl3 = false;
                        LineData lineData = it;
                        if (lineData == null) continue;
                        lineData.fillArrays();
                    }
                    fileData.setLines(lines);
                    LLVMCoverageModel.Summary summary = fileMapping.getSummary();
                    if ((summary != null ? summary.getLines() : null) != null) {
                        BaseCoverageAnnotator.FileCoverageInfo it = $i$f$forEach = new BaseCoverageAnnotator.FileCoverageInfo();
                        boolean bl4 = false;
                        it.coveredLineCount = fileMapping.getSummary().getLines().getCovered();
                        it.totalLineCount = fileMapping.getSummary().getLines().getCount();
                        BaseCoverageAnnotator.FileCoverageInfo fileSummary = $i$f$forEach;
                        Map map = summaries;
                        Intrinsics.checkNotNull((Object)canonicalFilePath);
                        map.put(canonicalFilePath, fileSummary);
                    }
                    LLVMCoverageModel.Summary summary2 = fileMapping.getSummary();
                    if ((summary2 != null ? summary2.getBranches() : null) == null) continue;
                    Intrinsics.checkNotNull((Object)canonicalFilePath);
                    branchCoverageData = projectData.getOrCreateBranchCoverageData(canonicalFilePath);
                    branchCoverageData.setTotalBranches(fileMapping.getSummary().getBranches().getCount());
                    branchCoverageData.setCoveredBranches(fileMapping.getSummary().getBranches().getCovered());
                    if (branchCoverageData.getTotalBranches() != 0) continue;
                    LineData[] $this$any$iv = lines;
                    boolean $i$f$any = false;
                    int n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        LineData element$iv;
                        LineData it = element$iv = $this$any$iv[n];
                        boolean bl5 = false;
                        LineData lineData = it;
                        if (!((lineData != null ? Integer.valueOf(lineData.getHits()) : null) != null && it.getHits() > 0)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
                if (!bl) continue;
                branchCoverageData.setTotalBranches(1);
                branchCoverageData.setCoveredBranches(1);
            }
        }
        if (coverageSuite instanceof CidrCoverageSuite) {
            ((CidrCoverageSuite)coverageSuite).setSummaries(summaries);
        }
        return projectData;
    }

    private final boolean containsStatementsInRange(LLVMCoverageModel.Segment currentSegment, int lineIdx, LLVMCoverageModel.Segment nextSegment, Document document) {
        int endOffset;
        if (!DocumentUtil.isValidLine((int)(lineIdx - 1), (Document)document)) {
            return true;
        }
        if (!DocumentUtil.isValidLine((int)(currentSegment.getBeginLine() - 1), (Document)document) || !DocumentUtil.isValidLine((int)(nextSegment.getBeginLine() - 1), (Document)document)) {
            return true;
        }
        int currentSegmentStartOffset = document.getLineStartOffset(currentSegment.getBeginLine() - 1) + currentSegment.getBeginColumn() - 1;
        int lineBeginOffset = document.getLineStartOffset(lineIdx - 1);
        int lineEndOffset = document.getLineEndOffset(lineIdx - 1);
        int nextSegmentStartOffset = document.getLineStartOffset(nextSegment.getBeginLine() - 1) + nextSegment.getBeginColumn() - 1;
        if (currentSegmentStartOffset <= lineBeginOffset && lineEndOffset < nextSegmentStartOffset) {
            return true;
        }
        int startOffset = currentSegmentStartOffset > lineBeginOffset ? currentSegmentStartOffset : lineBeginOffset;
        int n = endOffset = nextSegmentStartOffset < lineEndOffset ? nextSegmentStartOffset : lineEndOffset;
        if (!DocumentUtil.isValidOffset((int)startOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document)) {
            return true;
        }
        int offset = startOffset;
        char charAt = '\u0000';
        while (offset >= 0 && offset < document.getCharsSequence().length() && offset < endOffset) {
            charAt = document.getCharsSequence().charAt(offset++);
            if (CharsKt.isWhitespace((char)charAt) || charAt == ';') continue;
            return true;
        }
        return false;
    }

    private final LLVMCoverageModel parseModel(Path inputPath, Project project) {
        try {
            return this.doParseModel(inputPath, project);
        }
        catch (LLVMCoverageModel.InvalidModelException e) {
            CidrCoverageLogKt.getCidrCoverageLog().warn((Throwable)e);
            return null;
        }
    }

    private final LLVMCoverageModel doParseModel(Path inputPath, Project project) {
        return (LLVMCoverageModel)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> LLVMCoverageRunner.doParseModel$lambda$4(inputPath), CidrCoverageBundle.message("coverage.reading.output.data", new Object[0]), true, project);
    }

    private static final LLVMCoverageModel doParseModel$lambda$4(Path $inputPath) {
        Intrinsics.checkNotNullParameter((Object)$inputPath, (String)"$inputPath");
        return LLVMCoverageModel.Companion.fromFile($inputPath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner$Companion;", "", "()V", "ID", "", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

