/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageComposer;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageComposer;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageToolProvider;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageComposer;", "()V", "afterProcessTerminated", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "event", "Lcom/intellij/execution/process/ProcessEvent;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "beforeProcessExecution", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getCoverageRootDirectory", "", "getOrCreateOutputCoverageDirectory", "Ljava/nio/file/Path;", "rootDirectory", "moveGcovFilesToOutputDirWithUniquePrefix", "targetDirectory", "processGcdaFile", "inputFile", "workingDirectory", "toolsProvider", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageToolProvider;", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nGCovCoverageComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCovCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,131:1\n1477#2:132\n1502#2,3:133\n1505#2,3:143\n1855#2,2:148\n372#3,7:136\n215#4,2:146\n*S KotlinDebug\n*F\n+ 1 GCovCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer\n*L\n53#1:132\n53#1:133,3\n53#1:143,3\n84#1:148,2\n53#1:136,7\n58#1:146,2\n*E\n"})
public final class GCovCoverageComposer
extends CidrCoverageComposer {
    public GCovCoverageComposer() {
        super("gcov");
    }

    @Override
    public void beforeProcessExecution(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterProcessTerminated(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull ProcessEvent event, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String rootDirectory = this.getCoverageRootDirectory(configuration);
        if (rootDirectory == null) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("gcov coverage root directory is null or not found");
            return;
        }
        Path path = environment.getHostMachine().getPath(rootDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path rootDirectoryPath = path;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        List<Path> gcdaFiles = GCovUtils.Companion.getGCDAFiles(hostMachine, rootDirectoryPath, true);
        GCovCoverageToolProvider gCovCoverageToolProvider = GCovCoverageToolProvider.Companion.getInstance(configuration);
        if (gCovCoverageToolProvider == null) {
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.missing", new Object[0]));
        }
        GCovCoverageToolProvider toolsProvider = gCovCoverageToolProvider;
        Iterable $this$groupBy$iv = gcdaFiles;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = new File(((Object)it).toString()).getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map gcdaFilesGroupedByFileName = destination$iv$iv;
        List gcdaFilesToParallelProcess = new ArrayList();
        List gcdaFilesToSequentialProcess = new ArrayList();
        Map $this$forEach$iv = gcdaFilesGroupedByFileName;
        boolean $i$f$forEach22 = false;
        Iterator $i$f$groupByTo22 = $this$forEach$iv.entrySet().iterator();
        while ($i$f$groupByTo22.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = $i$f$groupByTo22.next();
            boolean bl = false;
            if (((List)entry.getValue()).size() == 1) {
                gcdaFilesToParallelProcess.add(((List)entry.getValue()).get(0));
                continue;
            }
            gcdaFilesToSequentialProcess.addAll((Collection)entry.getValue());
        }
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for parallel processing: " + gcdaFilesToParallelProcess.size());
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for sequential processing: " + gcdaFilesToSequentialProcess.size());
        gcdaFilesToParallelProcess.parallelStream().forEach(arg_0 -> GCovCoverageComposer.afterProcessTerminated$lambda$2((Function1)new Function1<Path, Unit>(this, rootDirectory, indicator, configuration, environment, toolsProvider){
            final /* synthetic */ GCovCoverageComposer this$0;
            final /* synthetic */ String $rootDirectory;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ RunConfiguration $configuration;
            final /* synthetic */ CidrToolEnvironment $environment;
            final /* synthetic */ GCovCoverageToolProvider $toolsProvider;
            {
                this.this$0 = $receiver;
                this.$rootDirectory = $rootDirectory;
                this.$indicator = $indicator;
                this.$configuration = $configuration;
                this.$environment = $environment;
                this.$toolsProvider = $toolsProvider;
                super(1);
            }

            public final void invoke(Path it) {
                GCovCoverageComposer.access$processGcdaFile(this.this$0, ((Object)it).toString(), this.$rootDirectory, this.$indicator, this.$configuration, this.$environment, this.$toolsProvider);
            }
        }, arg_0));
        indicator.checkCanceled();
        Path outputDirectoryPath = this.getOrCreateOutputCoverageDirectory(rootDirectoryPath, environment);
        HostMachine hostMachine2 = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine2, (String)"getHostMachine(...)");
        String[] $i$f$forEach22 = new String[]{".gcov"};
        CidrCoverageUtil.Companion.moveFilesWithExtensionInBatchMode(hostMachine2, rootDirectoryPath, outputDirectoryPath, false, $i$f$forEach22);
        Iterable $this$forEach$iv2 = gcdaFilesToSequentialProcess;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Path it = (Path)element$iv;
            boolean bl = false;
            this.processGcdaFile(((Object)it).toString(), rootDirectory, indicator, configuration, environment, toolsProvider);
            this.moveGcovFilesToOutputDirWithUniquePrefix(rootDirectoryPath, outputDirectoryPath, environment);
        }
    }

    private final Path getOrCreateOutputCoverageDirectory(Path rootDirectory, CidrToolEnvironment environment) {
        String[] stringArray = new String[]{((Object)rootDirectory).toString(), "coverage"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String outputDirectory = string;
        Path path = environment.getHostMachine().getPath(outputDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path outputDirectoryPath = path;
        if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(outputDirectoryPath, new FileAttribute[0]);
        }
        return outputDirectoryPath;
    }

    private final void moveGcovFilesToOutputDirWithUniquePrefix(Path rootDirectory, Path targetDirectory, CidrToolEnvironment environment) {
        Files.list(rootDirectory).filter(arg_0 -> GCovCoverageComposer.moveGcovFilesToOutputDirWithUniquePrefix$lambda$4(moveGcovFilesToOutputDirWithUniquePrefix.1.INSTANCE, arg_0)).forEach(arg_0 -> GCovCoverageComposer.moveGcovFilesToOutputDirWithUniquePrefix$lambda$5((Function1)new Function1<Path, Unit>(environment, targetDirectory){
            final /* synthetic */ CidrToolEnvironment $environment;
            final /* synthetic */ Path $targetDirectory;
            {
                this.$environment = $environment;
                this.$targetDirectory = $targetDirectory;
                super(1);
            }

            public final void invoke(Path it) {
                String fileName = new File(((Object)it).toString()).getName();
                String newFileName = UUID.randomUUID().toString() + "#" + fileName;
                Object[] objectArray = new String[]{newFileName};
                Path path = this.$environment.getHostMachine().getPath(((Object)this.$targetDirectory).toString(), (String[])objectArray);
                objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(it, path, (CopyOption[])objectArray);
            }
        }, arg_0));
    }

    private final void processGcdaFile(String inputFile, String workingDirectory, ProgressIndicator indicator, RunConfiguration configuration, CidrToolEnvironment environment, GCovCoverageToolProvider toolsProvider) {
        String string = environment.toEnvPath(inputFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toEnvPath(...)");
        GeneralCommandLine gcov = toolsProvider.createCommandLine(string, workingDirectory, configuration, environment);
        if (gcov == null) {
            Object[] objectArray = new Object[]{toolsProvider.getToolName(configuration)};
            throw new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", objectArray));
        }
        ProcessOutput processOutput = null;
        try {
            processOutput = environment.getHostMachine().runProcess(gcov, indicator, -1);
        }
        catch (ExecutionException exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", objectArray));
        }
        String string2 = processOutput.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        if (((CharSequence)string2).length() > 0) {
            CidrCoverageLogKt.getCidrCoverageLog().warn(toolsProvider.getToolName(configuration) + " finished with stderr: " + processOutput.getStderr());
        }
        if (processOutput.getExitCode() != 0) {
            Object[] objectArray = new Object[]{processOutput.getStderr()};
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", objectArray));
        }
    }

    private final String getCoverageRootDirectory(RunConfiguration configuration) {
        CidrCoverageDataFileProvider cidrCoverageDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, this.getCoverageRunnerId());
        return cidrCoverageDataFileProvider != null ? cidrCoverageDataFileProvider.getLocalCoverageDataPath(configuration) : null;
    }

    private static final void afterProcessTerminated$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean moveGcovFilesToOutputDirWithUniquePrefix$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void moveGcovFilesToOutputDirWithUniquePrefix$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$processGcdaFile(GCovCoverageComposer $this, String inputFile, String workingDirectory, ProgressIndicator indicator, RunConfiguration configuration, CidrToolEnvironment environment, GCovCoverageToolProvider toolsProvider) {
        $this.processGcdaFile(inputFile, workingDirectory, indicator, configuration, environment, toolsProvider);
    }
}

