/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSuite;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014JB\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001cH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\bH\u0003J\u001a\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0010H\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0010H\u0007J\"\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0010H\u0007J\u0012\u0010,\u001a\u00020\n2\b\u0010-\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010.\u001a\u00020\u001aH\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator;", "Lcom/intellij/coverage/SimpleCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myFileBranchCoverageInfos", "", "", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$FileBranchCoverageInfo;", "annotate", "", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "dataManager", "Lcom/intellij/coverage/CoverageDataManager;", "data", "Lcom/intellij/rt/coverage/data/ProjectData;", "annotator", "Lcom/intellij/coverage/SimpleCoverageAnnotator$CoverageAnnotatorRunner;", "collectBranchCoverage", "directory", "index", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "trackTestFolders", "", "visitedDirs", "", "collectFileBranchCoverage", "file", "suiteBundle", "fileInfoForCoveredFile", "Lcom/intellij/coverage/BaseCoverageAnnotator$FileCoverageInfo;", "classData", "Lcom/intellij/rt/coverage/data/ClassData;", "getBranchCoverageInformationString", "info", "getDirBranchCoverageInformationString", "manager", "getFileBranchCoverageInformationString", "getSummaryCoverageInformationString", "Lcom/intellij/psi/PsiDirectory;", "currentSuite", "onSuiteChosen", "newSuite", "shouldCollectCoverageInsideLibraryDirs", "Companion", "FileBranchCoverageInfo", "intellij.cidr.coverage"})
public final class CidrCoverageAnnotator
extends SimpleCoverageAnnotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, FileBranchCoverageInfo> myFileBranchCoverageInfos;

    public CidrCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myFileBranchCoverageInfos = new HashMap();
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return false;
    }

    public void onSuiteChosen(@Nullable CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileBranchCoverageInfos.clear();
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(@NotNull ClassData classData) {
        Intrinsics.checkNotNullParameter((Object)classData, (String)"classData");
        for (CoverageSuitesBundle suitesBundle : CoverageDataManager.getInstance((Project)this.getProject()).activeSuites()) {
            BaseCoverageAnnotator.FileCoverageInfo fileSummary;
            CoverageSuite[] coverageSuiteArray = suitesBundle.getSuites();
            Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
            CoverageSuite suite = (CoverageSuite)ArraysKt.singleOrNull((Object[])coverageSuiteArray);
            if (!(suite instanceof CidrCoverageSuite) || (fileSummary = ((CidrCoverageSuite)suite).getSummaries().get(classData.getName())) == null) continue;
            return fileSummary;
        }
        return super.fileInfoForCoveredFile(classData);
    }

    @Nls
    @Nullable
    public final String getFileBranchCoverageInformationString(@NotNull VirtualFile file, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            return null;
        }
        String string = SimpleCoverageAnnotator.normalizeFilePath((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeFilePath(...)");
        String path = string;
        FileBranchCoverageInfo coverageInfo = this.myFileBranchCoverageInfos.get(path);
        if (coverageInfo == null || coverageInfo.getTotalBranchesCount() == 0) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.getCoveredBranchesCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return this.getBranchCoverageInformationString(coverageInfo);
    }

    @Nls
    @Nullable
    public final String getDirBranchCoverageInformationString(@NotNull VirtualFile directory, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            return null;
        }
        FileBranchCoverageInfo coverageInfo = this.myFileBranchCoverageInfos.get(SimpleCoverageAnnotator.normalizeFilePath((String)directory.getPath()));
        if (coverageInfo == null || coverageInfo.getTotalBranchesCount() == 0) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.getCoveredBranchesCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return this.getBranchCoverageInformationString(coverageInfo);
    }

    @Nls
    @Nullable
    public final String getSummaryCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)currentSuite, (String)"currentSuite");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String coverageInformation = super.getDirCoverageInformationString(directory, currentSuite, manager);
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String branchCoverageInformation = this.getDirBranchCoverageInformationString(virtualFile, manager);
        if (coverageInformation != null && branchCoverageInformation != null) {
            return coverageInformation + ", " + branchCoverageInformation;
        }
        return coverageInformation;
    }

    protected void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, @NotNull Project project, @Nullable SimpleCoverageAnnotator.CoverageAnnotatorRunner annotator) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.annotate(contentRoot, suite, dataManager, data, project, annotator);
        if (contentRoot.isValid() && CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex index = projectFileIndex;
            boolean trackTestFolders = suite.isTrackTestFolders();
            this.collectBranchCoverage(contentRoot, dataManager, index, trackTestFolders, suite, new HashSet());
            CidrCoverageLogKt.getCidrCoverageLog().debug("Branch coverage collected: " + this.myFileBranchCoverageInfos.size() + " elements");
        }
    }

    private final FileBranchCoverageInfo collectBranchCoverage(VirtualFile directory, CoverageDataManager dataManager, ProjectFileIndex index, boolean trackTestFolders, CoverageSuitesBundle suite, Set<? super VirtualFile> visitedDirs) {
        if (((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(index, directory){
            final /* synthetic */ ProjectFileIndex $index;
            final /* synthetic */ VirtualFile $directory;
            {
                this.$index = $index;
                this.$directory = $directory;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return !this.$index.isInContent(this.$directory) && !this.$index.isInLibrary(this.$directory);
            }
        }))).booleanValue()) {
            return null;
        }
        if (visitedDirs.contains(directory)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && ((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(index, directory){
            final /* synthetic */ ProjectFileIndex $index;
            final /* synthetic */ VirtualFile $directory;
            {
                this.$index = $index;
                this.$directory = $directory;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$index.isInLibrary(this.$directory);
            }
        }))).booleanValue()) {
            return null;
        }
        visitedDirs.add((VirtualFile)directory);
        boolean isInTestSrcContent2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(directory, this){
            final /* synthetic */ VirtualFile $directory;
            final /* synthetic */ CidrCoverageAnnotator this$0;
            {
                this.$directory = $directory;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return TestSourcesFilter.isTestSources((VirtualFile)this.$directory, (Project)this.this$0.getProject());
            }
        }));
        if (!trackTestFolders && isInTestSrcContent2) {
            return null;
        }
        FileBranchCoverageInfo branchCoverageInfo = new FileBranchCoverageInfo(0, 0);
        VirtualFile[] virtualFileArray = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> CidrCoverageAnnotator.collectBranchCoverage$lambda$0(directory));
        if (virtualFileArray == null) {
            return null;
        }
        for (VirtualFile fileOrDir : virtualFileArray) {
            FileBranchCoverageInfo fileBranchCoverageInfo;
            if (fileOrDir.isDirectory()) {
                FileBranchCoverageInfo childBranchCoverageInfo = this.collectBranchCoverage(fileOrDir, dataManager, index, trackTestFolders, suite, visitedDirs);
                if (childBranchCoverageInfo == null) continue;
                branchCoverageInfo.setTotalBranchesCount(branchCoverageInfo.getTotalBranchesCount() + childBranchCoverageInfo.getTotalBranchesCount());
                branchCoverageInfo.setCoveredBranchesCount(branchCoverageInfo.getCoveredBranchesCount() + childBranchCoverageInfo.getCoveredBranchesCount());
                continue;
            }
            if (!suite.getCoverageEngine().coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileBranchCoverageInfo = this.collectFileBranchCoverage(fileOrDir, dataManager, suite)) == null) continue;
            branchCoverageInfo.setTotalBranchesCount(branchCoverageInfo.getTotalBranchesCount() + fileBranchCoverageInfo.getTotalBranchesCount());
            branchCoverageInfo.setCoveredBranchesCount(branchCoverageInfo.getCoveredBranchesCount() + fileBranchCoverageInfo.getCoveredBranchesCount());
        }
        Map<String, FileBranchCoverageInfo> map = this.myFileBranchCoverageInfos;
        String string = SimpleCoverageAnnotator.normalizeFilePath((String)directory.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeFilePath(...)");
        map.put(string, branchCoverageInfo);
        return branchCoverageInfo;
    }

    private final FileBranchCoverageInfo collectFileBranchCoverage(VirtualFile file, CoverageDataManager dataManager, CoverageSuitesBundle suiteBundle) {
        CoverageSuite[] coverageSuiteArray = suiteBundle.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite suite : coverageSuiteArray) {
            CidrProjectData projectData;
            if ((CidrProjectData)suite.getCoverageData(dataManager) == null) continue;
            String string = FileUtil.toCanonicalPath((String)file.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
            CidrBranchCoverageFileData branchCoverageData = projectData.getBranchCoverageData(string);
            if (branchCoverageData == null) continue;
            FileBranchCoverageInfo branchCoverageInfo = new FileBranchCoverageInfo(branchCoverageData.getTotalBranches(), branchCoverageData.getCoveredBranches());
            Map<String, FileBranchCoverageInfo> map = this.myFileBranchCoverageInfos;
            String string2 = SimpleCoverageAnnotator.normalizeFilePath((String)file.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalizeFilePath(...)");
            map.put(string2, branchCoverageInfo);
            return branchCoverageInfo;
        }
        return null;
    }

    @Nls
    private final String getBranchCoverageInformationString(FileBranchCoverageInfo info) {
        Object[] objectArray = new Object[]{SimpleCoverageAnnotator.calcPercent((int)info.getCoveredBranchesCount(), (int)info.getTotalBranchesCount())};
        String string = CidrCoverageBundle.message("coverage.view.branches.covered", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final VirtualFile[] collectBranchCoverage$lambda$0(VirtualFile $directory) {
        Intrinsics.checkNotNullParameter((Object)$directory, (String)"$directory");
        return $directory.getChildren();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.coverage"})
    @SourceDebugExtension(value={"SMAP\nCidrCoverageAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrCoverageAnnotator.kt\ncom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,176:1\n31#2,2:177\n*S KotlinDebug\n*F\n+ 1 CidrCoverageAnnotator.kt\ncom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$Companion\n*L\n29#1:177,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CidrCoverageAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CidrCoverageAnnotator> serviceClass$iv = CidrCoverageAnnotator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CidrCoverageAnnotator)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$FileBranchCoverageInfo;", "", "totalBranchesCount", "", "coveredBranchesCount", "(II)V", "getCoveredBranchesCount", "()I", "setCoveredBranchesCount", "(I)V", "getTotalBranchesCount", "setTotalBranchesCount", "intellij.cidr.coverage"})
    public static final class FileBranchCoverageInfo {
        private int totalBranchesCount;
        private int coveredBranchesCount;

        public FileBranchCoverageInfo(int totalBranchesCount, int coveredBranchesCount) {
            this.totalBranchesCount = totalBranchesCount;
            this.coveredBranchesCount = coveredBranchesCount;
        }

        public final int getTotalBranchesCount() {
            return this.totalBranchesCount;
        }

        public final void setTotalBranchesCount(int n) {
            this.totalBranchesCount = n;
        }

        public final int getCoveredBranchesCount() {
            return this.coveredBranchesCount;
        }

        public final void setCoveredBranchesCount(int n) {
            this.coveredBranchesCount = n;
        }
    }
}

