/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.ui.executable;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="MesonExecutable", storages={@Storage(value="mesonExecutable.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutableCacheState;", "()V", "readWriteLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "state", "addExecutable", "", "executable", "Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutable;", "getExecutables", "", "", "toolchainName", "getState", "loadState", "toolchainsRenamed", "renamed", "", "Companion", "MesonExecutable", "MesonExecutableCacheState", "ToolchainRenamedListener", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonExecutableCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1#2:70\n1855#3,2:71\n*S KotlinDebug\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService\n*L\n40#1:71,2\n*E\n"})
public final class MesonExecutableCacheService
implements PersistentStateComponent<MesonExecutableCacheState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    @NotNull
    private MesonExecutableCacheState state = new MesonExecutableCacheState(null, 1, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MesonExecutableCacheState getState() {
        MesonExecutableCacheState mesonExecutableCacheState;
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            mesonExecutableCacheState = this.state;
        }
        finally {
            readLock.unlock();
        }
        return mesonExecutableCacheState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull MesonExecutableCacheState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ReentrantReadWriteLock reentrantReadWriteLock = this.readWriteLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.state = state;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExecutable(@NotNull MesonExecutable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        ReentrantReadWriteLock reentrantReadWriteLock = this.readWriteLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.state.addExecutable(executable);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getExecutables(@Nullable String toolchainName) {
        List<String> list;
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list = this.state.getExecutables(toolchainName);
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toolchainsRenamed(@NotNull Map<String, String> renamed) {
        Intrinsics.checkNotNullParameter(renamed, (String)"renamed");
        ReentrantReadWriteLock reentrantReadWriteLock = this.readWriteLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = this.state.getExecutables();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MesonExecutable executable = (MesonExecutable)element$iv;
                boolean bl2 = false;
                String string = renamed.get(executable.getToolchainName());
                if (string == null) {
                    string = executable.getToolchainName();
                }
                executable.setToolchainName(string);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService;", "intellij.clion.meson"})
    @SourceDebugExtension(value={"SMAP\nMesonExecutableCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n31#2,2:70\n*S KotlinDebug\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$Companion\n*L\n18#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MesonExecutableCacheService getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<MesonExecutableCacheService> serviceClass$iv = MesonExecutableCacheService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (MesonExecutableCacheService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutable;", "", "executable", "", "toolchainName", "(Ljava/lang/String;Ljava/lang/String;)V", "getExecutable", "()Ljava/lang/String;", "setExecutable", "(Ljava/lang/String;)V", "getToolchainName", "setToolchainName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.meson"})
    public static final class MesonExecutable {
        @NotNull
        private String executable;
        @Nullable
        private String toolchainName;

        public MesonExecutable(@NotNull String executable, @Nullable String toolchainName) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            this.executable = executable;
            this.toolchainName = toolchainName;
        }

        public /* synthetic */ MesonExecutable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public final String getExecutable() {
            return this.executable;
        }

        public final void setExecutable(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.executable = string;
        }

        @Nullable
        public final String getToolchainName() {
            return this.toolchainName;
        }

        public final void setToolchainName(@Nullable String string) {
            this.toolchainName = string;
        }

        @NotNull
        public final String component1() {
            return this.executable;
        }

        @Nullable
        public final String component2() {
            return this.toolchainName;
        }

        @NotNull
        public final MesonExecutable copy(@NotNull String executable, @Nullable String toolchainName) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            return new MesonExecutable(executable, toolchainName);
        }

        public static /* synthetic */ MesonExecutable copy$default(MesonExecutable mesonExecutable, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mesonExecutable.executable;
            }
            if ((n & 2) != 0) {
                string2 = mesonExecutable.toolchainName;
            }
            return mesonExecutable.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MesonExecutable(executable=" + this.executable + ", toolchainName=" + this.toolchainName + ")";
        }

        public int hashCode() {
            int result2 = this.executable.hashCode();
            result2 = result2 * 31 + (this.toolchainName == null ? 0 : this.toolchainName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MesonExecutable)) {
                return false;
            }
            MesonExecutable mesonExecutable = (MesonExecutable)other;
            if (!Intrinsics.areEqual((Object)this.executable, (Object)mesonExecutable.executable)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toolchainName, (Object)mesonExecutable.toolchainName);
        }

        public MesonExecutable() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0010H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutableCacheState;", "", "executables", "", "Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutable;", "(Ljava/util/List;)V", "getExecutables", "()Ljava/util/List;", "addExecutable", "", "executable", "component1", "copy", "equals", "other", "", "", "toolchainName", "hashCode", "", "toString", "intellij.clion.meson"})
    @SourceDebugExtension(value={"SMAP\nMesonExecutableCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutableCacheState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n766#2:70\n857#2,2:71\n1549#2:73\n1620#2,3:74\n*S KotlinDebug\n*F\n+ 1 MesonExecutableCacheService.kt\ncom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$MesonExecutableCacheState\n*L\n61#1:70\n61#1:71,2\n61#1:73\n61#1:74,3\n*E\n"})
    public static final class MesonExecutableCacheState {
        @XCollection(elementTypes={MesonExecutable.class})
        @NotNull
        private final List<MesonExecutable> executables;

        public MesonExecutableCacheState(@NotNull List<MesonExecutable> executables) {
            Intrinsics.checkNotNullParameter(executables, (String)"executables");
            this.executables = executables;
        }

        public /* synthetic */ MesonExecutableCacheState(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<MesonExecutable> getExecutables() {
            return this.executables;
        }

        public final boolean addExecutable(@NotNull MesonExecutable executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.executables.contains(executable)) {
                return false;
            }
            return this.executables.add(executable);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getExecutables(@Nullable String toolchainName) {
            void $this$mapTo$iv$iv;
            MesonExecutable it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.executables;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MesonExecutable)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getToolchainName(), (Object)toolchainName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MesonExecutable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getExecutable());
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<MesonExecutable> component1() {
            return this.executables;
        }

        @NotNull
        public final MesonExecutableCacheState copy(@NotNull List<MesonExecutable> executables) {
            Intrinsics.checkNotNullParameter(executables, (String)"executables");
            return new MesonExecutableCacheState(executables);
        }

        public static /* synthetic */ MesonExecutableCacheState copy$default(MesonExecutableCacheState mesonExecutableCacheState, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = mesonExecutableCacheState.executables;
            }
            return mesonExecutableCacheState.copy(list);
        }

        @NotNull
        public String toString() {
            return "MesonExecutableCacheState(executables=" + this.executables + ")";
        }

        public int hashCode() {
            return ((Object)this.executables).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MesonExecutableCacheState)) {
                return false;
            }
            MesonExecutableCacheState mesonExecutableCacheState = (MesonExecutableCacheState)other;
            return Intrinsics.areEqual(this.executables, mesonExecutableCacheState.executables);
        }

        public MesonExecutableCacheState() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/meson/ui/executable/MesonExecutableCacheService$ToolchainRenamedListener;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchainsListener;", "()V", "toolchainsRenamed", "", "renamed", "", "", "intellij.clion.meson"})
    public static final class ToolchainRenamedListener
    implements CPPToolchainsListener {
        public void toolchainsRenamed(@NotNull Map<String, String> renamed) {
            Intrinsics.checkNotNullParameter(renamed, (String)"renamed");
            Companion.getInstance().toolchainsRenamed(renamed);
        }
    }
}

