/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.model.impl.ExternalFileConfigurationBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalModuleBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalResolveConfigurationBuilder;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.project.MesonExternalProjectData;
import com.jetbrains.cidr.meson.project.resolver.MesonEventDataKt;
import com.jetbrains.cidr.meson.project.resolver.MesonIntrospectionConverter;
import com.jetbrains.cidr.meson.project.resolver.MesonIntrospectionConverterKt;
import com.jetbrains.cidr.meson.project.resolver.MesonResolverContext;
import com.jetbrains.cidr.meson.project.resolver.model.MesonCompilerId;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroCompilers;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroLanguage;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroTargets;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntrospection;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u000223B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170 H\u0002J<\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\b\u0010%\u001a\u0004\u0018\u00010&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\nH\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\nH\u0002J$\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\nH\u0002J*\u0010/\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter;", "", "resolverContext", "Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "buildDirectory", "Ljava/nio/file/Path;", "(Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Ljava/nio/file/Path;)V", "compilers", "", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$CompilerInfo;", "convert", "Lcom/jetbrains/cidr/external/system/model/impl/ExternalResolveConfigurationBuilder;", "target", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets$Target;", "Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$Model;", "introspection", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospection;", "convertBuildTarget", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData$Target;", "convertBuildTargets", "", "convertModule", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "createConfigurationId", "", "debug", "", "message", "lazyDebugValues", "Lkotlin/Function0;", "readCompiler", "mesonLanguage", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroLanguage;", "mesonCompilerCommand", "mesonCompilerId", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonCompilerId;", "executablesCache", "readCompilersInfo", "readIntroCompilers", "introCompilers", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;", "readTargetsCompilers", "introTargets", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;", "resolveCompilerExecutable", "compilerCommand", "cache", "CompilerInfo", "Model", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonIntrospectionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonIntrospectionConverter.kt\ncom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1549#2:354\n1620#2,3:355\n1360#2:358\n1446#2,5:359\n1855#2,2:365\n1#3:364\n*S KotlinDebug\n*F\n+ 1 MesonIntrospectionConverter.kt\ncom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter\n*L\n88#1:354\n88#1:355,3\n129#1:358\n129#1:359,5\n297#1:365,2\n*E\n"})
public final class MesonIntrospectionConverter {
    @NotNull
    private final MesonResolverContext resolverContext;
    @NotNull
    private final CPPEnvironment environment;
    @NotNull
    private final Path buildDirectory;
    @NotNull
    private final Map<OCLanguageKind, CompilerInfo> compilers;

    public MesonIntrospectionConverter(@NotNull MesonResolverContext resolverContext, @NotNull CPPEnvironment environment, @NotNull Path buildDirectory) {
        Intrinsics.checkNotNullParameter((Object)resolverContext, (String)"resolverContext");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        this.resolverContext = resolverContext;
        this.environment = environment;
        this.buildDirectory = buildDirectory;
        this.compilers = new LinkedHashMap();
    }

    @NotNull
    public final Model convert(@NotNull MesonIntrospection introspection) {
        Intrinsics.checkNotNullParameter((Object)introspection, (String)"introspection");
        MesonIntrospectionConverter.debug$default(this, "Parsing meson introspection", null, 2, null);
        ExternalModule module = this.convertModule(introspection);
        List<MesonExternalProjectData.Target> targets = this.convertBuildTargets(introspection);
        return new Model(module, targets);
    }

    private final ExternalModule convertModule(MesonIntrospection introspection) {
        MesonIntrospectionConverter.debug$default(this, "Parsing ExternalModule", null, 2, null);
        ExternalModuleBuilder module = new ExternalModuleBuilder();
        if (introspection.getTargets().getTargets().isEmpty()) {
            MesonEventDataKt.warn(this.resolverContext, MesonBundle.message("converter.no.targets", new Object[0]));
            return module.invoke();
        }
        this.readCompilersInfo(introspection);
        for (MesonIntroTargets.Target target : introspection.getTargets().getTargets()) {
            ExternalResolveConfigurationBuilder resolveConfiguration = this.convert(target);
            module.withResolveConfiguration(resolveConfiguration.invoke());
        }
        return module.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final List<MesonExternalProjectData.Target> convertBuildTargets(MesonIntrospection introspection) {
        void $this$mapTo$iv$iv;
        MesonIntrospectionConverter.debug$default(this, "Parsing MesonExternalProjectData.Target", null, 2, null);
        Iterable $this$map$iv = introspection.getTargets().getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MesonIntroTargets.Target target = (MesonIntroTargets.Target)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertBuildTarget((MesonIntroTargets.Target)it));
        }
        return (List)destination$iv$iv;
    }

    private final void readCompilersInfo(MesonIntrospection introspection) {
        HashMap executablesCache = new HashMap();
        MesonIntroCompilers introCompilers = introspection.getCompilers();
        if (introCompilers != null) {
            this.readIntroCompilers(introCompilers, executablesCache);
        }
        this.readTargetsCompilers(introspection.getTargets(), executablesCache);
        if (MesonIntrospectionConverterKt.access$getLOG$p().isDebugEnabled()) {
            for (Map.Entry<OCLanguageKind, CompilerInfo> entry : this.compilers.entrySet()) {
                OCLanguageKind language = entry.getKey();
                CompilerInfo compilerInfo = entry.getValue();
                this.debug("Parsed compiler", (Function0)new Function0<List<?>>(language, compilerInfo){
                    final /* synthetic */ OCLanguageKind $language;
                    final /* synthetic */ CompilerInfo $compilerInfo;
                    {
                        this.$language = $language;
                        this.$compilerInfo = $compilerInfo;
                        super(0);
                    }

                    @NotNull
                    public final List<?> invoke() {
                        Object[] objectArray = new Object[]{this.$language, this.$compilerInfo};
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                });
            }
        }
    }

    private final void readIntroCompilers(MesonIntroCompilers introCompilers, Map<String, String> executablesCache) {
        for (Map.Entry<MesonIntroLanguage, MesonIntroCompilers.Compiler> entry : introCompilers.getCompilers().entrySet()) {
            MesonIntroLanguage mesonLanguage = entry.getKey();
            MesonIntroCompilers.Compiler mesonCompiler = entry.getValue();
            this.readCompiler(mesonLanguage, mesonCompiler.getCompilerCommand(), mesonCompiler.getId(), executablesCache);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readTargetsCompilers(MesonIntroTargets introTargets, Map<String, String> executablesCache) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = introTargets.getTargets();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MesonIntroTargets.Target it = (MesonIntroTargets.Target)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSources();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (MesonIntroTargets.Target.Sources mesonSources : (List)destination$iv$iv) {
            this.readCompiler(mesonSources.getLanguage(), mesonSources.getCompilerCommand(), null, executablesCache);
        }
    }

    private final void readCompiler(MesonIntroLanguage mesonLanguage, List<String> mesonCompilerCommand, MesonCompilerId mesonCompilerId, Map<String, String> executablesCache) {
        this.debug("Parsing compiler info", (Function0)new Function0<List<?>>(mesonLanguage, mesonCompilerCommand, mesonCompilerId){
            final /* synthetic */ MesonIntroLanguage $mesonLanguage;
            final /* synthetic */ List<String> $mesonCompilerCommand;
            final /* synthetic */ MesonCompilerId $mesonCompilerId;
            {
                this.$mesonLanguage = $mesonLanguage;
                this.$mesonCompilerCommand = $mesonCompilerCommand;
                this.$mesonCompilerId = $mesonCompilerId;
                super(0);
            }

            @NotNull
            public final List<?> invoke() {
                Object[] objectArray = new Object[]{this.$mesonLanguage, this.$mesonCompilerCommand, this.$mesonCompilerId};
                return CollectionsKt.listOf((Object[])objectArray);
            }
        });
        if (mesonLanguage instanceof MesonIntroLanguage.Unknown) {
            return;
        }
        OCLanguageKind languageKind = MesonIntrospectionConverterKt.access$getOcLanguageKind(mesonLanguage);
        if (languageKind == null) {
            MesonIntrospectionConverterKt.access$getLOG$p().warn("Unsupported language is used in project: " + mesonLanguage);
            return;
        }
        this.compilers.computeIfAbsent(languageKind, arg_0 -> MesonIntrospectionConverter.readCompiler$lambda$2((Function1)new Function1<OCLanguageKind, CompilerInfo>(mesonCompilerCommand, this, executablesCache, mesonCompilerId){
            final /* synthetic */ List<String> $mesonCompilerCommand;
            final /* synthetic */ MesonIntrospectionConverter this$0;
            final /* synthetic */ Map<String, String> $executablesCache;
            final /* synthetic */ MesonCompilerId $mesonCompilerId;
            {
                this.$mesonCompilerCommand = $mesonCompilerCommand;
                this.this$0 = $receiver;
                this.$executablesCache = $executablesCache;
                this.$mesonCompilerId = $mesonCompilerId;
                super(1);
            }

            @NotNull
            public final CompilerInfo invoke(@NotNull OCLanguageKind it) {
                MesonCompilerId compilerKind;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$mesonCompilerCommand.isEmpty()) {
                    MesonIntrospectionConverterKt.access$fail(MesonIntrospectionConverter.access$getResolverContext$p(this.this$0), MesonBundle.message("model.compiler.exe.empty.error", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                String compilerExecutable = MesonIntrospectionConverter.access$resolveCompilerExecutable(this.this$0, this.$mesonCompilerCommand, this.$executablesCache);
                MesonCompilerId mesonCompilerId = this.$mesonCompilerId;
                if (mesonCompilerId == null || (mesonCompilerId = MesonIntrospectionConverterKt.access$getOcCompilerKind(mesonCompilerId)) == null) {
                    mesonCompilerId = (OCCompilerKind)UnknownCompilerKind.INSTANCE;
                }
                if ((compilerKind = mesonCompilerId) instanceof UnknownCompilerKind) {
                    Project project = MesonIntrospectionConverter.access$getResolverContext$p(this.this$0).getProject();
                    Path path = Path.of(compilerExecutable, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    compilerKind = OCCompilerResolver.Companion.resolve(project, path, (CidrToolEnvironment)MesonIntrospectionConverter.access$getEnvironment$p(this.this$0));
                    if (compilerKind instanceof UnknownCompilerKind) {
                        Object[] objectArray = new Object[]{CollectionsKt.last(this.$mesonCompilerCommand)};
                        MesonEventDataKt.warn(MesonIntrospectionConverter.access$getResolverContext$p(this.this$0), MesonBundle.message("converter.unknown.compiler.executable", objectArray));
                    }
                }
                return new CompilerInfo((OCCompilerKind)compilerKind, compilerExecutable);
            }
        }, arg_0));
    }

    private final String resolveCompilerExecutable(List<String> compilerCommand, Map<String, String> cache) {
        if (!(!((Collection)compilerCommand).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String compilerExecutable = (String)CollectionsKt.last(compilerCommand);
        String string = cache.computeIfAbsent(compilerExecutable, arg_0 -> MesonIntrospectionConverter.resolveCompilerExecutable$lambda$3((Function1)new Function1<String, String>(this, compilerExecutable){
            final /* synthetic */ MesonIntrospectionConverter this$0;
            final /* synthetic */ String $compilerExecutable;
            {
                this.this$0 = $receiver;
                this.$compilerExecutable = $compilerExecutable;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    CPPEnvironment.ExecutablePathResult executablePathResult = MesonIntrospectionConverter.access$getEnvironment$p(this.this$0).resolveEnvPathToLocalExecutable(MesonIntrospectionConverter.access$getBuildDirectory$p(this.this$0), this.$compilerExecutable);
                    Intrinsics.checkNotNullExpressionValue((Object)executablePathResult, (String)"resolveEnvPathToLocalExecutable(...)");
                    CPPEnvironment.ExecutablePathResult resolveResult = executablePathResult;
                    String string2 = resolveResult.path;
                    if (string2 == null) {
                        string2 = this.$compilerExecutable;
                    }
                    string = string2;
                }
                catch (Exception e) {
                    string = this.$compilerExecutable;
                }
                return string;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return string;
    }

    private final ExternalResolveConfigurationBuilder convert(MesonIntroTargets.Target target) {
        MesonIntrospectionConverter.debug$default(this, "Parsing target info: name=" + target.getName(), null, 2, null);
        String string = this.createConfigurationId(target);
        String string2 = target.getName();
        File file = this.buildDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ExternalResolveConfigurationBuilder configuration = new ExternalResolveConfigurationBuilder(string, string2, file).withToolchainName(this.environment.getToolchain().getName());
        Set languages = new LinkedHashSet();
        for (MesonIntroTargets.Target.Sources mesonSources : target.getSources()) {
            CompilerInfo compilerInfo;
            OCLanguageKind languageKind;
            if (MesonIntrospectionConverterKt.access$getOcLanguageKind(mesonSources.getLanguage()) == null || this.compilers.get(languageKind) == null) continue;
            if (languages.contains(languageKind)) {
                MesonIntrospectionConverterKt.access$getLOG$p().error("Multiple source groups for a single language " + languageKind + " in target " + target.getName());
                continue;
            }
            languages.add(languageKind);
            ExternalLanguageConfigurationBuilder languageConfiguration = new ExternalLanguageConfigurationBuilder(languageKind).withCompilerKind(compilerInfo.getKind()).withCompilerExecutable(new File(compilerInfo.getPath())).withCompilerSwitches(mesonSources.getParameters());
            configuration.withLanguageConfiguration(languageConfiguration.invoke());
            this.debug("Parsed language configuration for target " + target.getName(), (Function0)new Function0<List<?>>(languageConfiguration){
                final /* synthetic */ ExternalLanguageConfigurationBuilder $languageConfiguration;
                {
                    this.$languageConfiguration = $languageConfiguration;
                    super(0);
                }

                @NotNull
                public final List<?> invoke() {
                    return CollectionsKt.listOf((Object)this.$languageConfiguration.invoke());
                }
            });
            for (String sourceFile : CollectionsKt.plus((Collection)mesonSources.getSourceFiles(), (Iterable)mesonSources.getGeneratedSourceFiles())) {
                File localFile = new File(this.environment.toLocalPath(this.buildDirectory.toFile(), sourceFile));
                ExternalFileConfigurationBuilder fileConfiguration = new ExternalFileConfigurationBuilder(localFile, languageKind);
                configuration.withFileConfiguration(fileConfiguration.invoke());
                this.debug("Parsed file configuration for target " + target.getName(), (Function0)new Function0<List<?>>(fileConfiguration){
                    final /* synthetic */ ExternalFileConfigurationBuilder $fileConfiguration;
                    {
                        this.$fileConfiguration = $fileConfiguration;
                        super(0);
                    }

                    @NotNull
                    public final List<?> invoke() {
                        return CollectionsKt.listOf((Object)this.$fileConfiguration.invoke());
                    }
                });
            }
        }
        return configuration;
    }

    private final MesonExternalProjectData.Target convertBuildTarget(MesonIntroTargets.Target target) {
        String string;
        MesonExternalProjectData.Target.Type targetType = MesonIntrospectionConverterKt.access$getTargetType(target.getType());
        if (targetType == MesonExternalProjectData.Target.Type.Executable) {
            String string2 = (String)CollectionsKt.firstOrNull(target.getOutputFiles());
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = this.environment.toLocalPath(it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String outputFile = string;
        String resolveConfigurationId = this.createConfigurationId(target);
        return new MesonExternalProjectData.Target(target.getName(), targetType, outputFile, resolveConfigurationId);
    }

    private final String createConfigurationId(MesonIntroTargets.Target target) {
        return ApplicationManager.getApplication().isUnitTestMode() ? target.getName() + "@" + target.getType().getType() : target.getId();
    }

    private final void debug(String message, Function0<? extends List<?>> lazyDebugValues) {
        if (!MesonIntrospectionConverterKt.access$getLOG$p().isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Profile '" + this.resolverContext.getProjectSettings().profile().getName() + "': ");
        sb.append(message);
        List debugValues = (List)lazyDebugValues.invoke();
        if (!((Collection)debugValues).isEmpty()) {
            sb.append(" (" + debugValues.size() + "):");
            Iterable $this$forEach$iv = debugValues;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                sb.append("\n  " + it);
            }
        }
        MesonIntrospectionConverterKt.access$getLOG$p().debug(sb.toString());
    }

    static /* synthetic */ void debug$default(MesonIntrospectionConverter mesonIntrospectionConverter, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = debug.1.INSTANCE;
        }
        mesonIntrospectionConverter.debug(string, function0);
    }

    private static final CompilerInfo readCompiler$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompilerInfo)$tmp0.invoke(p0);
    }

    private static final String resolveCompilerExecutable$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MesonResolverContext access$getResolverContext$p(MesonIntrospectionConverter $this) {
        return $this.resolverContext;
    }

    public static final /* synthetic */ String access$resolveCompilerExecutable(MesonIntrospectionConverter $this, List compilerCommand, Map cache) {
        return $this.resolveCompilerExecutable(compilerCommand, cache);
    }

    public static final /* synthetic */ CPPEnvironment access$getEnvironment$p(MesonIntrospectionConverter $this) {
        return $this.environment;
    }

    public static final /* synthetic */ Path access$getBuildDirectory$p(MesonIntrospectionConverter $this) {
        return $this.buildDirectory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$CompilerInfo;", "", "kind", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "path", "", "(Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;Ljava/lang/String;)V", "getKind", "()Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.meson"})
    private static final class CompilerInfo {
        @NotNull
        private final OCCompilerKind kind;
        @NotNull
        private final String path;

        public CompilerInfo(@NotNull OCCompilerKind kind, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.kind = kind;
            this.path = path;
        }

        @NotNull
        public final OCCompilerKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final OCCompilerKind component1() {
            return this.kind;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final CompilerInfo copy(@NotNull OCCompilerKind kind, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new CompilerInfo(kind, path);
        }

        public static /* synthetic */ CompilerInfo copy$default(CompilerInfo compilerInfo, OCCompilerKind oCCompilerKind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                oCCompilerKind = compilerInfo.kind;
            }
            if ((n & 2) != 0) {
                string = compilerInfo.path;
            }
            return compilerInfo.copy(oCCompilerKind, string);
        }

        @NotNull
        public String toString() {
            return "CompilerInfo(kind=" + this.kind + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilerInfo)) {
                return false;
            }
            CompilerInfo compilerInfo = (CompilerInfo)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)compilerInfo.kind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)compilerInfo.path);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$Model;", "", "module", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "targets", "", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData$Target;", "(Lcom/jetbrains/cidr/external/system/model/ExternalModule;Ljava/util/List;)V", "getModule", "()Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "getTargets", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.meson"})
    public static final class Model {
        @NotNull
        private final ExternalModule module;
        @NotNull
        private final List<MesonExternalProjectData.Target> targets;

        public Model(@NotNull ExternalModule module, @NotNull List<MesonExternalProjectData.Target> targets) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            this.module = module;
            this.targets = targets;
        }

        @NotNull
        public final ExternalModule getModule() {
            return this.module;
        }

        @NotNull
        public final List<MesonExternalProjectData.Target> getTargets() {
            return this.targets;
        }

        @NotNull
        public final ExternalModule component1() {
            return this.module;
        }

        @NotNull
        public final List<MesonExternalProjectData.Target> component2() {
            return this.targets;
        }

        @NotNull
        public final Model copy(@NotNull ExternalModule module, @NotNull List<MesonExternalProjectData.Target> targets) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            return new Model(module, targets);
        }

        public static /* synthetic */ Model copy$default(Model model2, ExternalModule externalModule, List list, int n, Object object) {
            if ((n & 1) != 0) {
                externalModule = model2.module;
            }
            if ((n & 2) != 0) {
                list = model2.targets;
            }
            return model2.copy(externalModule, list);
        }

        @NotNull
        public String toString() {
            return "Model(module=" + this.module + ", targets=" + this.targets + ")";
        }

        public int hashCode() {
            int result2 = this.module.hashCode();
            result2 = result2 * 31 + ((Object)this.targets).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model2 = (Model)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)model2.module)) {
                return false;
            }
            return Intrinsics.areEqual(this.targets, model2.targets);
        }
    }
}

