/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.psi.MesonExpression;
import com.jetbrains.cidr.meson.psi.MesonExpressionStatement;
import com.jetbrains.cidr.meson.psi.MesonFile;
import com.jetbrains.cidr.meson.psi.MesonFunctionExpression;
import com.jetbrains.cidr.meson.psi.MesonStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/meson/highlighting/MesonOptionsAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "intellij.clion.meson"})
public final class MesonOptionsAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String OPTION_CMD_NAME = "option";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!MesonUtil.INSTANCE.isMesonOptionsFile(element.getContainingFile().getVirtualFile())) {
            return;
        }
        if (!(element instanceof MesonStatement) || !(((MesonStatement)element).getParent() instanceof MesonFile)) {
            return;
        }
        MesonExpressionStatement mesonExpressionStatement = element instanceof MesonExpressionStatement ? (MesonExpressionStatement)element : null;
        MesonExpression mesonExpression = mesonExpressionStatement != null ? mesonExpressionStatement.getMesonExpression() : null;
        MesonFunctionExpression mesonFunctionExpression = mesonExpression instanceof MesonFunctionExpression ? (MesonFunctionExpression)mesonExpression : null;
        if (!StringUtil.equals((CharSequence)(mesonFunctionExpression != null && (mesonFunctionExpression = mesonFunctionExpression.getFunctionIdentifier()) != null ? mesonFunctionExpression.getText() : null), (CharSequence)OPTION_CMD_NAME)) {
            holder.newAnnotation(HighlightSeverity.ERROR, MesonBundle.message("annotator.meson.options.error.bad.statement", new Object[0])).create();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/meson/highlighting/MesonOptionsAnnotator$Companion;", "", "()V", "OPTION_CMD_NAME", "", "intellij.clion.meson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

