/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.base.view;

import A.F.Vf;
import A.F.yH;
import A.G.u;
import com.intellij.xdebugger.impl.parallelStacks.base.view.GraphUtilsKt;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\n\u00a8\u0006*"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksEditMode;", "LA/F/yH;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "(Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "lastClickedNode", "LA/G/u;", "getLastClickedNode", "()LA/G/u;", "setLastClickedNode", "(LA/G/u;)V", "lastLeftMouseDown", "Ljava/awt/geom/Point2D;", "getLastLeftMouseDown", "()Ljava/awt/geom/Point2D;", "setLastLeftMouseDown", "(Ljava/awt/geom/Point2D;)V", "lastMovedNode", "getLastMovedNode", "setLastMovedNode", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseDraggedRight", "x", "", "y", "mouseMoved", "mousePressedLeft", "mousePressedRight", "mouseReleased", "mouseReleasedLeft", "mouseReleasedRight", "mouseShiftPressedLeft", "mouseShiftPressedRight", "mouseShiftReleasedLeft", "onWheelMoved", "wheelRotation", "point", "Ljava/awt/Point;", "intellij.platform.debugger.parallelStacks"})
public class ParallelStacksEditMode
extends yH {
    @NotNull
    private final UpdatableGraph2DView graphView;
    @Nullable
    private u lastMovedNode;
    @Nullable
    private u lastClickedNode;
    @NotNull
    private Point2D lastLeftMouseDown;

    public ParallelStacksEditMode(@NotNull UpdatableGraph2DView graphView) {
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        super(graphView);
        this.graphView = graphView;
        this.lastLeftMouseDown = new Point2D.Double(0.0, 0.0);
        this.graphView.addMouseWheelListener(arg_0 -> ParallelStacksEditMode.k(this, arg_0));
    }

    @Nullable
    protected final u getLastMovedNode() {
        return this.lastMovedNode;
    }

    protected final void setLastMovedNode(@Nullable u u2) {
        this.lastMovedNode = u2;
    }

    @Nullable
    protected final u getLastClickedNode() {
        return this.lastClickedNode;
    }

    protected final void setLastClickedNode(@Nullable u u2) {
        this.lastClickedNode = u2;
    }

    @NotNull
    protected final Point2D getLastLeftMouseDown() {
        return this.lastLeftMouseDown;
    }

    protected final void setLastLeftMouseDown(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.lastLeftMouseDown = point2D;
    }

    protected void onWheelMoved(double wheelRotation, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.graphView.zoomWithMouseWheel(wheelRotation, point);
        Point2D point2D = this.graphView.A();
        double d10 = this.graphView.x();
        double d11 = (double)point.x / d10 + point2D.getX();
        double d12 = (double)point.y / d10 + point2D.getY();
        Object object = this.k().k(d11, d12).k();
        if (object == null) {
            return;
        }
        Object object2 = object;
        Vf vf2 = this.k();
        Intrinsics.checkNotNullExpressionValue((Object)vf2, (String)"getGraph2D(...)");
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(vf2, (u)object2);
        if (parallelStacksNodeRealizer == null) {
            return;
        }
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer;
        parallelStacksNodeRealizer2.onWheelMoved(wheelRotation, point);
    }

    @Override
    public void mousePressedLeft(double x10, double y10) {
        block3: {
            this.lastLeftMouseDown = new Point2D.Double(x10, y10);
            this.graphView.setActivePoint(null);
            Object object = this.k().k(x10, y10).k();
            if (object == null) {
                return;
            }
            Object object2 = object;
            if (this.lastClickedNode != null && !Intrinsics.areEqual((Object)object2, (Object)this.lastClickedNode)) {
                ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer;
                Vf vf2 = this.k();
                Intrinsics.checkNotNullExpressionValue((Object)vf2, (String)"getGraph2D(...)");
                ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(vf2, this.lastClickedNode);
                if (parallelStacksNodeRealizer2 != null) {
                    parallelStacksNodeRealizer2.mousePressExpired();
                }
            }
            this.lastClickedNode = object2;
            Vf vf3 = this.k();
            Intrinsics.checkNotNullExpressionValue((Object)vf3, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(vf3, (u)object2);
            if (parallelStacksNodeRealizer == null) break block3;
            parallelStacksNodeRealizer.mousePressed(x10, y10);
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (SwingUtilities.isLeftMouseButton(event)) {
            this.graphView.setCursor(Cursor.getPredefinedCursor(13));
            Point point = event.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.graphView.drag(this.lastLeftMouseDown, point);
        }
    }

    @Override
    public void mouseReleasedLeft(double x10, double y10) {
        this.graphView.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super.mouseReleased(event);
            if (!SwingUtilities.isRightMouseButton(event)) break block1;
            JPopupMenu jPopupMenu = this.graphView.getComponentPopupMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(this.graphView, event.getX(), event.getY());
            }
        }
    }

    @Override
    public void mouseMoved(double x10, double y10) {
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer;
        Object object = this.k().k(x10, y10).k();
        if (this.lastMovedNode != null && !Intrinsics.areEqual((Object)object, (Object)this.lastMovedNode)) {
            Vf vf2 = this.k();
            Intrinsics.checkNotNullExpressionValue((Object)vf2, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(vf2, this.lastMovedNode);
            if (parallelStacksNodeRealizer2 != null) {
                parallelStacksNodeRealizer2.mouseLeft();
            }
        }
        this.lastMovedNode = object;
        if (object == null) {
            return;
        }
        Vf vf3 = this.k();
        Intrinsics.checkNotNullExpressionValue((Object)vf3, (String)"getGraph2D(...)");
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer3 = GraphUtilsKt.getParallelStacksRealizer(vf3, (u)object);
        if (parallelStacksNodeRealizer3 == null) {
            return;
        }
        parallelStacksNodeRealizer = parallelStacksNodeRealizer3;
        parallelStacksNodeRealizer.mouseMoved(x10, y10);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            MouseEvent mouseEvent = event;
            boolean bl = false;
            Point2D point2D = this.graphView.A();
            double d10 = this.graphView.x();
            double d11 = (double)mouseEvent.getX() / d10 + point2D.getX();
            double d12 = (double)mouseEvent.getY() / d10 + point2D.getY();
            Object object = this.k().k(d11, d12).k();
            Vf vf2 = this.k();
            Intrinsics.checkNotNullExpressionValue((Object)vf2, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(vf2, (u)object);
            if (parallelStacksNodeRealizer == null) break block0;
            parallelStacksNodeRealizer.mouseClicked(event.getClickCount() == 2, d11, d12);
        }
    }

    @Override
    public void mouseDraggedRight(double x10, double y10) {
    }

    @Override
    public void mousePressedRight(double x10, double y10) {
    }

    @Override
    public void mouseReleasedRight(double x10, double y10) {
    }

    @Override
    public void mouseShiftPressedRight(double x10, double y10) {
    }

    @Override
    public void mouseShiftPressedLeft(double x10, double y10) {
    }

    @Override
    public void mouseShiftReleasedLeft(double x10, double y10) {
    }

    private static final void k(ParallelStacksEditMode parallelStacksEditMode, MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)parallelStacksEditMode, (String)"this$0");
        double d10 = mouseWheelEvent.getPreciseWheelRotation();
        Point point = mouseWheelEvent.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        parallelStacksEditMode.onWheelMoved(d10, point);
    }
}

