/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspOpenedFilesService;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\b\u0010\f\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/lsp/impl/LspOpenedFilesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "openedFilesToHandle", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processOpenedFiles", "", "files", "", "k", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspOpenedFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,108:1\n766#2:109\n857#2,2:110\n1#3:112\n12474#4,2:113\n*S KotlinDebug\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService\n*L\n41#1:109\n41#1:110,2\n67#1:113,2\n*E\n"})
public final class LspOpenedFilesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> openedFilesToHandle;

    public LspOpenedFilesService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.openedFilesToHandle = set;
    }

    public final void processOpenedFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (!LspServerSupportProvider.Companion.getEP_NAME().hasAnyExtensions()) {
            return;
        }
        Iterable iterable = files;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            VirtualFile virtualFile = (VirtualFile)t2;
            boolean bl3 = false;
            if (!virtualFile.isInLocalFileSystem()) continue;
            collection.add(t2);
        }
        List list = (List)collection;
        boolean bl4 = false;
        boolean bl5 = this.openedFilesToHandle.addAll(list);
        if (bl5) {
            this.k();
        }
    }

    private final void k() {
        LspServerManagerImpl lspServerManagerImpl = LspServerManagerImpl.Companion.getInstanceImpl(this.project);
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> LspOpenedFilesService.k(this, lspServerManagerImpl)).coalesceBy(objectArray).expireWith((Disposable)lspServerManagerImpl).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspOpenedFilesService.k((Function1)new Function1<scheduleOpenedFilesProcessing.OpenedFilesData, Unit>(this, lspServerManagerImpl){
            final /* synthetic */ LspOpenedFilesService this$0;
            final /* synthetic */ LspServerManagerImpl $lspServerManager;
            {
                this.this$0 = $receiver;
                this.$lspServerManager = $lspServerManager;
                super(1);
            }

            public final void invoke(@NotNull scheduleOpenedFilesProcessing.OpenedFilesData data) {
                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"com/intellij/platform/lsp/impl/LspOpenedFilesService$scheduleOpenedFilesProcessing$OpenedFilesData", "", "()V", "handledFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getHandledFiles", "()Ljava/util/Set;", "newServersToStart", "", "Lkotlin/Pair;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "getNewServersToStart", "()Ljava/util/Collection;", "serversToSendDidOpen", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "getServersToSendDidOpen", "()Lcom/intellij/util/containers/MultiMap;", "intellij.platform.lsp.impl"})
                public final class OpenedFilesData {
                    @NotNull
                    private final Set<VirtualFile> handledFiles;
                    @NotNull
                    private final MultiMap<LspServerImpl, VirtualFile> serversToSendDidOpen;
                    @NotNull
                    private final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> newServersToStart;

                    public OpenedFilesData() {
                        this.handledFiles = new HashSet<E>();
                        this.serversToSendDidOpen = new MultiMap();
                        this.newServersToStart = new ArrayList<E>();
                    }

                    @NotNull
                    public final Set<VirtualFile> getHandledFiles() {
                        return this.handledFiles;
                    }

                    @NotNull
                    public final MultiMap<LspServerImpl, VirtualFile> getServersToSendDidOpen() {
                        return this.serversToSendDidOpen;
                    }

                    @NotNull
                    public final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> getNewServersToStart() {
                        return this.newServersToStart;
                    }
                }
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                LspOpenedFilesService.access$getOpenedFilesToHandle$p(this.this$0).removeAll((Collection)data.getHandledFiles());
                if (!data.getServersToSendDidOpen().isEmpty()) {
                    WriteAction.run(() -> scheduleOpenedFilesProcessing.2.k(data));
                }
                Iterable iterable = data.getNewServersToStart();
                LspServerManagerImpl lspServerManagerImpl = this.$lspServerManager;
                boolean bl = false;
                for (T t2 : iterable) {
                    Pair pair = (Pair)t2;
                    boolean bl2 = false;
                    lspServerManagerImpl.ensureServerStarted$intellij_platform_lsp_impl(pair.getFirst().getClass(), (LspServerDescriptor)pair.getSecond());
                }
            }

            private static final void k(scheduleOpenedFilesProcessing.OpenedFilesData openedFilesData) {
                Intrinsics.checkNotNullParameter((Object)openedFilesData, (String)"$data");
                for (Map.Entry entry : openedFilesData.getServersToSendDidOpen().entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    LspServerImpl lspServerImpl = (LspServerImpl)entry.getKey();
                    Collection collection = (Collection)entry.getValue();
                    for (VirtualFile virtualFile : collection) {
                        Intrinsics.checkNotNull((Object)virtualFile);
                        lspServerImpl.sendDidOpenRequest$intellij_platform_lsp_impl(virtualFile);
                    }
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final scheduleOpenedFilesProcessing.OpenedFilesData k(LspOpenedFilesService lspOpenedFilesService, LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspOpenedFilesService, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"$lspServerManager");
        OpenedFilesData openedFilesData = new OpenedFilesData();
        Object object2 = lspOpenedFilesService.openedFilesToHandle;
        synchronized (object2) {
            boolean bl = false;
            bl = openedFilesData.getHandledFiles().addAll((Collection<VirtualFile>)lspOpenedFilesService.openedFilesToHandle);
        }
        for (Object object2 : LspServerSupportProvider.Companion.getEP_NAME().getExtensionList()) {
            Collection<LspServerImpl> collection = lspServerManagerImpl.getServersForProvider(object2.getClass());
            boolean bl = false;
            for (VirtualFile virtualFile : openedFilesData.getHandledFiles()) {
                LspServerDescriptor lspServerDescriptor;
                int n2;
                for (LspServerImpl lspServerImpl : collection) {
                    boolean bl2;
                    block8: {
                        ProgressManager.checkCanceled();
                        VirtualFile[] virtualFileArray = lspServerImpl.getDescriptor().getRoots();
                        boolean bl3 = false;
                        int n3 = virtualFileArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            VirtualFile virtualFile2;
                            VirtualFile virtualFile3 = virtualFile2 = virtualFileArray[n2];
                            boolean bl4 = false;
                            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile, (boolean)true)) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                    }
                    if (lspServerImpl.getState() != LspServerState.Running || lspServerImpl.isFileOpened$intellij_platform_lsp_impl(virtualFile) || !lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
                    openedFilesData.getServersToSendDidOpen().putValue((Object)lspServerImpl, (Object)virtualFile);
                }
                if (bl || !ProjectFileIndex.getInstance((Project)lspOpenedFilesService.project).isInContent(virtualFile)) continue;
                LspServerManagerImpl.LspServerStarterImpl lspServerStarterImpl = new LspServerManagerImpl.LspServerStarterImpl();
                object2.fileOpened(lspOpenedFilesService.project, virtualFile, lspServerStarterImpl);
                if (lspServerStarterImpl.getDescriptor() == null) continue;
                n2 = 0;
                openedFilesData.getNewServersToStart().add((Pair<LspServerSupportProvider, LspServerDescriptor>)TuplesKt.to((Object)object2, (Object)lspServerDescriptor));
            }
        }
        return openedFilesData;
    }

    private static final void k(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ Set access$getOpenedFilesToHandle$p(LspOpenedFilesService $this) {
        return $this.openedFilesToHandle;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion;", "", "()V", "getInstance", "Lcom/intellij/platform/lsp/impl/LspOpenedFilesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspOpenedFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,108:1\n31#2,2:109\n*S KotlinDebug\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion\n*L\n27#1:109,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LspOpenedFilesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<LspOpenedFilesService> clazz = LspOpenedFilesService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (LspOpenedFilesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

