/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspDynamicCapabilities;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.FileChangeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "FileChangeApplier", "intellij.platform.lsp.impl"})
public final class LspFileListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!LspServerManagerImpl.Companion.isAnyServerRunning$intellij_platform_lsp_impl()) {
            return null;
        }
        Set set = new LinkedHashSet();
        List list = new ArrayList();
        for (VFileEvent vFileEvent : events) {
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
            if (vFileEvent instanceof VFileMoveEvent) {
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                set.add(virtualFile);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                set.add(virtualFile);
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileCopyEvent) && !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            list.add(vFileEvent);
        }
        if (!set.isEmpty() || !list.isEmpty()) {
            return new FileChangeApplier(set, list);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\n\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileListener$FileChangeApplier;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "renamedFilesAndDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteCreateCopyChangeEvents", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/Set;Ljava/util/List;)V", "serverToFileChangeInfos", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileChangeInfo;", "Lorg/jetbrains/annotations/NotNull;", "serversToUpdateOpenedFiles", "", "afterVfsChange", "", "beforeVfsChange", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspFileListener.kt\ncom/intellij/platform/lsp/impl/LspFileListener$FileChangeApplier\n+ 2 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n*L\n1#1,134:1\n331#2:135\n332#2:137\n333#2:139\n334#2:145\n335#2:147\n331#2:149\n332#2:151\n333#2,2:153\n335#2:156\n13309#3:136\n13310#3:148\n13309#3:150\n13310#3:157\n1855#4:138\n1855#4,2:141\n1855#4,2:143\n1856#4:146\n1855#4:152\n1856#4:155\n1855#4,2:158\n103#5:140\n*S KotlinDebug\n*F\n+ 1 LspFileListener.kt\ncom/intellij/platform/lsp/impl/LspFileListener$FileChangeApplier\n*L\n55#1:135\n55#1:137\n55#1:139\n55#1:145\n55#1:147\n87#1:149\n87#1:151\n87#1:153,2\n87#1:156\n55#1:136\n55#1:148\n87#1:150\n87#1:157\n55#1:138\n75#1:141,2\n81#1:143,2\n55#1:146\n87#1:152\n87#1:155\n130#1:158,2\n75#1:140\n*E\n"})
    private static final class FileChangeApplier
    implements AsyncFileListener.ChangeApplier {
        @NotNull
        private final Set<VirtualFile> renamedFilesAndDirs;
        @NotNull
        private final List<VFileEvent> deleteCreateCopyChangeEvents;
        @NotNull
        private final Set<LspServerImpl> serversToUpdateOpenedFiles;
        @NotNull
        private final MultiMap<LspServerImpl, LspServerImpl.FileChangeInfo> serverToFileChangeInfos;

        public FileChangeApplier(@NotNull Set<? extends VirtualFile> renamedFilesAndDirs, @NotNull List<? extends VFileEvent> deleteCreateCopyChangeEvents) {
            Intrinsics.checkNotNullParameter(renamedFilesAndDirs, (String)"renamedFilesAndDirs");
            Intrinsics.checkNotNullParameter(deleteCreateCopyChangeEvents, (String)"deleteCreateCopyChangeEvents");
            this.renamedFilesAndDirs = renamedFilesAndDirs;
            this.deleteCreateCopyChangeEvents = deleteCreateCopyChangeEvents;
            this.serversToUpdateOpenedFiles = new HashSet();
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            this.serverToFileChangeInfos = multiMap;
        }

        public void beforeVfsChange() {
            LspServerManagerImpl.Companion companion = LspServerManagerImpl.Companion;
            boolean bl = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] objectArray = projectArray;
            boolean bl2 = false;
            for (Object object : objectArray) {
                Project project = (Project)object;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)project);
                Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project));
                boolean bl4 = false;
                for (Object t2 : iterable) {
                    Object object2;
                    Object object3;
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl5 = false;
                    if (lspServerImpl.getState() != LspServerState.Running) continue;
                    LspServerImpl lspServerImpl2 = lspServerImpl;
                    boolean bl6 = false;
                    boolean bl7 = lspServerImpl2.getDynamicCapabilities$intellij_platform_lsp_impl().hasCapability(LspDynamicCapabilities.Companion.getDidChangeWatchedFiles());
                    if (bl7) {
                        for (VFileEvent vFileEvent : this.deleteCreateCopyChangeEvents) {
                            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)((VFileDeleteEvent)vFileEvent).getFile(), (String)"getFile(...)");
                            object2 = lspServerImpl2.getDescriptor().getFileUri((VirtualFile)object3);
                            String string = object3.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string, (String)object2, object3.isDirectory(), FileChangeType.Deleted));
                        }
                    }
                    for (VirtualFile virtualFile : this.renamedFilesAndDirs) {
                        if (bl7) {
                            object3 = lspServerImpl2.getDescriptor().getFileUri(virtualFile);
                            String string = virtualFile.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string, (String)object3, virtualFile.isDirectory(), FileChangeType.Deleted));
                        }
                        object3 = new ArrayList();
                        object2 = lspServerImpl2;
                        boolean bl8 = false;
                        Object object4 = LspServerImpl.access$getOpenedFiles$p((LspServerImpl)object2);
                        boolean bl9 = false;
                        VirtualFile virtualFile2 = object4.iterator();
                        while (virtualFile2.hasNext()) {
                            Object t3 = virtualFile2.next();
                            VirtualFile virtualFile3 = (VirtualFile)t3;
                            boolean bl10 = false;
                            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile3, (boolean)false)) continue;
                            this.serversToUpdateOpenedFiles.add(lspServerImpl2);
                            object3.add(virtualFile3);
                        }
                        object2 = (Iterable)object3;
                        bl8 = false;
                        object4 = object2.iterator();
                        while (object4.hasNext()) {
                            Object e2 = object4.next();
                            virtualFile2 = (VirtualFile)e2;
                            boolean bl11 = false;
                            lspServerImpl2.sendDidCloseRequest$intellij_platform_lsp_impl(virtualFile2);
                        }
                    }
                }
            }
        }

        public void afterVfsChange() {
            Object object = LspServerManagerImpl.Companion;
            boolean bl = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object object2 = projectArray;
            boolean bl2 = false;
            for (Object object3 : object2) {
                Project project = (Project)object3;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)project);
                Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project));
                boolean bl4 = false;
                for (Object t2 : iterable) {
                    String string;
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl5 = false;
                    if (lspServerImpl.getState() != LspServerState.Running) continue;
                    LspServerImpl lspServerImpl2 = lspServerImpl;
                    boolean bl6 = false;
                    if (!lspServerImpl2.getDynamicCapabilities$intellij_platform_lsp_impl().hasCapability(LspDynamicCapabilities.Companion.getDidChangeWatchedFiles())) continue;
                    for (VirtualFile virtualFile : this.renamedFilesAndDirs) {
                        string = lspServerImpl2.getDescriptor().getFileUri(virtualFile);
                        String string2 = virtualFile.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string2, string, virtualFile.isDirectory(), FileChangeType.Created));
                    }
                    for (VFileEvent vFileEvent : this.deleteCreateCopyChangeEvents) {
                        String string3;
                        if (vFileEvent instanceof VFileContentChangeEvent) {
                            Intrinsics.checkNotNullExpressionValue((Object)((VFileContentChangeEvent)vFileEvent).getFile(), (String)"getFile(...)");
                            string3 = lspServerImpl2.getDescriptor().getFileUri((VirtualFile)string);
                            String string4 = string.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                            this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string4, string3, string.isDirectory(), FileChangeType.Changed));
                        }
                        if (vFileEvent instanceof VFileCreateEvent && (string = vFileEvent.getFile()) != null) {
                            string3 = lspServerImpl2.getDescriptor().getFileUri((VirtualFile)string);
                            String string5 = string.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                            this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string5, string3, string.isDirectory(), FileChangeType.Created));
                        }
                        if (!(vFileEvent instanceof VFileCopyEvent) || (string = ((VFileCopyEvent)vFileEvent).findCreatedFile()) == null) continue;
                        string3 = lspServerImpl2.getDescriptor().getFileUri((VirtualFile)string);
                        String string6 = string.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                        this.serverToFileChangeInfos.putValue((Object)lspServerImpl2, (Object)new LspServerImpl.FileChangeInfo(string6, string3, string.isDirectory(), FileChangeType.Created));
                    }
                }
            }
            if (!this.serverToFileChangeInfos.isEmpty()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> FileChangeApplier.k(this));
            }
            object = this.serversToUpdateOpenedFiles;
            bl = false;
            object2 = object.iterator();
            while (object2.hasNext()) {
                Object e2 = object2.next();
                LspServerImpl lspServerImpl = (LspServerImpl)e2;
                int n2 = 0;
                lspServerImpl.sendOpenedFiles$intellij_platform_lsp_impl();
            }
        }

        private static final void k(FileChangeApplier fileChangeApplier) {
            Intrinsics.checkNotNullParameter((Object)fileChangeApplier, (String)"this$0");
            for (Map.Entry entry : fileChangeApplier.serverToFileChangeInfos.entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                LspServerImpl lspServerImpl = (LspServerImpl)entry.getKey();
                Collection collection = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)collection);
                lspServerImpl.processFileEvents$intellij_platform_lsp_impl(collection);
            }
        }
    }
}

