/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.parameters;

import com.intellij.microservices.url.parameters.PathVariablePsiElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/url/parameters/PathVariableRenameInputValidator;", "Lcom/intellij/refactoring/rename/RenameInputValidator;", "()V", "getPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "isInputValid", "", "newName", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "intellij.microservices"})
public final class PathVariableRenameInputValidator
implements RenameInputValidator {
    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(PathVariablePsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiElement(...)");
        return (ElementPattern)capture;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context2) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PathVariablePsiElement pathVariablePsiElement = element instanceof PathVariablePsiElement ? (PathVariablePsiElement)element : null;
        if (pathVariablePsiElement == null) {
            return false;
        }
        PathVariablePsiElement pathVariablePsiElement2 = pathVariablePsiElement;
        return pathVariablePsiElement2.getNameValidationPattern().matcher(newName).matches();
    }
}

