/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.http.HttpHeaderElement;
import com.intellij.microservices.http.HttpHeadersDictionary;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\rB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/microservices/http/HttpHeaderReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getUnresolvedMessagePattern", "", "isReferenceTo", "", "resolve", "Companion", "intellij.microservices"})
public final class HttpHeaderReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HttpHeaderReference(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element, range);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return MicroservicesBundle.message("http.header.element.error", new Object[0]);
    }

    @Nullable
    public PsiElement resolve() {
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String string2 = string;
        if (!HttpHeadersDictionary.HEADER_NAME_PATTERN.matcher(string2).matches()) {
            return null;
        }
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return (PsiElement)new HttpHeaderElement(psiElement, string2);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof HttpHeaderElement && Intrinsics.areEqual((Object)((HttpHeaderElement)element).getName(), (Object)this.getValue());
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
        return Companion.forElement(injectionHost);
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
        return Companion.forElement(injectionHost, range);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/http/HttpHeaderReference$Companion;", "", "()V", "forElement", "", "Lcom/intellij/psi/PsiReference;", "injectionHost", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)[Lcom/intellij/psi/PsiReference;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)injectionHost);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return this.forElement(injectionHost, textRange);
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            PsiReference[] psiReferenceArray = new PsiReference[]{new HttpHeaderReference(injectionHost, range)};
            return psiReferenceArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

