/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.v2.listeners;

import com.intellij.diagram.v2.elements.GraphChartGroupNode;
import com.intellij.diagram.v2.listeners.GraphChartRemoveEdgesEvent;
import com.intellij.diagram.v2.listeners.GraphChartRemoveGroupNodeEvent;
import com.intellij.diagram.v2.listeners.GraphChartRemoveNodesEvent;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0016J\u001c\u0010\n\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagram/v2/listeners/GraphChartRemoveListener;", "N", "E", "Ljava/util/EventListener;", "onEdgesRemoved", "", "event", "Lcom/intellij/diagram/v2/listeners/GraphChartRemoveEdgesEvent;", "onGroupNodesRemoved", "Lcom/intellij/diagram/v2/listeners/GraphChartRemoveGroupNodeEvent;", "onNodesRemoved", "Lcom/intellij/diagram/v2/listeners/GraphChartRemoveNodesEvent;", "intellij.diagram"})
public interface GraphChartRemoveListener<N, E>
extends EventListener {
    default public void onNodesRemoved(@NotNull GraphChartRemoveNodesEvent<N, E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (N removedNode : event.getRemovedNodes()) {
            event.getChart().getGraph().removeNode(removedNode);
        }
    }

    default public void onEdgesRemoved(@NotNull GraphChartRemoveEdgesEvent<N, E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (E removedEdge : event.getRemovedEdges()) {
            event.getChart().getGraph().removeEdge(removedEdge);
        }
    }

    default public void onGroupNodesRemoved(@NotNull GraphChartRemoveGroupNodeEvent<N, E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (GraphChartGroupNode<N> removedGroupNode : event.getRemovedGroupNodes()) {
            event.getChart().asHierarchyHandle().removeGroupWithItsNodes(removedGroupNode);
        }
    }
}

