/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.kernel.backend;

import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.kernel.backend.RemoteApiProvider;
import com.intellij.platform.kernel.backend.RemoteApiRegistryKt;
import com.intellij.platform.kernel.rpc.RemoteApiProviderService;
import com.intellij.util.containers.ContainerUtil;
import fleet.rpc.RemoteApi;
import fleet.rpc.core.InstanceId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0010\u001a\"\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\u0011\u001a\u00020\u0007J+\u0010\u0010\u001a\u0002H\u0012\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\tH\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a.\u0012\u0004\u0012\u00020\u0007\u0012$\u0012\"\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u000f0\r\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/kernel/backend/RemoteApiRegistry;", "Lcom/intellij/platform/kernel/rpc/RemoteApiProviderService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "remoteApis", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/rpc/core/InstanceId;", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lfleet/rpc/RemoteApi;", "", "visitedEPs", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/platform/kernel/backend/RemoteApiProvider;", "Lorg/jetbrains/annotations/NotNull;", "resolve", "instanceId", "T", "kclass", "(Lkotlin/reflect/KClass;)Lfleet/rpc/RemoteApi;", "intellij.platform.kernel.backend"})
@SourceDebugExtension(value={"SMAP\nRemoteApiRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteApiRegistry.kt\ncom/intellij/platform/kernel/backend/RemoteApiRegistry\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n3792#2:58\n4307#2,2:59\n1360#3:61\n1446#3,5:62\n1855#3,2:67\n*S KotlinDebug\n*F\n+ 1 RemoteApiRegistry.kt\ncom/intellij/platform/kernel/backend/RemoteApiRegistry\n*L\n41#1:58\n41#1:59,2\n41#1:61\n41#1:62,5\n41#1:67,2\n*E\n"})
public final class RemoteApiRegistry
implements RemoteApiProviderService {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<InstanceId, Pair<KClass<? extends RemoteApi<Unit>>, RemoteApi<Unit>>> remoteApis;
    @NotNull
    private final ConcurrentMap<RemoteApiProvider, Unit> visitedEPs;

    /*
     * WARNING - void declaration
     */
    public RemoteApiRegistry(@NotNull CoroutineScope coroutineScope) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.remoteApis = new ConcurrentHashMap();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeyWeakValueMap(...)");
        this.visitedEPs = concurrentMap;
        RemoteApiProvider.Companion.getEP_NAME().addExtensionPointListener(this.coroutineScope, (ExtensionPointListener)new ExtensionPointListener<RemoteApiProvider>(){

            public void extensionAdded(@NotNull RemoteApiProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (visitedEPs.putIfAbsent(extension, Unit.INSTANCE) == null) {
                    List<RemoteApiProvider.RemoteApiDescriptor<?>> apis = extension.getApis();
                    for (RemoteApiProvider.RemoteApiDescriptor<?> api : apis) {
                        ((Map)remoteApis).put(RemoteApiRegistryKt.access$getToInstanceId(api.getKlass()), TuplesKt.to(api.getKlass(), (Object)api.getService().invoke()));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionRemoved(@NotNull RemoteApiProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                visitedEPs.remove(extension);
                List<RemoteApiProvider.RemoteApiDescriptor<?>> apis = extension.getApis();
                RemoteApiRegistry remoteApiRegistry = this;
                1 var5_5 = this;
                synchronized (var5_5) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = apis;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RemoteApiProvider.RemoteApiDescriptor api = (RemoteApiProvider.RemoteApiDescriptor)element$iv;
                        boolean bl2 = false;
                        remoteApiRegistry.remoteApis.remove(RemoteApiRegistryKt.access$getToInstanceId(api.getKlass()));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        Object[] $this$filter$iv = RemoteApiProvider.Companion.getEP_NAME().getExtensions();
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RemoteApiProvider it = (RemoteApiProvider)element$iv$iv;
            boolean bl = false;
            if (!(this.visitedEPs.putIfAbsent(it, Unit.INSTANCE) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RemoteApiProvider it = (RemoteApiProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getApis();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteApiProvider.RemoteApiDescriptor api = (RemoteApiProvider.RemoteApiDescriptor)element$iv;
            boolean bl = false;
            ((Map)this.remoteApis).put(RemoteApiRegistryKt.access$getToInstanceId(api.getKlass()), TuplesKt.to(api.getKlass(), (Object)api.getService().invoke()));
        }
    }

    @NotNull
    public <T extends RemoteApi<Unit>> T resolve(@NotNull KClass<T> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        Pair<KClass<? extends RemoteApi<Unit>>, RemoteApi<Unit>> pair = this.remoteApis.get(RemoteApiRegistryKt.access$getToInstanceId(kclass));
        RemoteApi remoteApi = pair != null ? (RemoteApi)pair.getSecond() : null;
        Object object = remoteApi instanceof RemoteApi ? remoteApi : null;
        if (object == null) {
            throw new IllegalStateException("No remote API found for " + kclass);
        }
        return (T)object;
    }

    @NotNull
    public final Pair<KClass<? extends RemoteApi<Unit>>, RemoteApi<Unit>> resolve(@NotNull InstanceId instanceId) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Pair<KClass<? extends RemoteApi<Unit>>, RemoteApi<Unit>> pair = this.remoteApis.get(instanceId);
        if (pair == null) {
            throw new IllegalStateException("No remote API found for " + instanceId);
        }
        return pair;
    }
}

