/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.highlighting.ClangPPHighlightingHandler;
import com.jetbrains.cidr.lang.highlighting.ClangPPMatchingHighlighter;
import java.awt.Component;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/highlighting/ClangPPMatchingHighlighter;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "clearHighlights", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isValidEditor", "", "needMatching", "onCaretUpdate", "registerListeners", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateHighlighted", "intellij.c.clangd"})
public final class ClangPPMatchingHighlighter
implements ProjectActivity,
DumbAware {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        if (!ClangdBridge.getMatchPP()) {
            return Unit.INSTANCE;
        }
        Disposable disposable = ExtensionPointUtil.createExtensionDisposable((Object)this, (ExtensionPointName)StartupActivity.Companion.getPOST_STARTUP_ACTIVITY());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"createExtensionDisposable(...)");
        Disposable activityDisposable = disposable;
        Disposer.register((Disposable)((Disposable)project), (Disposable)activityDisposable);
        this.registerListeners(project, activityDisposable);
        return Unit.INSTANCE;
    }

    private final void registerListeners(Project project, Disposable parentDisposable) {
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        eventMulticaster.addCaretListener(new CaretListener(this, project){
            final /* synthetic */ ClangPPMatchingHighlighter this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                Editor editor = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                ClangPPMatchingHighlighter.access$onCaretUpdate(this.this$0, editor, this.$project);
            }

            public void caretAdded(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                Editor editor = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                ClangPPMatchingHighlighter.access$onCaretUpdate(this.this$0, editor, this.$project);
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                ClangPPMatchingHighlighter.access$onCaretUpdate(this.this$0, editor, this.$project);
            }
        }, parentDisposable);
        SelectionListener selectionListener2 = new SelectionListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangPPMatchingHighlighter this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor = e.getEditor();
                if (editor.getProject() != this.$project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && oldRange.isEmpty() == newRange.isEmpty()) {
                    return;
                }
                Intrinsics.checkNotNull((Object)editor);
                ClangPPMatchingHighlighter.access$updateHighlighted(this.this$0, this.$project, editor);
            }
        };
        eventMulticaster.addSelectionListener(selectionListener2, parentDisposable);
        DocumentListener documentListener2 = new DocumentListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangPPMatchingHighlighter this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorFactory.getInstance().editors(e.getDocument(), this.$project).forEach(arg_0 -> registerListeners.documentListener.1.documentChanged$lambda$0((Function1)new Function1<Editor, Unit>(this.this$0, this.$project){
                    final /* synthetic */ ClangPPMatchingHighlighter this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Editor editor) {
                        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                        ClangPPMatchingHighlighter.access$updateHighlighted(this.this$0, this.$project, editor);
                    }
                }, arg_0));
            }

            private static final void documentChanged$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
        eventMulticaster.addDocumentListener(documentListener2, parentDisposable);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(parentDisposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this, project){
            final /* synthetic */ ClangPPMatchingHighlighter this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)oldEditor).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    ClangPPMatchingHighlighter.access$clearHighlights(this.this$0, this.$project, editor);
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    Editor editor = ((TextEditor)newEditor).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    ClangPPMatchingHighlighter.access$updateHighlighted(this.this$0, this.$project, editor);
                }
            }
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect(parentDisposable);
        Topic topic2 = TemplateManager.TEMPLATE_STARTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TEMPLATE_STARTED_TOPIC");
        messageBusConnection2.subscribe(topic2, arg_0 -> ClangPPMatchingHighlighter.registerListeners$lambda$0(this, project, arg_0));
    }

    private final void onCaretUpdate(Editor editor, Project project) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (editor.getProject() != project || selectionModel2.hasSelection()) {
            return;
        }
        this.updateHighlighted(project, editor);
    }

    private final boolean isValidEditor(Editor editor) {
        Project editorProject = editor.getProject();
        return editorProject != null && !editorProject.isDisposed() && !editor.isDisposed() && UIUtil.isShowing((Component)editor.getContentComponent());
    }

    private final void updateHighlighted(Project project, Editor editor) {
        ThreadingAssertions.assertEventDispatchThread();
        if (editor.getDocument().isInBulkUpdate() || !this.isValidEditor(editor)) {
            return;
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        if (!ClangdBridge.isSupported(project, editor.getVirtualFile())) {
            return;
        }
        Object[] objectArray = new Object[]{ClangPPMatchingHighlighter.class, editor};
        ReadAction.nonBlocking(() -> ClangPPMatchingHighlighter.updateHighlighted$lambda$1(project, editor)).withDocumentsCommitted(project).coalesceBy(objectArray).expireWhen(() -> ClangPPMatchingHighlighter.updateHighlighted$lambda$2(this, editor, offsetBefore)).finishOnUiThread(ModalityState.stateForComponent((Component)editor.getComponent()), arg_0 -> ClangPPMatchingHighlighter.updateHighlighted$lambda$3((Function1)new Function1<ClangPPHighlightingHandler, Unit>(this, editor){
            final /* synthetic */ ClangPPMatchingHighlighter this$0;
            final /* synthetic */ Editor $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                super(1);
            }

            public final void invoke(ClangPPHighlightingHandler handler) {
                if (ClangPPMatchingHighlighter.access$needMatching(this.this$0, this.$editor)) {
                    handler.doApplyInfoToEditor();
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final boolean needMatching(Editor editor) {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (!codeInsightSettings.HIGHLIGHT_BRACES) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(editor.getCaretModel().getVisualPosition())) {
            return false;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
        return state == null || state.isFinished();
    }

    private final void clearHighlights(Project project, Editor editor) {
        ThreadingAssertions.assertEventDispatchThread();
        ClangPPHighlightingHandler handler = new ClangPPHighlightingHandler(project, editor, null, 4, null);
        handler.clearHighlights();
    }

    private static final void registerListeners$lambda$0(ClangPPMatchingHighlighter this$0, Project $project, TemplateState state) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!state.isFinished()) {
            Editor editor = state.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            this$0.updateHighlighted($project, editor);
            state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(this$0, $project, state){
                final /* synthetic */ ClangPPMatchingHighlighter this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ TemplateState $state;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$state = $state;
                }

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                    Editor editor = this.$state.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    ClangPPMatchingHighlighter.access$updateHighlighted(this.this$0, this.$project, editor);
                }
            });
        }
    }

    private static final ClangPPHighlightingHandler updateHighlighted$lambda$1(Project $project, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        ClangPPHighlightingHandler handler = new ClangPPHighlightingHandler($project, $editor, null, 4, null);
        handler.collectRanges();
        return handler;
    }

    private static final boolean updateHighlighted$lambda$2(ClangPPMatchingHighlighter this$0, Editor $editor, int $offsetBefore) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        return !this$0.isValidEditor($editor) || $offsetBefore != $editor.getCaretModel().getOffset();
    }

    private static final void updateHighlighted$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$onCaretUpdate(ClangPPMatchingHighlighter $this, Editor editor, Project project) {
        $this.onCaretUpdate(editor, project);
    }

    public static final /* synthetic */ void access$updateHighlighted(ClangPPMatchingHighlighter $this, Project project, Editor editor) {
        $this.updateHighlighted(project, editor);
    }

    public static final /* synthetic */ void access$clearHighlights(ClangPPMatchingHighlighter $this, Project project, Editor editor) {
        $this.clearHighlights(project, editor);
    }

    public static final /* synthetic */ boolean access$needMatching(ClangPPMatchingHighlighter $this, Editor editor) {
        return $this.needMatching(editor);
    }
}

