/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.WslContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorDebugInfoBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public final class ClazyAnnotator
extends ClangTidyAnnotator {
    private static final Logger LOG = Logger.getInstance(ClazyAnnotator.class);
    public static final Key<Boolean> TAKE_CLAZY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLAZY_CONFIG");
    private final ClazyAnnotatorExecutionConfig myExecutionConfig;

    public ClazyAnnotator() {
        this(new ClazyAnnotatorExecutionConfig(null));
    }

    public ClazyAnnotator(@NotNull ClazyAnnotatorExecutionConfig executionConfig) {
        if (executionConfig == null) {
            ClazyAnnotator.$$$reportNull$$$0(0);
        }
        super(executionConfig);
        this.myExecutionConfig = executionConfig;
    }

    @Override
    public String getPairedBatchInspectionShortName() {
        return ClazyInspection.getInspectionShortName();
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project;
        if (info == null) {
            ClazyAnnotator.$$$reportNull$$$0(1);
        }
        if (ClangUtils.isClangdOn(project = info.getProject()) && ClangUtils.isClangTidyViaClangdOn(project)) {
            if (info.getFile().getVirtualFile() == null) {
                return false;
            }
            if (ClangUtils.isClangTidyViaClangdForced(project)) {
                return true;
            }
            return info.getEditor() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ClangTidyAnnotationHolder executeClazy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        WSLDistribution wslDistribution;
        if (info == null) {
            ClazyAnnotator.$$$reportNull$$$0(2);
        }
        if (workingDirectory == null) {
            ClazyAnnotator.$$$reportNull$$$0(3);
        }
        if (ClazyAnnotator.useLanguageService(info)) {
            ClangUtils.traceClangd(LOG, "Clangd is used for clazy diagnostics");
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            SensitiveProgressWrapper newIndicator = currentIndicator != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
            Ref result = Ref.create();
            ClangTidyAnnotator.MyMasterReparsingPassListener masterListener = ClazyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
            ClangTidyAnnotator.MySlaveReparsingPassListener slaveListener = new ClangTidyAnnotator.MySlaveReparsingPassListener((ProgressIndicator)newIndicator, info.getFile());
            try {
                masterListener.addListener(slaveListener);
                ProgressManager.getInstance().runProcess(() -> {
                    Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                    if (!isFileValid.booleanValue()) {
                        return;
                    }
                    ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted(info.getProject());
                    if (languageService == null) {
                        return;
                    }
                    result.set((Object)languageService.computeWithParsed(info.getFile().getVirtualFile(), response -> {
                        if (response == null) {
                            return null;
                        }
                        try {
                            ArrayList<ClangTidyDiagnostic> diagnostics = new ArrayList<ClangTidyDiagnostic>();
                            if (info.getProject().getUserData(TAKE_CLAZY_CONFIG) != Boolean.FALSE) {
                                CompletableFuture<Supplier<List<ClangDiagnostic>>> clazyDiagsFuture = response.getClazyDiagnostics();
                                Supplier clazySupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(clazyDiagsFuture, (long)Long.MAX_VALUE, (String)"Clazy diagnostics");
                                if (clazySupplier == null) {
                                    return null;
                                }
                                @NlsSafe CharSequence text = info.getDocument().getCharsSequence();
                                diagnostics.addAll(ClazyAnnotator.convertClazyDiags((List)clazySupplier.get(), text, info.getInputFileName()));
                            }
                            return ClangTidyAnnotationHolder.success(diagnostics);
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            return null;
                        }
                    }));
                }, (ProgressIndicator)newIndicator);
            }
            finally {
                masterListener.removeListener(slaveListener);
            }
            return (ClangTidyAnnotationHolder)result.get();
        }
        ClangUtils.traceClangd(LOG, "Clazy is used for clazy diagnostics");
        File clazyPath = ClazyAnnotator.getBuiltinClazyPath();
        WslContext wslCtx = ClangToolsWslService.Companion.getInstance(info.getProject()).getWslContext();
        String wslMsId = wslCtx != null ? wslCtx.getId() : null;
        ClangUrlConverter converter = new ClangUrlConverter();
        WSLDistribution wSLDistribution = wslDistribution = wslCtx != null ? wslCtx.getDistribution() : null;
        if (wslMsId != null) {
            converter.setWslMsId(wslMsId);
            converter.setWslMntRoot(wslCtx.getMountRoot());
        }
        if (!ClazyAnnotator.isAvailable(clazyPath)) {
            return ClangTidyAnnotationHolder.error(ClangdBundle.message("inspection.clazy.not.found", new Object[0]));
        }
        Document document2 = info.getDocument();
        long modificationStampOnStart = document2.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClazyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClazyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory, converter);
        File outputFile = new File(workingDirectory, "output.yaml");
        ClangTidyAnnotatorDebugInfoBuilder debugInfoBuilder = new ClangTidyAnnotatorDebugInfoBuilder();
        File compilationDatabase = ClazyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile, debugInfoBuilder, converter);
        if (ClazyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCompilationDatabase(FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (converter.isWslMode()) {
            commandLine.setExePath(ClangUtils.getWslClangdDirPath() + "/clazy-standalone");
        } else {
            commandLine.setExePath(clazyPath.getAbsolutePath());
        }
        commandLine.addParameter("-checks=" + this.myExecutionConfig.getConfig(info.getProject()));
        commandLine.addParameter("-p=" + ClazyAnnotator.fixWslPathIfRequired(workingDirectory.getPath(), converter));
        commandLine.addParameter("--vfsoverlay=" + ClazyAnnotator.fixWslPathIfRequired(vfsOverlay.getPath(), converter));
        commandLine.addParameter("--export-fixes=" + ClazyAnnotator.fixWslPathIfRequired(outputFile.getPath(), converter));
        commandLine.addParameter("--ignore-included-files");
        commandLine.addParameter(ClazyAnnotator.fixWslPathIfRequired(inputFile.getAbsolutePath(), converter));
        if (converter.isWslMode() && wslDistribution != null) {
            commandLine = wslDistribution.patchCommandLine(commandLine, info.getProject(), new WSLCommandLineOptions());
        }
        if (ClazyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCommandLine(commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClazyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document2.getModificationStamp()) {
            return null;
        }
        if (progressIndicator != null) {
            processHandler.runProcessWithProgressIndicator(progressIndicator);
        } else {
            processHandler.runProcess();
        }
        if (ClazyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setOutput(outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, (Object)debugInfoBuilder.build());
        }
        List diagnostics = outputFile.exists() ? ClazyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping, converter) : Collections.emptyList();
        diagnostics = ContainerUtil.filter(diagnostics, diagnostic -> diagnostic.getDiagnosticName().startsWith("clazy-"));
        return ClangTidyAnnotationHolder.success(diagnostics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        if (info == null) {
            return null;
        }
        ClazyAnnotator.tryRegisterDocumentListener(info);
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"clion-clazy", null, (boolean)true);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = this.executeClazy(info, workingDirectory);
            return clangTidyAnnotationHolder;
        }
        catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
            LOG.warn(exc);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotationHolder.error(exc.getMessage());
            return clangTidyAnnotationHolder;
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    private static List<ClangTidyDiagnostic> convertClazyDiags(List<ClangDiagnostic> clangDiagnostics, CharSequence text, String inputFilename) {
        ArrayList<ClangTidyDiagnostic> diagnostics = new ArrayList<ClangTidyDiagnostic>();
        for (ClangDiagnostic diag : clangDiagnostics) {
            int endOffset;
            ArrayList<ClangTidyRange> tidyRanges = new ArrayList<ClangTidyRange>();
            ArrayList<ClangTidyReplacement> tidyReplacements = new ArrayList<ClangTidyReplacement>();
            int offset = StringUtil.lineColToOffset((CharSequence)text, (int)diag.getStartLine(), (int)diag.getStartColumn());
            if (offset < 0) {
                offset = text.length() - 1;
            }
            if ((endOffset = StringUtil.lineColToOffset((CharSequence)text, (int)diag.getEndLine(), (int)diag.getEndColumn())) < 0) {
                endOffset = text.length() - 1;
            }
            tidyRanges.add(new ClangTidyRange(inputFilename, offset, endOffset - offset));
            for (CodeAction fixit : diag.getClangdFixits()) {
                Map changes = fixit.getEdit().getChanges();
                for (String url : changes.keySet()) {
                    String path = VfsUtilCore.urlToPath((String)url);
                    List edits = (List)changes.get(url);
                    for (TextEdit edit : edits) {
                        Position start = edit.getRange().getStart();
                        Position end = edit.getRange().getEnd();
                        int fixitStartOffset = StringUtil.lineColToOffset((CharSequence)text, (int)start.getLine(), (int)start.getCharacter());
                        int fixitEndOffset = StringUtil.lineColToOffset((CharSequence)text, (int)end.getLine(), (int)end.getCharacter());
                        if (fixitStartOffset < 0) {
                            fixitStartOffset = text.length() - 1;
                        }
                        if (fixitEndOffset < 0) {
                            fixitEndOffset = text.length() - 1;
                        }
                        ClangTidyReplacement tidyReplacement = new ClangTidyReplacement(path, edit.getNewText(), fixitStartOffset, fixitEndOffset);
                        tidyReplacements.add(tidyReplacement);
                    }
                }
            }
            String clazyMessage = diag.getMessage();
            int clazyDiagNameStart = clazyMessage.indexOf("-Wclazy");
            if (clazyDiagNameStart < 0) continue;
            int clazyDiagNameEnd = clazyMessage.indexOf("]", clazyDiagNameStart);
            ClangTidyDiagnostic tidyDiag = new ClangTidyDiagnostic(clazyMessage.substring(0, clazyDiagNameStart - 1).trim(), clazyMessage.substring(clazyDiagNameStart, clazyDiagNameEnd), inputFilename, offset, tidyRanges, tidyReplacements, null);
            diagnostics.add(tidyDiag);
        }
        return diagnostics;
    }

    @NotNull
    public static File getBuiltinClazyPath() {
        File file = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clazy-standalone.exe" : "clazy-standalone");
        if (file == null) {
            ClazyAnnotator.$$$reportNull$$$0(4);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClazyAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClazyAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClazyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "useLanguageService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeClazy";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

