/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidySuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String myCheckName;
    private final boolean mySuppressAliases;
    @NotNull
    private static final Pattern NOLINT_ARGS_PATTERN = Pattern.compile(".*NOLINT\\s*\\((.*)\\).*");
    @NotNull
    private static final Pattern NOLINTNEXTLINE_ARGS_PATTERN = Pattern.compile(".*NOLINTNEXTLINE\\s*\\((.*)\\).*");
    @NotNull
    private static final Pattern COMMENT_PATTERN = Pattern.compile(".*?(///?.*)|(/\\*.*)$");
    private static final Logger LOG = Logger.getInstance(ClangTidySuppressIntentionAction.class);

    public ClangTidySuppressIntentionAction(@NotNull String checkName, boolean suppressAliases) {
        if (checkName == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(0);
        }
        this.myCheckName = suppressAliases ? "*-" + CommonClangTidyUtil.getCheckNameWithoutGroup(checkName) : checkName;
        this.mySuppressAliases = suppressAliases;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TextRange prevLineTextRange;
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        Document document2 = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        int offset = editor.getCaretModel().getOffset();
        int lineNumber = document2.getLineNumber(offset);
        TextRange currLineTextRange = DocumentUtil.getLineTextRange((Document)document2, (int)lineNumber);
        TextRange textRange = prevLineTextRange = lineNumber > 0 ? DocumentUtil.getLineTextRange((Document)document2, (int)(lineNumber - 1)) : null;
        if (this.tryModifyComment(currLineTextRange, NOLINT_ARGS_PATTERN, file, document2, project)) {
            return;
        }
        if (prevLineTextRange != null && this.tryModifyComment(prevLineTextRange, NOLINTNEXTLINE_ARGS_PATTERN, file, document2, project)) {
            return;
        }
        Matcher commentMatcher = COMMENT_PATTERN.matcher(document2.getText(currLineTextRange));
        if (commentMatcher.find()) {
            boolean isEolTodoComment;
            boolean isEolComment = commentMatcher.group(1) != null;
            boolean isDoxygenComment = isEolComment && commentMatcher.group(1).startsWith("///");
            boolean bl = isEolTodoComment = isEolComment && StringUtil.containsIgnoreCase((String)commentMatcher.group(1), (String)"todo");
            if (!isEolComment || isDoxygenComment || isEolTodoComment) {
                ClangTidySuppressIntentionAction.insertNoLintNextLineComment("//NOLINTNEXTLINE(" + this.myCheckName + ")", prevLineTextRange, currLineTextRange, document2, file, project);
                return;
            }
            ClangTidySuppressIntentionAction.insertNoLintComment(" NOLINT(" + this.myCheckName + ")", currLineTextRange.getEndOffset(), file, project);
        } else {
            ClangTidySuppressIntentionAction.insertNoLintComment(" // NOLINT(" + this.myCheckName + ")", currLineTextRange.getEndOffset(), file, project);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        int offset;
        int lineNumber;
        TextRange lineTextRange;
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(4);
        }
        if (editor == null || !element.isValid()) {
            return false;
        }
        Document document2 = editor.getDocument();
        String lineText = document2.getText(lineTextRange = DocumentUtil.getLineTextRange((Document)document2, (int)(lineNumber = document2.getLineNumber(offset = element.getTextOffset()))));
        return !lineText.endsWith("\\");
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = ClangdBundle.message("inspection.clangTidy.suppress.for.line", new Object[0]);
        if (string == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = ClangdBundle.message("inspection.clangTidy.suppress.check.for.line", StringUtil.wrapWithDoubleQuote((String)this.myCheckName));
        if (string == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private boolean tryModifyComment(@NotNull TextRange lineTextRange, @NotNull Pattern noLintPattern, @NotNull PsiFile file, @NotNull Document document2, @NotNull Project project) {
        Matcher commentMatcher;
        if (lineTextRange == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(7);
        }
        if (noLintPattern == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(11);
        }
        if (!(commentMatcher = COMMENT_PATTERN.matcher(document2.getText(lineTextRange))).find()) {
            return false;
        }
        boolean isEolComment = commentMatcher.group(1) != null;
        int groupToTake = isEolComment ? 1 : 2;
        String commentText = commentMatcher.group(groupToTake);
        Matcher noLineMatcher = noLintPattern.matcher(commentText);
        if (!noLineMatcher.find()) {
            return false;
        }
        String oldCheckNameList = noLineMatcher.group(1);
        String checkNameListWithoutAliases = this.filterChecks(oldCheckNameList);
        int startOffset = lineTextRange.getStartOffset() + commentMatcher.start(groupToTake) + noLineMatcher.start(1);
        ClangTidySuppressIntentionAction.replaceNoLintComment((String)(checkNameListWithoutAliases.trim().isEmpty() ? this.myCheckName : checkNameListWithoutAliases + ", " + this.myCheckName), startOffset, startOffset + oldCheckNameList.length(), file, project);
        return true;
    }

    @NotNull
    private String filterChecks(@NotNull String oldCheckNameList) {
        if (oldCheckNameList == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(12);
        }
        ArrayList<String> newCheckList = new ArrayList<String>();
        String checkToSuppress = CommonClangTidyUtil.getCheckNameWithoutGroup(this.myCheckName);
        for (String oldCheckName : StringUtil.split((String)oldCheckNameList, (String)",")) {
            String oldCheckNameTrim = oldCheckName.trim();
            if (this.mySuppressAliases && oldCheckNameTrim.endsWith(checkToSuppress)) continue;
            newCheckList.add(oldCheckNameTrim);
        }
        String string = StringUtil.join(newCheckList, (String)", ");
        if (string == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void insertNoLintNextLineComment(@NotNull String comment, @Nullable TextRange prevLineTextRange, @NotNull TextRange currLineTextRange, @NotNull Document document2, @NotNull PsiFile file, @NotNull Project project) {
        if (comment == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(14);
        }
        if (currLineTextRange == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(15);
        }
        if (document2 == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(18);
        }
        String indent = StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)project).getLineIndent(document2, currLineTextRange.getStartOffset()));
        if (prevLineTextRange != null) {
            ClangTidySuppressIntentionAction.insertNoLintComment("\n" + indent + comment, prevLineTextRange.getEndOffset(), file, project);
        } else {
            ClangTidySuppressIntentionAction.insertNoLintComment(indent + comment + "\n", currLineTextRange.getStartOffset(), file, project);
        }
    }

    private static void insertNoLintComment(@NotNull String comment, int startOffset, @NotNull PsiFile file, @NotNull Project project) {
        if (comment == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(21);
        }
        ClangTidySuppressIntentionAction.replaceNoLintComment(comment, startOffset, startOffset, file, project);
    }

    private static void replaceNoLintComment(@NotNull String comment, int startOffset, int endOffset, @NotNull PsiFile file, @NotNull Project project) {
        Document document2;
        if (comment == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(22);
        }
        if (file == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(24);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file)) == null || !file.isValid()) {
            LOG.error("Can't insert nolint comment: document is null (" + (document2 == null) + "), file.isValid (" + file.isValid() + ")");
            return;
        }
        document2.replaceString(startOffset, endOffset, (CharSequence)comment);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidySuppressIntentionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineTextRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLintPattern";
                break;
            }
            case 9: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCheckNameList";
                break;
            }
            case 14: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currLineTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidySuppressIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChecks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryModifyComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterChecks";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertNoLintNextLineComment";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertNoLintComment";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replaceNoLintComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13 -> new IllegalStateException(string);
        };
    }
}

