/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangTidyFileUtils {
    @NonNls
    public static final String CLANG_TIDY = ".clang-tidy";

    @Nullable
    public static File findNearestClangTidyFile(@NotNull File sourceFile, @NotNull Project project) {
        ClangTidyFilesState state;
        if (sourceFile == null) {
            ClangTidyFileUtils.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangTidyFileUtils.$$$reportNull$$$0(1);
        }
        return (state = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class)) != null ? state.findNearestClangTidyFile(sourceFile) : null;
    }

    public static boolean createClangTidyFileInDirectory(@NotNull Project project) {
        if (project == null) {
            ClangTidyFileUtils.$$$reportNull$$$0(2);
        }
        VirtualFile directory = project.getBaseDir();
        try {
            if (directory == null) {
                return false;
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                VirtualFile vfClangTidy = directory.createChildData((Object)project, CLANG_TIDY);
                vfClangTidy.setCharset(StandardCharsets.UTF_8);
                ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, project);
                VfsUtil.saveText((VirtualFile)vfClangTidy, (String)ClangTidyFileUtils.convertChecksToClangTidy(inspection != null ? inspection.getClangTidyChecks() : ""));
                ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)project).openFile(vfClangTidy, true), project.getDisposed());
            });
        }
        catch (Throwable e) {
            if (e.getCause() instanceof FileAlreadyExistsException) {
                return false;
            }
            ExceptionUtil.rethrow((Throwable)e);
        }
        return true;
    }

    public static String convertChecksToClangTidy(@NotNull String clangTidyChecks) {
        if (clangTidyChecks == null) {
            ClangTidyFileUtils.$$$reportNull$$$0(3);
        }
        return "# Generated from CLion Inspection settings\n---\nChecks: '" + clangTidyChecks.replace(",", ",\n") + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyChecks";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyFileUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findNearestClangTidyFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createClangTidyFileInDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convertChecksToClangTidy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

