/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ui.ClangdIndexerWidgetFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ui.ClangdIndexerWidgetKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ui.IndexerListPopupStep;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ui.IndexerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ui.PopupAction;
import icons.CidrLangIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ui/ClangdIndexerWidget;", "Lcom/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "indexerServiceFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "indexerStateFlow", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ui/IndexerState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "ID", "", "createToolTipText", "getComponent", "Ljavax/swing/JComponent;", "state", "update", "", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "intellij.c.clangd"})
final class ClangdIndexerWidget
extends TextPanel.WithIconAndArrows
implements CustomStatusBarWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<ClangdIndexerService> indexerServiceFlow;
    @NotNull
    private final MutableStateFlow<IndexerState> indexerStateFlow;

    public ClangdIndexerWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.indexerServiceFlow = StateFlowKt.MutableStateFlow(null);
        Icon icon = CidrLangIcons.ClangdIndexerReady;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ClangdIndexerReady");
        this.indexerStateFlow = StateFlowKt.MutableStateFlow((Object)new IndexerState(null, 0.0, icon, false));
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        if (clangLanguageServiceProvider != null) {
            ClangLanguageServiceProvider it = clangLanguageServiceProvider;
            boolean bl = false;
            this.indexerServiceFlow.tryEmit((Object)((ClangdIndexerService)it.getIfStartedIndexer()));
        }
        ClangLanguageServiceProviderListener providerListener2 = new ClangLanguageServiceProviderListener(this){
            final /* synthetic */ ClangdIndexerWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceStarted(@NotNull ClangLanguageService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                if (service.isIndexer()) {
                    ClangdIndexerWidget.access$getIndexerServiceFlow$p(this.this$0).tryEmit((Object)((ClangdIndexerService)service));
                }
            }

            public void onServiceStopped(@NotNull ClangLanguageService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                if (service.isIndexer()) {
                    ClangdIndexerWidget.access$getIndexerServiceFlow$p(this.this$0).tryEmit(null);
                }
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<ClangLanguageServiceProviderListener> topic = ClangLanguageServiceProviderListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)providerListener2);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClangdIndexerWidget this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.indexerServiceFlow), (Function2)((Function2)new Function2<ClangdIndexerService, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ ClangdIndexerWidget this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ClangdIndexerService it;
                                        ResultKt.throwOnFailure((Object)object);
                                        ClangdIndexerService clangdIndexerService = it = (ClangdIndexerService)this.L$0;
                                        if (clangdIndexerService != null) {
                                            ClangdIndexerService clangdIndexerService2 = clangdIndexerService;
                                            ClangdIndexerWidget clangdIndexerWidget = this.this$0;
                                            ClangdIndexerService service = clangdIndexerService2;
                                            boolean bl = false;
                                            MessageBus messageBus = service.getMessageBus();
                                            Disposable disposable = service.getAssociatedDisposable();
                                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getAssociatedDisposable(...)");
                                            MessageBusConnection messageBusConnection = messageBus.connect(disposable);
                                            Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
                                            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                                            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000=\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\f\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"com/jetbrains/cidr/lang/daemon/clang/clangd/ui/ClangdIndexerWidget$IndexerServerListener", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerListener;", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ui/ClangdIndexerWidget;Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;)V", "getService", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "onIndexingCanceled", "", "onIndexingFinished", "deletedSymbolsPaths", "", "", "symbolsDirPath", "onIndexingProgress", "percentage", "", "message", "Lcom/intellij/openapi/util/NlsSafe;", "onIndexingStarted", "taskId", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangdIndexingTaskId;", "onServerFailure", "onServerShutDown", "intellij.c.clangd"})
                                            public final class IndexerServerListener
                                            implements ClangServerListener {
                                                @NotNull
                                                private final ClangdIndexerService service;
                                                final /* synthetic */ ClangdIndexerWidget this$0;

                                                public IndexerServerListener(@NotNull ClangdIndexerWidget $receiver, @NotNull ClangdIndexerService service) {
                                                    Intrinsics.checkNotNullParameter((Object)((Object)$receiver), (String)"this$0");
                                                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                                                    this.this$0 = $receiver;
                                                    this.service = service;
                                                }

                                                @NotNull
                                                public final ClangdIndexerService getService() {
                                                    return this.service;
                                                }

                                                @Override
                                                public void onServerFailure() {
                                                    boolean bl;
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextTask(null));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(null) = " + it + ", event onServerFailure");
                                                    }
                                                }

                                                @Override
                                                public void onServerShutDown() {
                                                    boolean bl;
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextTask(null));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(null) = " + it + ", event onServerShutDown");
                                                    }
                                                }

                                                @Override
                                                public void onIndexingCanceled() {
                                                    boolean bl;
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextTask(null));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(null) = " + it + ", event onIndexingCanceled");
                                                    }
                                                }

                                                @Override
                                                public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                                                    boolean bl;
                                                    Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextTask(taskId));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(" + taskId + ") = " + it + ", event onIndexingStarted");
                                                    }
                                                }

                                                @Override
                                                public void onIndexingProgress(int percentage, @NotNull String message) {
                                                    boolean bl;
                                                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextPercent(percentage));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(" + percentage + ") = " + it + ", event onIndexingProgress");
                                                    }
                                                }

                                                @Override
                                                public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                                                    boolean bl;
                                                    Intrinsics.checkNotNullParameter(deletedSymbolsPaths, (String)"deletedSymbolsPaths");
                                                    Intrinsics.checkNotNullParameter((Object)symbolsDirPath, (String)"symbolsDirPath");
                                                    boolean it = bl = this.this$0.indexerStateFlow.tryEmit((Object)this.this$0.state().nextTask(null));
                                                    boolean bl2 = false;
                                                    if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                        ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextTask(null) = " + it + ", event onIndexingFinished");
                                                    }
                                                }
                                            }
                                            messageBusConnection.subscribe(topic, (Object)new IndexerServerListener(clangdIndexerWidget, service));
                                            service.addPausedListener(arg_0 -> 1.invokeSuspend$lambda$2$lambda$1(clangdIndexerWidget, arg_0));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@Nullable ClangdIndexerService p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$2$lambda$1(ClangdIndexerWidget this$0, Boolean paused) {
                                boolean bl;
                                MutableStateFlow mutableStateFlow = this$0.indexerStateFlow;
                                IndexerState indexerState = this$0.state();
                                Intrinsics.checkNotNull((Object)paused);
                                boolean it = bl = mutableStateFlow.tryEmit((Object)indexerState.nextPaused(paused));
                                boolean bl2 = false;
                                if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                    ClangdIndexerWidgetKt.access$getLOG$p().trace("emit nextPaused(" + paused + ") = " + it + ", event onPaused");
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
        if (statusBar != null) {
            StatusBar statusBar2 = statusBar;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, statusBar2, null){
                int label;
                final /* synthetic */ ClangdIndexerWidget this$0;
                final /* synthetic */ StatusBar $statusBar;
                {
                    this.this$0 = $receiver;
                    this.$statusBar = $statusBar;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)ClangdIndexerWidget.access$getIndexerStateFlow$p(this.this$0)), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<IndexerState, Continuation<? super Unit>, Object>(this.this$0, this.$statusBar, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ ClangdIndexerWidget this$0;
                                final /* synthetic */ StatusBar $statusBar;
                                {
                                    this.this$0 = $receiver;
                                    this.$statusBar = $statusBar;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            IndexerState it = (IndexerState)this.L$0;
                                            if (ClangdIndexerWidgetKt.access$getLOG$p().isTraceEnabled()) {
                                                Icon icon = it.getIcon();
                                                String iconName = Intrinsics.areEqual((Object)icon, (Object)CidrLangIcons.ClangdIndexerReady) ? "ready" : (Intrinsics.areEqual((Object)icon, (Object)CidrLangIcons.ClangdIndexerInProgress) ? "in_progress" : (Intrinsics.areEqual((Object)icon, (Object)CidrLangIcons.ClangdIndexerOff) ? "off" : "unknown"));
                                                ClangdIndexerWidgetKt.access$getLOG$p().trace("New indexer state: task=" + it.getTask() + ", percent=" + it.getPercentage() + ", icon=" + iconName + ", paused=" + it.getPaused());
                                            }
                                            ClangdIndexerWidget.access$update(this.this$0, this.$statusBar, it);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull IndexerState p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List actions = new ArrayList();
                ClangdIndexerService service = (ClangdIndexerService)indexerServiceFlow.getValue();
                actions.add(PopupAction.clear_caches_and_rebuild);
                ClangdIndexerService clangdIndexerService = service;
                actions.add((clangdIndexerService != null ? clangdIndexerService.isPaused() : false) ? PopupAction.unpause : PopupAction.pause);
                actions.add(PopupAction.settings);
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new IndexerListPopupStep(this.getProject(), this.getScope(), service, (MutableStateFlow<IndexerState>)indexerStateFlow, actions));
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
                ListPopup popup = listPopup;
                Object object = event.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
                Component source = (Component)object;
                Dimension dimension = popup.getContent().getPreferredSize();
                Point at = new Point(0, -dimension.height);
                popup.show(new RelativePoint(source, at));
                return true;
            }
        }.installOn((Component)((Object)this), true);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public String ID() {
        return ClangdIndexerWidgetFactory.Constants.getID();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this);
    }

    private final void update(StatusBar statusBar, IndexerState state) {
        this.setText(ClangdBundle.message("clangd.indexer.widget.name", new Object[0]));
        this.setToolTipText(this.createToolTipText());
        this.setIcon(state.getPaused() ? CidrLangIcons.ClangdIndexerOff : state.getIcon());
        statusBar.updateWidget(ClangdIndexerWidgetFactory.Constants.getID());
    }

    @NlsSafe
    @NotNull
    public final String createToolTipText() {
        HtmlBuilder tooltip = new HtmlBuilder();
        ClangdIndexerService indexer = (ClangdIndexerService)this.indexerServiceFlow.getValue();
        if (indexer != null) {
            ClangMemoryUsageWatchDog clangMemoryUsageWatchDog = indexer.getMemoryUsageWatchDog();
            Intrinsics.checkNotNullExpressionValue((Object)clangMemoryUsageWatchDog, (String)"getMemoryUsageWatchDog(...)");
            ClangMemoryUsageWatchDog memoryUsage = clangMemoryUsageWatchDog;
            Object[] objectArray = new Object[]{memoryUsage.getCurrentMemory() / (long)0x100000, memoryUsage.getMaxMemory() / (long)0x100000, memoryUsage.getUsedMaxMemory() / (long)0x100000};
            tooltip.append(ClangdBundle.message("clangd.indexer.memory.usage.tooltip.message", objectArray));
            tooltip.br();
            IndexerState curState = this.state();
            if (curState.getTask() != null) {
                int percent = (int)curState.getPercentage();
                ClangdIndexingTaskId clangdIndexingTaskId = curState.getTask();
                switch (clangdIndexingTaskId == null ? -1 : WhenMappings.$EnumSwitchMapping$0[clangdIndexingTaskId.ordinal()]) {
                    case 1: {
                        Object[] objectArray2 = new Object[]{percent};
                        tooltip.append(ClangdBundle.message("clangd.indexer.progress.preprocessing.message", objectArray2));
                        break;
                    }
                    case 2: {
                        Object[] objectArray3 = new Object[]{percent};
                        tooltip.append(ClangdBundle.message("clangd.indexer.progress.indexing.message", objectArray3));
                    }
                }
            } else {
                ClangdIndexerService service;
                ClangdIndexerService clangdIndexerService = service = (ClangdIndexerService)this.indexerServiceFlow.getValue();
                tooltip.append(ClangdBundle.message((clangdIndexerService != null ? clangdIndexerService.isPaused() : false) ? "clangd.indexer.paused.message" : "clangd.indexer.ready.message", new Object[0]));
            }
        } else {
            tooltip.append(ClangdBundle.message("clangd.indexer.off.message", new Object[0]));
        }
        String string = tooltip.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final IndexerState state() {
        return (IndexerState)this.indexerStateFlow.getValue();
    }

    public static final /* synthetic */ void access$update(ClangdIndexerWidget $this, StatusBar statusBar, IndexerState state) {
        $this.update(statusBar, state);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClangdIndexingTaskId.values().length];
            try {
                nArray[ClangdIndexingTaskId.preprocessing.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClangdIndexingTaskId.indexing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

