/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003B+\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0005\u0012\b\b\u0001\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0005H$J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/SetClangdProjectData;", "T", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "actionText", "", "actionIcon", "Ljavax/swing/Icon;", "dialogMessage", "dialogTitle", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;)V", "getActionText", "()Ljava/lang/String;", "getDialogMessage", "getDialogTitle", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "askAndSet", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "project", "Lcom/intellij/openapi/project/Project;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "getValue", "isToggled", "", "setValue", "text", "update", "intellij.c.clangd"})
public abstract class SetClangdProjectData<T>
extends DumbAwareAction
implements Toggleable {
    @NotNull
    private final String actionText;
    @NotNull
    private final Icon actionIcon;
    @NotNull
    private final String dialogMessage;
    @NotNull
    private final String dialogTitle;

    public SetClangdProjectData(@NlsSafe @NotNull String actionText, @NotNull Icon actionIcon, @NlsSafe @NotNull String dialogMessage, @NlsSafe @NotNull String dialogTitle) {
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter((Object)actionIcon, (String)"actionIcon");
        Intrinsics.checkNotNullParameter((Object)dialogMessage, (String)"dialogMessage");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this.actionText = actionText;
        this.actionIcon = actionIcon;
        this.dialogMessage = dialogMessage;
        this.dialogTitle = dialogTitle;
    }

    @NotNull
    public final String getActionText() {
        return this.actionText;
    }

    @NotNull
    public final String getDialogMessage() {
        return this.dialogMessage;
    }

    @NotNull
    public final String getDialogTitle() {
        return this.dialogTitle;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.askAndSet(e);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.isToggled(e));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setText(this.actionText);
        e.getPresentation().setIcon(this.actionIcon);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.isToggled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final void askAndSet(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        String current = this.getValue(project2, dataContext);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        String string = Messages.showInputDialog((Project)project2, (String)this.dialogMessage, (String)this.getDialogTitle(project2, dataContext2), (Icon)AllIcons.Actions.Annotate, (String)current, null);
        if (string == null) {
            return;
        }
        String newPath2 = string;
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        this.setValue(project2, dataContext3, newPath2);
    }

    private final boolean isToggled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return !(((CharSequence)this.getValue(project2, dataContext)).length() == 0);
    }

    @NotNull
    protected String getDialogTitle(@NotNull Project project, @NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        return this.dialogTitle;
    }

    @NotNull
    protected abstract String getValue(@NotNull Project var1, @NotNull DataContext var2);

    protected abstract void setValue(@NotNull Project var1, @NotNull DataContext var2, @NotNull String var3);
}

