/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangIndexerCustomCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdDumpIndexerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexAppState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexOptsState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexViewerState;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JI\u0010\u001e\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032)\u0010\"\u001a%\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0013\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010&0#H\u0002J\u0006\u0010'\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "isStateful", "", "(Lcom/intellij/openapi/project/Project;Z)V", "indexAppState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "indexOptsState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexOptsState;", "indexViewerState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexViewerState;", "()Z", "queryRunning", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "connectToService", "", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "lspView", "Lcom/intellij/execution/ui/ConsoleView;", "appView", "createAppLog", "Lkotlin/Pair;", "Lcom/intellij/openapi/ui/DialogPanel;", "createIndexViewer", "createLspLog", "getIfStartedIndexer", "runQuery", "T", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "query", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "selectIndexerOpts", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdIndexerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdIndexerPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,652:1\n37#2,2:653\n1#3:655\n2661#4,7:656\n*S KotlinDebug\n*F\n+ 1 ClangdIndexerPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel\n*L\n165#1:653,2\n390#1:656,7\n*E\n"})
public final class ClangdIndexerPanel
extends ClangdPanelBase {
    private final boolean isStateful;
    @NotNull
    private final IndexViewerState indexViewerState;
    @NotNull
    private final IndexAppState indexAppState;
    @NotNull
    private final IndexOptsState indexOptsState;
    @NotNull
    private final JBTabbedPane tabbedPane;
    private volatile boolean queryRunning;

    public ClangdIndexerPanel(final @NotNull Project project, boolean isStateful) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.isStateful = isStateful;
        this.indexViewerState = new IndexViewerState(null, false, null, 7, null);
        this.indexAppState = new IndexAppState(null, null, null, 0, 15, null);
        this.indexOptsState = new IndexOptsState(null, 1, null);
        this.indexAppState.setIndexerModulesCacheMb(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        this.tabbedPane = (JBTabbedPane)new TabbedPaneImpl(1);
        this.add((Component)this.tabbedPane);
        final ConsoleView lspConsoleView = this.createLspLog(project);
        this.tabbedPane.add("LSP Log", (Component)lspConsoleView.getComponent());
        Pair<DialogPanel, ConsoleView> pair = this.createAppLog(project);
        DialogPanel appPanel2 = (DialogPanel)pair.component1();
        final ConsoleView appConsoleView = (ConsoleView)pair.component2();
        this.tabbedPane.add("App Log", (Component)appPanel2);
        this.indexAppState.setAppPanel(appPanel2);
        this.indexAppState.setAppConsoleView(appConsoleView);
        this.indexViewerState.setIndexViewer(this.createIndexViewer(project));
        this.tabbedPane.add("Index Viewer", (Component)this.indexViewerState.getIndexViewer());
        this.indexOptsState.setIndexOptsPanel(ClangdIndexerPanelKt.access$createIndexOptionsPanel(project));
        this.tabbedPane.add("Index Opts", (Component)this.indexOptsState.getIndexOptsPanel());
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic<ClangLanguageServiceProviderListener> topic = ClangLanguageServiceProviderListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangLanguageServiceProviderListener(){

            @Override
            public void onServiceStarted(@NotNull ClangLanguageService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                if (Intrinsics.areEqual((Object)service.getDescriptor(), (Object)"indexer")) {
                    this.connectToService(service, lspConsoleView, appConsoleView);
                }
            }
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect();
        Topic<ClangdSettingsListener> topic2 = ClangdSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new ClangdSettingsListener(){

            @Override
            public void onIndexerOptimizeIncludeGraphChanged(boolean value) {
                ClangdIndexerPanelKt.access$runIndexerCommand(project, appConsoleView, this.isStateful(), ClangIndexerCommand.Companion.OPTIMIZE_INCLUDE_GRAPH(value));
            }
        });
        this.connectToService(this.getIfStartedIndexer(project), lspConsoleView, appConsoleView);
        AnAction[] anActionArray = new AnAction[]{new ClangdDumpIndexerState(this.isStateful)};
        this.createToolbarWithActions(anActionArray);
    }

    public final boolean isStateful() {
        return this.isStateful;
    }

    public final void selectIndexerOpts() {
        this.tabbedPane.setSelectedComponent((Component)this.indexOptsState.getIndexOptsPanel());
    }

    private final ConsoleView createLspLog(Project project) {
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView lspConsoleView = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)lspConsoleView));
        ConsoleViewImpl consoleViewImpl = lspConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)lspConsoleView : null;
        EditorSettings editorSettings = consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null ? consoleViewImpl.getSettings() : null;
        if (editorSettings != null) {
            editorSettings.setUseSoftWraps(false);
        }
        TextAttributes methodHighlightAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Pattern methodPattern = Pattern.compile("\"method\": \"(.*?)\"");
        lspConsoleView.addMessageFilter((arg_0, arg_1) -> ClangdIndexerPanel.createLspLog$lambda$0(methodPattern, methodHighlightAttrs, arg_0, arg_1));
        return lspConsoleView;
    }

    private final Pair<DialogPanel, ConsoleView> createAppLog(Project project) {
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView appConsoleView = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)appConsoleView));
        ConsoleViewImpl consoleViewImpl = appConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)appConsoleView : null;
        EditorSettings editorSettings = consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null ? consoleViewImpl.getSettings() : null;
        if (editorSettings != null) {
            editorSettings.setUseSoftWraps(false);
        }
        int coresNumber = Runtime.getRuntime().availableProcessors();
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((Iterable)new IntRange(0, coresNumber)));
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultComboBoxModel<Integer> indexingThreadsModel = new DefaultComboBoxModel<Integer>(thisCollection$iv.toArray(new Integer[0]));
        indexingThreadsModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexingThreadsNum());
        indexingThreadsModel.addListDataListener(new ListDataListener(indexingThreadsModel, this, project, appConsoleView){
            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$indexingThreadsModel = $indexingThreadsModel;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$appConsoleView = $appConsoleView;
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                Object object = this.$indexingThreadsModel.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int newThreadsNum = (Integer)object;
                if (this.this$0.isStateful()) {
                    ClangdSettings.getInstance(this.$project).setIndexingThreadsNum(newThreadsNum);
                }
                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.SET_PP_THREADS(newThreadsNum));
                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.SET_INDEXING_THREADS(newThreadsNum));
            }
        });
        int[] $i$f$toTypedArray22 = new int[]{0, 500, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000};
        DefaultComboBoxModel<Integer> modulesCacheModel = new DefaultComboBoxModel<Integer>(ArraysKt.toTypedArray((int[])$i$f$toTypedArray22));
        modulesCacheModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        modulesCacheModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(@Nullable ListDataEvent e) {
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
            }
        });
        DialogPanel appPanel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(project, indexingThreadsModel, modulesCacheModel, this, appConsoleView){
            final /* synthetic */ Project $project;
            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
            final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$project = $project;
                this.$indexingThreadsModel = $indexingThreadsModel;
                this.$modulesCacheModel = $modulesCacheModel;
                this.this$0 = $receiver;
                this.$appConsoleView = $appConsoleView;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$project, this.$indexingThreadsModel, this.$modulesCacheModel, this.this$0, this.$appConsoleView){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
                    final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.$project = $project;
                        this.$indexingThreadsModel = $indexingThreadsModel;
                        this.$modulesCacheModel = $modulesCacheModel;
                        this.this$0 = $receiver;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.button("Clear Caches", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.getCLEAR_CACHES());
                            }
                        }).gap(RightGap.SMALL);
                        $this$row.button("Rebuild", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.getREBUILD());
                            }
                        }).gap(RightGap.SMALL);
                        $this$row.button("Reindex", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.getREINDEX());
                            }
                        }).gap(RightGap.SMALL);
                        $this$row.button("Cancel", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.getCANCEL());
                            }
                        }).gap(RightGap.SMALL);
                        Cell cell = $this$row.button("Pause", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ClangLanguageService clangLanguageService = ClangdIndexerPanel.access$getIfStartedIndexer(this.this$0, this.$project);
                                ClangdIndexerService clangdIndexerService = clangLanguageService instanceof ClangdIndexerService ? (ClangdIndexerService)clangLanguageService : null;
                                boolean isUnpause = clangdIndexerService != null ? clangdIndexerService.isPaused() : false;
                                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), isUnpause ? ClangIndexerCommand.Companion.getRESUME() : ClangIndexerCommand.Companion.getPAUSE());
                            }
                        }).gap(RightGap.SMALL);
                        ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                        Cell it = cell;
                        boolean bl = false;
                        ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).setPauseButton((JButton)it.getComponent());
                        $this$row.button("Custom", (Function1)new Function1<ActionEvent, Unit>(this.$project, this.this$0){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            {
                                this.$project = $project;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                new ClangIndexerCustomCommandDialog(this.$project, ClangdIndexerPanel.access$getIndexAppState$p(this.this$0), this.this$0.isStateful()).show();
                            }
                        });
                        ButtonKt.selected((Cell)$this$row.checkBox("Skip function bodies"), (boolean)ClangdSettings.getInstance(this.$project).getIndexerSkipBodies()).gap(RightGap.SMALL).onChanged((Function1)new Function1<JBCheckBox, Unit>($this$row, this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ Row $this_row;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.$this_row = $this_row;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox cb) {
                                Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
                                Row row = this.$this_row;
                                ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                                Project project = this.$project;
                                ConsoleView consoleView = this.$appConsoleView;
                                Row $this$invoke_u24lambda_u241 = row;
                                boolean bl = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newSkipBodies = cb.getModel().isSelected();
                                if (clangdIndexerPanel.isStateful()) {
                                    ClangdSettings.getInstance(project).setIndexerSkipBodies(newSkipBodies);
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(project, consoleView, clangdIndexerPanel.isStateful(), ClangIndexerCommand.Companion.SET_SKIP_BODIES(newSkipBodies)).thenAccept(arg_0 -> createAppLog.appPanel.8.invoke$lambda$1$lambda$0((Function1)new Function1<Boolean, Unit>(clangdIndexerPanel, project, newSkipBodies, cb){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newSkipBodies;
                                    final /* synthetic */ JBCheckBox $cb;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$newSkipBodies = $newSkipBodies;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            if (this.this$0.isStateful()) {
                                                ClangdSettings.getInstance(this.$project).setIndexerSkipBodies(!this.$newSkipBodies);
                                            }
                                            this.$cb.getModel().setSelected(!this.$newSkipBodies);
                                        }
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        });
                        ButtonKt.selected((Cell)$this$row.checkBox("Skip implicit instantiations"), (boolean)ClangdSettings.getInstance(this.$project).getIndexerSkipImplicitInstantiations()).gap(RightGap.SMALL).onChanged((Function1)new Function1<JBCheckBox, Unit>($this$row, this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ Row $this_row;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.$this_row = $this_row;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox cb) {
                                Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
                                Row row = this.$this_row;
                                ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                                Project project = this.$project;
                                ConsoleView consoleView = this.$appConsoleView;
                                Row $this$invoke_u24lambda_u241 = row;
                                boolean bl = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newSkipII = cb.getModel().isSelected();
                                if (clangdIndexerPanel.isStateful()) {
                                    ClangdSettings.getInstance(project).setIndexerSkipImplicitInstantiations(newSkipII);
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(project, consoleView, clangdIndexerPanel.isStateful(), ClangIndexerCommand.Companion.SET_SKIP_IMPLICIT_INSTANTIATIONS(newSkipII)).thenAccept(arg_0 -> createAppLog.appPanel.9.invoke$lambda$1$lambda$0((Function1)new Function1<Boolean, Unit>(clangdIndexerPanel, project, newSkipII, cb){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newSkipII;
                                    final /* synthetic */ JBCheckBox $cb;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$newSkipII = $newSkipII;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            if (this.this$0.isStateful()) {
                                                ClangdSettings.getInstance(this.$project).setIndexerSkipImplicitInstantiations(!this.$newSkipII);
                                            }
                                            this.$cb.getModel().setSelected(!this.$newSkipII);
                                        }
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        });
                        ButtonKt.selected((Cell)$this$row.checkBox("Deprioritize update"), (boolean)ClangdSettings.getInstance(this.$project).getIndexerRestrictUpdatingThreads()).gap(RightGap.SMALL).onChanged((Function1)new Function1<JBCheckBox, Unit>($this$row, this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ Row $this_row;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.$this_row = $this_row;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox cb) {
                                Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
                                Row row = this.$this_row;
                                ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                                Project project = this.$project;
                                ConsoleView consoleView = this.$appConsoleView;
                                Row $this$invoke_u24lambda_u241 = row;
                                boolean bl = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newRUT = cb.getModel().isSelected();
                                if (clangdIndexerPanel.isStateful()) {
                                    ClangdSettings.getInstance(project).setIndexerRestrictUpdatingThreads(newRUT);
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(project, consoleView, clangdIndexerPanel.isStateful(), ClangIndexerCommand.Companion.SET_RESTRICT_UPDATING_THREADS(newRUT)).thenAccept(arg_0 -> createAppLog.appPanel.10.invoke$lambda$1$lambda$0((Function1)new Function1<Boolean, Unit>(clangdIndexerPanel, project, newRUT, cb){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newRUT;
                                    final /* synthetic */ JBCheckBox $cb;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$newRUT = $newRUT;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            if (this.this$0.isStateful()) {
                                                ClangdSettings.getInstance(this.$project).setIndexerRestrictUpdatingThreads(!this.$newRUT);
                                            }
                                            this.$cb.getModel().setSelected(!this.$newRUT);
                                        }
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        });
                        ButtonKt.selected((Cell)$this$row.checkBox("Show debug messages"), (boolean)ClangdSettings.getInstance(this.$project).getIndexerShowDebugMessages()).onChanged((Function1)new Function1<JBCheckBox, Unit>($this$row, this.this$0, this.$project, this.$appConsoleView){
                            final /* synthetic */ Row $this_row;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ConsoleView $appConsoleView;
                            {
                                this.$this_row = $this_row;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$appConsoleView = $appConsoleView;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox cb) {
                                Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
                                Row row = this.$this_row;
                                ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                                Project project = this.$project;
                                ConsoleView consoleView = this.$appConsoleView;
                                Row $this$invoke_u24lambda_u241 = row;
                                boolean bl = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newShowDebugMessages = cb.getModel().isSelected();
                                if (clangdIndexerPanel.isStateful()) {
                                    ClangdSettings.getInstance(project).setIndexerShowDebugMessages(newShowDebugMessages);
                                }
                                ClangdIndexerPanelKt.access$runIndexerCommand(project, consoleView, clangdIndexerPanel.isStateful(), ClangIndexerCommand.Companion.SET_VERBOSE_LOG(newShowDebugMessages)).thenAccept(arg_0 -> createAppLog.appPanel.11.invoke$lambda$1$lambda$0((Function1)new Function1<Boolean, Unit>(clangdIndexerPanel, project, newShowDebugMessages, cb){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newShowDebugMessages;
                                    final /* synthetic */ JBCheckBox $cb;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$newShowDebugMessages = $newShowDebugMessages;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            if (this.this$0.isStateful()) {
                                                ClangdSettings.getInstance(this.$project).setIndexerShowDebugMessages(!this.$newShowDebugMessages);
                                            }
                                            this.$cb.getModel().setSelected(!this.$newShowDebugMessages);
                                        }
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        });
                        Cell.label$default((Cell)ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)this.$indexingThreadsModel, null, (int)2, null), (Function0)((Function0)new Function0<Integer>(this.$indexingThreadsModel){
                            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
                            {
                                this.$indexingThreadsModel = $indexingThreadsModel;
                                super(0);
                            }

                            @Nullable
                            public final Integer invoke() {
                                Object object = this.$indexingThreadsModel.getSelectedItem();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                                return (Integer)object;
                            }
                        }), (Function1)((Function1)new Function1<Integer, Unit>(this.$indexingThreadsModel){
                            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
                            {
                                this.$indexingThreadsModel = $indexingThreadsModel;
                                super(1);
                            }

                            public final void invoke(@Nullable Integer it) {
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
                                this.$indexingThreadsModel.setSelectedItem(it);
                            }
                        })), (String)"Indexing threads:", null, (int)2, null);
                        Cell.label$default((Cell)ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)this.$modulesCacheModel, null, (int)2, null), (Function0)((Function0)new Function0<Integer>(this.$modulesCacheModel){
                            final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
                            {
                                this.$modulesCacheModel = $modulesCacheModel;
                                super(0);
                            }

                            @Nullable
                            public final Integer invoke() {
                                Object object = this.$modulesCacheModel.getSelectedItem();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                                return (Integer)object;
                            }
                        }), (Function1)((Function1)new Function1<Integer, Unit>(this.$modulesCacheModel){
                            final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
                            {
                                this.$modulesCacheModel = $modulesCacheModel;
                                super(1);
                            }

                            public final void invoke(@Nullable Integer it) {
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
                                this.$modulesCacheModel.setSelectedItem(it);
                            }
                        })), (String)"Modules cache:", null, (int)2, null).enabled(false);
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$appConsoleView){
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(this.$appConsoleView.getComponent()).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        return new Pair((Object)appPanel2, (Object)appConsoleView);
    }

    private final DialogPanel createIndexViewer(Project project) {
        JBTextArea textArea = new JBTextArea((Document)new DefaultStyledDocument());
        textArea.setEditable(false);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, textArea, project){
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ JBTextArea $textArea;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$textArea = $textArea;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$textArea, this.$project){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ JBTextArea $textArea;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$textArea = $textArea;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0)){

                            @Nullable
                            public Object get() {
                                return ((IndexViewerState)this.receiver).getQuery();
                            }

                            public void set(@Nullable Object value) {
                                ((IndexViewerState)this.receiver).setQuery((String)value);
                            }
                        })).align((Align)AlignX.FILL.INSTANCE).resizableColumn().focused();
                        ButtonKt.bindSelected((Cell)$this$row.checkBox("Only CLion Index"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0)){

                            @Nullable
                            public Object get() {
                                return ((IndexViewerState)this.receiver).getOnlyCLionIndex();
                            }

                            public void set(@Nullable Object value) {
                                ((IndexViewerState)this.receiver).setOnlyCLionIndex((Boolean)value);
                            }
                        }));
                        $this$row.button("QueryS", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$textArea, this.$project){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ JBTextArea $textArea;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$textArea = $textArea;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ClangdIndexerPanel.access$runQuery(this.this$0, this.$textArea, this.$project, (Function1)new Function1<ClangLanguageService, List<? extends CLionSymbolInformation>>(this.this$0){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    @Nullable
                                    public final List<CLionSymbolInformation> invoke(@NotNull ClangLanguageService service) {
                                        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                                        CompletableFuture<List<CLionSymbolInformation>> completableFuture = service.getSymbols(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getQuery(), ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getOnlyCLionIndex());
                                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getSymbols(...)");
                                        CompletableFuture<List<CLionSymbolInformation>> symbolsFuture = completableFuture;
                                        return (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)symbolsFuture, (String)"workspace/symbols");
                                    }
                                });
                            }
                        }).gap(RightGap.SMALL);
                        $this$row.button("QueryR", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$textArea, this.$project){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ JBTextArea $textArea;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$textArea = $textArea;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ClangdIndexerPanel.access$runQuery(this.this$0, this.$textArea, this.$project, (Function1)new Function1<ClangLanguageService, List<? extends ClangFoundUsage>>(this.this$0){
                                    final /* synthetic */ ClangdIndexerPanel this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    @Nullable
                                    public final List<ClangFoundUsage> invoke(@NotNull ClangLanguageService service) {
                                        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                                        CompletableFuture<List<ClangFoundUsage>> completableFuture = service.getReferences(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getQuery(), ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getOnlyCLionIndex());
                                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getReferences(...)");
                                        CompletableFuture<List<ClangFoundUsage>> refsFuture = completableFuture;
                                        return (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)refsFuture, (String)"clionReferences");
                                    }
                                });
                            }
                        });
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$textArea){
                    final /* synthetic */ JBTextArea $textArea;
                    {
                        this.$textArea = $textArea;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.scrollCell((JComponent)this.$textArea).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    private final <T> void runQuery(JBTextArea textArea, Project project, Function1<? super ClangLanguageService, ? extends List<? extends T>> query) {
        if (this.queryRunning) {
            textArea.setText("Query is already in progress...");
            return;
        }
        DialogPanel dialogPanel = this.indexViewerState.getIndexViewer();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        if (service == null) {
            textArea.setText("Service is not started yet!");
            return;
        }
        this.queryRunning = true;
        ReadAction.nonBlocking(() -> ClangdIndexerPanel.runQuery$lambda$1(query, service)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> ClangdIndexerPanel.runQuery$lambda$2((Function1)new Function1<List<? extends T>, Unit>(this, textArea){
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ JBTextArea $textArea;
            {
                this.this$0 = $receiver;
                this.$textArea = $textArea;
                super(1);
            }

            public final void invoke(@Nullable List<? extends T> it) {
                ClangdIndexerPanel.access$setQueryRunning$p(this.this$0, false);
                Collection collection = it;
                if (collection == null || collection.isEmpty()) {
                    this.$textArea.setText("Empty result");
                    return;
                }
                StringBuilder sb = new StringBuilder();
                Iterator<T> iterator = it.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int counter = n++;
                    T item = iterator.next();
                    sb.append(counter + 1 + ". " + item + "\n");
                }
                this.$textArea.setText(sb.toString());
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - void declaration
     */
    private final void connectToService(ClangLanguageService service, ConsoleView lspView, ConsoleView appView) {
        if (service == null) {
            return;
        }
        if (service instanceof ClangdIndexerService) {
            List<String> list;
            Object object = ((ClangdIndexerService)service).getCopyOfAppLog();
            Iterable<String> it = object;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            List<String> list2 = list = !((Collection)it).isEmpty() ? object : null;
            if (list != null) {
                void $this$reduce$iv;
                it = list;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void right;
                    String string = (String)iterator$iv.next();
                    String left = (String)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = left + "\n" + (String)right;
                }
                object = (String)accumulator$iv;
                if (object != null) {
                    Object object2;
                    Object object3;
                    Object it2 = object3 = object;
                    boolean bl3 = false;
                    Object object4 = object2 = ((CharSequence)it2).length() > 0 ? object3 : null;
                    if (object2 != null) {
                        it2 = object3 = object2;
                        boolean bl4 = false;
                        ClangdIndexerPanelKt.access$printConsole(appView, (String)it2);
                    }
                }
            }
            ((ClangdIndexerService)service).addPausedListener(arg_0 -> ClangdIndexerPanel.connectToService$lambda$8(this, arg_0));
        }
        MessageBusConnection messageBusConnection = service.getMessageBus().connect((Disposable)this);
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangServerListener(service, this, lspView, appView){
            private boolean indexStartedCame;
            private int lastReportedPercent;
            final /* synthetic */ ClangLanguageService $service;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $lspView;
            final /* synthetic */ ConsoleView $appView;
            {
                this.$service = $service;
                this.this$0 = $receiver;
                this.$lspView = $lspView;
                this.$appView = $appView;
                this.lastReportedPercent = -1;
            }

            public final boolean getIndexStartedCame() {
                return this.indexStartedCame;
            }

            public final void setIndexStartedCame(boolean bl) {
                this.indexStartedCame = bl;
            }

            public final int getLastReportedPercent() {
                return this.lastReportedPercent;
            }

            public final void setLastReportedPercent(int n) {
                this.lastReportedPercent = n;
            }

            public void onMessage(@NotNull Message message, boolean incoming) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String contents = message.toString();
                ClangMessagesFilter clangMessagesFilter = this.$service.getContext().getMessagesFilter();
                String string = contents;
                Intrinsics.checkNotNull((Object)string);
                if (clangMessagesFilter.matchesBlockedRequestOrReply(string)) {
                    return;
                }
                String truncated = this.this$0.truncateIfNecessary(contents);
                contents = null;
                Function0 edt2 = (Function0)new Function0<Unit>(incoming, this.$lspView, truncated){
                    final /* synthetic */ boolean $incoming;
                    final /* synthetic */ ConsoleView $lspView;
                    final /* synthetic */ String $truncated;
                    {
                        this.$incoming = $incoming;
                        this.$lspView = $lspView;
                        this.$truncated = $truncated;
                        super(0);
                    }

                    public final void invoke() {
                        String string = ClangdIndexerPanelKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis());
                        Intrinsics.checkNotNull((Object)string);
                        String linkText = string + " " + (this.$incoming ? "-->" : "<--");
                        this.$lspView.printHyperlink(linkText, arg_0 -> connectToService.onMessage.edt.1.invoke$lambda$0(this.$truncated, linkText, arg_0));
                        this.$lspView.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                        this.$lspView.print(ClangdIndexerPanelKt.access$toOneLine(this.$truncated), ConsoleViewContentType.NORMAL_OUTPUT);
                        this.$lspView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    }

                    private static final void invoke$lambda$0(String $truncated, String $linkText, Project it) {
                        Intrinsics.checkNotNullParameter((Object)$truncated, (String)"$truncated");
                        Intrinsics.checkNotNullParameter((Object)$linkText, (String)"$linkText");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ClangdIndexerPanelKt.access$showJsonInEditor(it, $truncated, $linkText);
                    }
                };
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> connectToService.6.onMessage$lambda$0(edt2));
            }

            public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            public void onIndexingProgress(int percentage, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (this.indexStartedCame) {
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing started: " + message);
                    this.indexStartedCame = false;
                }
                if (percentage != this.lastReportedPercent) {
                    this.lastReportedPercent = percentage;
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Progress: " + percentage + "%");
                }
            }

            public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String path) {
                Intrinsics.checkNotNullParameter(deletedSymbolsPaths, (String)"deletedSymbolsPaths");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing finished! " + deletedSymbolsPaths.size() + " deleted (" + path + ")");
            }

            public void onIndexingMessage(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ClangdIndexerPanelKt.access$printConsole(this.$appView, message);
            }

            private static final void onMessage$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke();
            }
        });
    }

    private final ClangLanguageService getIfStartedIndexer(Project project) {
        return ClangdIndexerPanelKt.getIfStartedIndexer(project, this.isStateful);
    }

    private static final Filter.Result createLspLog$lambda$0(Pattern $methodPattern, TextAttributes $methodHighlightAttrs, String line, int length) {
        Filter.Result result;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = $methodPattern.matcher(line);
        int lineStartOffset = length - line.length();
        if (matcher.find()) {
            int groupStart = lineStartOffset + matcher.start(1);
            int groupEnd = lineStartOffset + matcher.end(1);
            result = new Filter.Result(groupStart, groupEnd, null, $methodHighlightAttrs);
        } else {
            result = null;
        }
        return result;
    }

    private static final List runQuery$lambda$1(Function1 $query, ClangLanguageService $service) {
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        return (List)$query.invoke((Object)$service);
    }

    private static final void runQuery$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void connectToService$lambda$8$lambda$7(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void connectToService$lambda$8(ClangdIndexerPanel this$0, Boolean paused) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function0 edt2 = (Function0)new Function0<Unit>(this$0, paused){
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ Boolean $paused;
            {
                this.this$0 = $receiver;
                this.$paused = $paused;
                super(0);
            }

            public final void invoke() {
                JButton jButton = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getPauseButton();
                if (jButton != null) {
                    Boolean bl = this.$paused;
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"$paused");
                    jButton.setText(bl != false ? "Unpause" : "Pause");
                }
            }
        };
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ClangdIndexerPanel.connectToService$lambda$8$lambda$7(edt2));
    }

    public static final /* synthetic */ IndexAppState access$getIndexAppState$p(ClangdIndexerPanel $this) {
        return $this.indexAppState;
    }

    public static final /* synthetic */ ClangLanguageService access$getIfStartedIndexer(ClangdIndexerPanel $this, Project project) {
        return $this.getIfStartedIndexer(project);
    }

    public static final /* synthetic */ IndexViewerState access$getIndexViewerState$p(ClangdIndexerPanel $this) {
        return $this.indexViewerState;
    }

    public static final /* synthetic */ void access$runQuery(ClangdIndexerPanel $this, JBTextArea textArea, Project project, Function1 query) {
        $this.runQuery(textArea, project, query);
    }

    public static final /* synthetic */ void access$setQueryRunning$p(ClangdIndexerPanel $this, boolean bl) {
        $this.queryRunning = bl;
    }
}

