/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangIndexerCustomCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.CmdAndArg;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexAppState;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangIndexerCustomCommandDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "appState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "isStateful", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;Z)V", "getAppState", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "cmdAndArg", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/CmdAndArg;", "getCmdAndArg", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/CmdAndArg;", "()Z", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "executeCommand", "intellij.c.clangd"})
final class ClangIndexerCustomCommandDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexAppState appState;
    private final boolean isStateful;
    private DialogPanel panel;
    @NotNull
    private final CmdAndArg cmdAndArg;

    public ClangIndexerCustomCommandDialog(@NotNull Project project, @NotNull IndexAppState appState, boolean isStateful) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appState, (String)"appState");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.appState = appState;
        this.isStateful = isStateful;
        this.cmdAndArg = new CmdAndArg(null, null, 3, null);
        this.setTitle("Specify indexer command");
        this.setOKButtonText("Execute");
        this.init();
        this.initValidation();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IndexAppState getAppState() {
        return this.appState;
    }

    public final boolean isStateful() {
        return this.isStateful;
    }

    @NotNull
    public final CmdAndArg getCmdAndArg() {
        return this.cmdAndArg;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ ClangIndexerCustomCommandDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row("Command:", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangIndexerCustomCommandDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldWithStoredHistory textField = new TextFieldWithStoredHistory("CLANG_INDEXER_COMMAND_FIELD");
                        $this$row.cell((JComponent)textField).align((Align)AlignX.FILL.INSTANCE).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getCmdAndArg()){

                            @Nullable
                            public Object get() {
                                return ((CmdAndArg)this.receiver).getCommand();
                            }

                            public void set(@Nullable Object value) {
                                ((CmdAndArg)this.receiver).setCommand((String)value);
                            }
                        }))).validationOnInput((Function2)createCenterPanel.4.INSTANCE).validationOnApply((Function2)createCenterPanel.5.INSTANCE).onApply((Function0)new Function0<Unit>(textField){
                            final /* synthetic */ TextFieldWithStoredHistory $textField;
                            {
                                this.$textField = $textField;
                                super(0);
                            }

                            public final void invoke() {
                                this.$textField.addCurrentTextToHistory();
                            }
                        }).focused();
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangIndexerCustomCommandDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EditorTextField textEditor = new EditorTextField(this.this$0.getProject(), (FileType)PlainTextFileType.INSTANCE);
                        textEditor.setOneLineMode(false);
                        textEditor.setFontInheritedFromLAF(false);
                        textEditor.setFont(EditorUtil.getEditorFont());
                        $this$row.cell((JComponent)textEditor).align(Align.FILL).label("Arguments:", LabelPosition.TOP).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getCmdAndArg()){

                            @Nullable
                            public Object get() {
                                return ((CmdAndArg)this.receiver).getArguments();
                            }

                            public void set(@Nullable Object value) {
                                ((CmdAndArg)this.receiver).setArguments((String)value);
                            }
                        })));
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangIndexerCommandDialog", this.project)) == null) {
            dimension = (Dimension)JBUI.size((int)640, (int)480);
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.executeCommand();
    }

    private final void executeCommand() {
        ConsoleView consoleView = this.appState.getAppConsoleView();
        if (consoleView == null) {
            ClangdIndexerPanelKt.access$showNotification(this.project, "Indexer App Console is not created yet!");
            return;
        }
        ConsoleView appConsoleView = consoleView;
        ClangdIndexerPanelKt.access$runIndexerCommand(this.project, appConsoleView, this.isStateful, new ClangIndexerCommand(this.cmdAndArg.getCommand(), this.cmdAndArg.getArguments()));
    }

    private static final ValidationInfo createCenterPanel$validator(ValidationInfoBuilder $this$createCenterPanel_u24validator, JTextField it, String message) {
        CharSequence charSequence = it.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$createCenterPanel_u24validator.error(message) : null;
    }

    public static final /* synthetic */ ValidationInfo access$createCenterPanel$validator(ValidationInfoBuilder $receiver, JTextField it, String message) {
        return ClangIndexerCustomCommandDialog.createCenterPanel$validator($receiver, it, message);
    }
}

