/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangExecuteCommandActionKt;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommandDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommand;", "getCommand", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommand;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "executeCommand", "intellij.c.clangd"})
final class ClangCommandDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    private DialogPanel panel;
    @NotNull
    private final ClangCommand command;

    public ClangCommandDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.command = new ClangCommand(false, null, null, 7, null);
        this.setTitle(ClangdBundle.message("execute.command.dialog.title", new Object[0]));
        this.setOKButtonText(ClangdBundle.message("execute.command.ok.button.text", new Object[0]));
        this.init();
        this.initValidation();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ClangCommand getCommand() {
        return this.command;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ ClangCommandDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = ClangdBundle.message("clangd.execute.command.panel.label.request", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangCommandDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.execute.command.panel.label.request", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getCommand()){

                            @Nullable
                            public Object get() {
                                return ((ClangCommand)this.receiver).getRequest();
                            }

                            public void set(@Nullable Object value) {
                                ((ClangCommand)this.receiver).setRequest((Boolean)value);
                            }
                        }));
                    }
                });
                String string2 = ClangdBundle.message("clangd.execute.command.panel.label.method", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangCommandDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldWithStoredHistory textField = new TextFieldWithStoredHistory("CLANG_METHOD_NAME_FIELD");
                        $this$row.cell((JComponent)textField).align((Align)AlignX.FILL.INSTANCE).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getCommand()){

                            @Nullable
                            public Object get() {
                                return ((ClangCommand)this.receiver).getMethod();
                            }

                            public void set(@Nullable Object value) {
                                ((ClangCommand)this.receiver).setMethod((String)value);
                            }
                        }))).validationOnInput((Function2)createCenterPanel.4.INSTANCE).validationOnApply((Function2)createCenterPanel.5.INSTANCE).onApply((Function0)new Function0<Unit>(textField){
                            final /* synthetic */ TextFieldWithStoredHistory $textField;
                            {
                                this.$textField = $textField;
                                super(0);
                            }

                            public final void invoke() {
                                this.$textField.addCurrentTextToHistory();
                            }
                        }).focused();
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangCommandDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EditorTextField textEditor = new EditorTextField(this.this$0.getProject(), (FileType)JsonFileType.INSTANCE);
                        textEditor.setOneLineMode(false);
                        textEditor.setFontInheritedFromLAF(false);
                        textEditor.setFont(EditorUtil.getEditorFont());
                        Cell cell = $this$row.cell((JComponent)textEditor).align(Align.FILL);
                        String string = ClangdBundle.message("clangd.execute.command.panel.label.params", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        cell.label(string, LabelPosition.TOP).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getCommand()){

                            @Nullable
                            public Object get() {
                                return ((ClangCommand)this.receiver).getParams();
                            }

                            public void set(@Nullable Object value) {
                                ((ClangCommand)this.receiver).setParams((String)value);
                            }
                        }))).validationOnApply((Function2)new Function2<ValidationInfoBuilder, EditorTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ ClangCommandDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull EditorTextField it) {
                                ValidationInfo validationInfo;
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                try {
                                    this.this$0.getCommand().parseParams();
                                    validationInfo = null;
                                }
                                catch (JsonParseException ex) {
                                    String string = ex.getMessage();
                                    if (string == null) {
                                        string = "";
                                    }
                                    validationInfo = $this$validationOnApply.error(string);
                                }
                                return validationInfo;
                            }
                        });
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangCommandDialog")) == null) {
            dimension = (Dimension)JBUI.size((int)640, (int)480);
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.executeCommand();
    }

    private final void executeCommand() {
        JsonElement jsonElement;
        try {
            jsonElement = this.command.parseParams();
        }
        catch (JsonParseException ex) {
            String string = ClangdBundle.message("clangd.execute.command.panel.notify.invalid.json", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ClangExecuteCommandActionKt.access$showNotification(this.project, string);
            return;
        }
        JsonElement params = jsonElement;
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        if (clangLanguageServiceProvider == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ClangLanguageServiceProvider not found");
            return;
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        ClangLanguageService clangLanguageService = provider2.getIfStarted();
        ClangdLanguageService clangdLanguageService = clangLanguageService instanceof ClangdLanguageService ? (ClangdLanguageService)clangLanguageService : null;
        if (clangdLanguageService == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ClangdLanguageService not found");
            return;
        }
        ClangdLanguageService service = clangdLanguageService;
        Endpoint endpoint = service.remoteEndpoint();
        if (endpoint == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ServerConnection not found");
            return;
        }
        Endpoint endpoint2 = endpoint;
        if (this.command.getRequest()) {
            endpoint2.request(this.command.getMethod(), (Object)params);
        } else {
            endpoint2.notify(this.command.getMethod(), (Object)params);
        }
    }

    private static final ValidationInfo createCenterPanel$validator(ValidationInfoBuilder $this$createCenterPanel_u24validator, JTextField it, String message) {
        CharSequence charSequence = it.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$createCenterPanel_u24validator.error(message) : null;
    }

    public static final /* synthetic */ ValidationInfo access$createCenterPanel$validator(ValidationInfoBuilder $receiver, JTextField it, String message) {
        return ClangCommandDialog.createCenterPanel$validator($receiver, it, message);
    }
}

